/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbiakov.codeview.highlight.prettify.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Util {
    protected Util() {
    }

    public static Boolean getVariableValueAsBoolean(Object var) {
        Boolean returnResult = null;
        returnResult = var == null ? Boolean.valueOf(false) : (var instanceof String ? Boolean.valueOf(!((String)var).isEmpty()) : (var instanceof Integer ? Boolean.valueOf((Integer)var != 0) : (var instanceof Boolean ? (Boolean)var : Boolean.valueOf(true))));
        return returnResult;
    }

    public static Integer getVariableValueAsInteger(Object var) {
        if (var == null) {
            throw new NullPointerException("argument 'var' cannot be null");
        }
        Integer returnResult = -1;
        if (var instanceof Integer) {
            returnResult = (Integer)var;
        } else if (var instanceof Boolean) {
            returnResult = (Boolean)var != false ? 1 : 0;
        } else {
            throw new IllegalArgumentException("'var' is neither integer nor boolean");
        }
        return returnResult;
    }

    public static String[] match(Pattern pattern, String string, boolean isGlobal) {
        if (pattern == null) {
            throw new NullPointerException("argument 'pattern' cannot be null");
        }
        if (string == null) {
            throw new NullPointerException("argument 'string' cannot be null");
        }
        ArrayList<String> matchesList = new ArrayList<String>();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            matchesList.add(matcher.group(0));
            if (isGlobal) continue;
            int iEnd = matcher.groupCount();
            for (int i = 1; i <= iEnd; ++i) {
                matchesList.add(matcher.group(i));
            }
        }
        return matchesList.toArray(new String[matchesList.size()]);
    }

    public static boolean test(Pattern pattern, String string) {
        if (pattern == null) {
            throw new NullPointerException("argument 'pattern' cannot be null");
        }
        if (string == null) {
            throw new NullPointerException("argument 'string' cannot be null");
        }
        return pattern.matcher(string).find();
    }

    public static String join(List<String> strings) {
        if (strings == null) {
            throw new NullPointerException("argument 'strings' cannot be null");
        }
        return Util.join(strings.toArray(new String[strings.size()]));
    }

    public static String join(List<String> strings, String delimiter) {
        if (strings == null) {
            throw new NullPointerException("argument 'strings' cannot be null");
        }
        return Util.join(strings.toArray(new String[strings.size()]), delimiter);
    }

    public static String join(String[] strings) {
        return Util.join(strings, null);
    }

    public static String join(String[] strings, String delimiter) {
        if (strings == null) {
            throw new NullPointerException("argument 'strings' cannot be null");
        }
        StringBuilder sb = new StringBuilder();
        if (strings.length != 0) {
            sb.append(strings[0]);
            int iEnd = strings.length;
            for (int i = 1; i < iEnd; ++i) {
                if (delimiter != null) {
                    sb.append(delimiter);
                }
                sb.append(strings[i]);
            }
        }
        return sb.toString();
    }

    public static List<Object> removeDuplicates(List<Object> decorations, String source) {
        if (decorations == null) {
            throw new NullPointerException("argument 'decorations' cannot be null");
        }
        if (source == null) {
            throw new NullPointerException("argument 'source' cannot be null");
        }
        if ((decorations.size() & 1) != 0) {
            throw new IllegalArgumentException("the size of argument 'decorations' should be a multiple of 2");
        }
        ArrayList<Object> returnList = new ArrayList<Object>();
        TreeMap<Integer, Object> orderedMap = new TreeMap<Integer, Object>();
        int iEnd = decorations.size();
        for (int i = 0; i < iEnd; i += 2) {
            orderedMap.put((Integer)decorations.get(i), decorations.get(i + 1));
        }
        String previousStyle = null;
        for (Integer pos : orderedMap.keySet()) {
            String style = (String)orderedMap.get(pos);
            if (previousStyle != null && previousStyle.equals(style)) continue;
            returnList.add(pos);
            returnList.add(style);
            previousStyle = style;
        }
        int returnListSize = returnList.size();
        if (returnListSize >= 4 && returnList.get(returnListSize - 2).equals(source.length())) {
            returnList.remove(returnListSize - 2);
            returnList.remove(returnListSize - 2);
        }
        return returnList;
    }
}

