/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbiakov.codeview.classifier;

import android.content.Context;
import android.util.Log;
import io.github.kbiakov.codeview.Files;
import io.github.kbiakov.codeview.UtilsKt;
import io.github.kbiakov.codeview.classifier.BayesClassifier;
import io.github.kbiakov.codeview.classifier.Classification;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/github/kbiakov/codeview/classifier/CodeClassifier;", "", "()V", "DEFAULT_LANGUAGE", "", "TAG", "TRAINING_SET_FOLDER", "classifier", "Lio/github/kbiakov/codeview/classifier/BayesClassifier;", "classify", "snippet", "train", "", "context", "Landroid/content/Context;", "codeview_release"})
public final class CodeClassifier {
    @NotNull
    public static final String TAG = "CodeClassifier";
    @NotNull
    public static final String DEFAULT_LANGUAGE = "js";
    private static final String TRAINING_SET_FOLDER = "training-set";
    private static final BayesClassifier<String, String> classifier;
    public static final CodeClassifier INSTANCE;

    public final void train(@NotNull Context context) {
        String[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String[] stringArray = Files.INSTANCE.ls(context, TRAINING_SET_FOLDER);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"Files.ls(context, TRAINING_SET_FOLDER)");
        String[] stringArray2 = $receiver$iv = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String language = element$iv = stringArray2[i];
            String path = TRAINING_SET_FOLDER + '/' + language;
            String content = Files.INSTANCE.content(context, path);
            String string2 = language;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"language");
            classifier.learn(string2, (Collection<String>)UtilsKt.spaceSplit(content));
        }
        Log.i((String)TAG, (String)"Classifier trained");
    }

    @NotNull
    public final String classify(@NotNull String snippet) {
        Intrinsics.checkParameterIsNotNull((Object)snippet, (String)"snippet");
        Classification<String, String> feature = classifier.classify((Collection<String>)UtilsKt.spaceSplit(snippet));
        Classification<String, String> classification = feature;
        if (classification == null || (classification = classification.getCategory()) == null) {
            classification = DEFAULT_LANGUAGE;
        }
        return classification;
    }

    private CodeClassifier() {
    }

    static {
        CodeClassifier codeClassifier;
        INSTANCE = codeClassifier = new CodeClassifier();
        TRAINING_SET_FOLDER = TRAINING_SET_FOLDER;
        classifier = new BayesClassifier();
    }
}

