/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbiakov.codeview.highlight.parser;

import java.util.ArrayList;
import java.util.List;

public class ParseResult {
    protected int offset;
    protected int length;
    protected List<String> styleKeys;

    public ParseResult(int offset, int length, List<String> styleKeys) {
        this.offset = offset;
        this.length = length;
        this.styleKeys = new ArrayList<String>(styleKeys);
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getStyleKeysString() {
        StringBuilder sb = new StringBuilder(10);
        int iEnd = this.styleKeys.size();
        for (int i = 0; i < iEnd; ++i) {
            if (i != 0) {
                sb.append(" ");
            }
            sb.append(this.styleKeys.get(i));
        }
        return sb.toString();
    }

    public void setStyleKeys(List<String> styleKeys) {
        this.styleKeys = new ArrayList<String>(styleKeys);
    }

    public boolean addStyleKey(String styleKey) {
        return this.styleKeys.add(styleKey);
    }

    public boolean removeStyleKey(String styleKey) {
        return this.styleKeys.remove(styleKey);
    }

    public void clearStyleKeys() {
        this.styleKeys.clear();
    }

    public List<String> getStyleKeys() {
        return new ArrayList<String>(this.styleKeys);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.offset);
        sb.append("; ");
        sb.append(this.length);
        sb.append("; ");
        int iEnd = this.styleKeys.size();
        for (int i = 0; i < iEnd; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.styleKeys.get(i));
        }
        sb.append("]");
        return sb.toString();
    }
}

