/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbiakov.codeview.highlight;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import io.github.kbiakov.codeview.highlight.Font;
import java.util.Map;
import java.util.WeakHashMap;

public class FontCache {
    private static volatile FontCache instance;
    private Map<String, Typeface> fonts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FontCache get(Context context) {
        FontCache localInstance = instance;
        if (localInstance != null) return localInstance;
        Class<FontCache> clazz = FontCache.class;
        synchronized (FontCache.class) {
            localInstance = instance;
            if (localInstance != null) return localInstance;
            instance = localInstance = new FontCache(context);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localInstance;
        }
    }

    private FontCache(final Context context) {
        this.fonts = new WeakHashMap<String, Typeface>(){
            {
                String fontPath = FontCache.getLocalFontPath(Font.Companion.getDefault());
                this.put(fontPath, FontCache.loadFont(context, fontPath));
            }
        };
    }

    private static String getLocalFontPath(Font font) {
        return String.format("%s.ttf", FontCache.getLocalFontPath(font.name()));
    }

    private static String getLocalFontPath(String fontName) {
        return String.format("fonts/%s", fontName);
    }

    private static Typeface loadFont(Context context, String fontPath) {
        return Typeface.createFromAsset((AssetManager)context.getAssets(), (String)fontPath);
    }

    public Typeface getTypeface(Context context) {
        return this.getTypeface(context, Font.Companion.getDefault());
    }

    public Typeface getTypeface(Context context, Font font) {
        return this.getTypeface(context, FontCache.getLocalFontPath(font));
    }

    public Typeface getLocalTypeface(Context context, String fontPath) {
        return this.getTypeface(context, FontCache.getLocalFontPath(fontPath));
    }

    public Typeface getTypeface(Context context, String fontPath) {
        Typeface font = this.fonts.get(fontPath);
        if (font != null) {
            return font;
        }
        font = FontCache.loadFont(context, fontPath);
        this.fonts.put(fontPath, font);
        return font;
    }

    public void saveTypeface(Typeface fontTypeface) {
        this.fonts.put(fontTypeface.toString(), fontTypeface);
    }
}

