/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbiakov.codeview.adapters;

import android.content.Context;
import android.graphics.Typeface;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.github.kbiakov.codeview.OnCodeLineClickListener;
import io.github.kbiakov.codeview.R;
import io.github.kbiakov.codeview.Thread;
import io.github.kbiakov.codeview.UtilsKt;
import io.github.kbiakov.codeview.adapters.Options;
import io.github.kbiakov.codeview.classifier.CodeClassifier;
import io.github.kbiakov.codeview.classifier.CodeProcessor;
import io.github.kbiakov.codeview.highlight.CodeHighlighter;
import io.github.kbiakov.codeview.highlight.CodeHighlighterKt;
import io.github.kbiakov.codeview.highlight.MonoFontCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0012\b&\u0018\u0000 K*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0002KLB\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u001b\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00028\u0000\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020\bH\u0002J%\u0010(\u001a\u00020)2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010%\u001a\u00028\u00002\u0006\u0010*\u001a\u00020+H&\u00a2\u0006\u0002\u0010,J\u0018\u0010-\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0003H\u0002J\b\u0010.\u001a\u00020\u0017H\u0016J\u001b\u0010/\u001a\u00020 2\f\u00100\u001a\b\u0012\u0004\u0012\u00020 01H\u0000\u00a2\u0006\u0002\b2J\u001e\u00103\u001a\u00020 2\u0006\u00104\u001a\u00020\b2\f\u00100\u001a\b\u0012\u0004\u0012\u00020 01H\u0002J\u0010\u00105\u001a\n 7*\u0004\u0018\u00010606H\u0002J\u0018\u00108\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0017H\u0016J\u0018\u00109\u001a\u00020\u00032\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u0017H\u0016J\r\u0010=\u001a\u00020 H\u0000\u00a2\u0006\u0002\b>J \u0010?\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00172\u0006\u0010@\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u0015\u0010A\u001a\u00020 2\u0006\u0010B\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\bCJ\u0015\u0010A\u001a\u00020 2\u0006\u0010D\u001a\u00020\bH\u0000\u00a2\u0006\u0002\bCJ\u001e\u0010E\u001a\u00020 2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020 01H\u0002J\f\u0010G\u001a\u00020+*\u00020\u0017H\u0002J\f\u0010*\u001a\u00020+*\u00020\u0017H\u0002J\f\u0010H\u001a\u00020+*\u00020\u0017H\u0002J\f\u0010I\u001a\u00020+*\u00020\u0017H\u0002J\f\u0010J\u001a\u00020+*\u00020\u0017H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\"\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00100\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u001a\u0010\n\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006M"}, d2={"Lio/github/kbiakov/codeview/adapters/AbstractCodeAdapter;", "T", "Landroid/support/v7/widget/RecyclerView$Adapter;", "Lio/github/kbiakov/codeview/adapters/AbstractCodeAdapter$ViewHolder;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "code", "", "(Landroid/content/Context;Ljava/lang/String;)V", "options", "Lio/github/kbiakov/codeview/adapters/Options;", "(Landroid/content/Context;Lio/github/kbiakov/codeview/adapters/Options;)V", "getContext", "()Landroid/content/Context;", "droppedLines", "", "getDroppedLines", "()Ljava/util/List;", "setDroppedLines", "(Ljava/util/List;)V", "footerEntities", "Ljava/util/HashMap;", "", "lines", "getLines", "setLines", "getOptions$codeview_compileReleaseKotlin", "()Lio/github/kbiakov/codeview/adapters/Options;", "setOptions$codeview_compileReleaseKotlin", "(Lio/github/kbiakov/codeview/adapters/Options;)V", "addExtraPadding", "", "position", "holder", "addFooterEntity", "num", "entity", "(ILjava/lang/Object;)V", "classifyContent", "createFooter", "Landroid/view/View;", "isFirst", "", "(Landroid/content/Context;Ljava/lang/Object;Z)Landroid/view/View;", "displayLineFooter", "getItemCount", "highlight", "onReady", "Lkotlin/Function0;", "highlight$codeview_compileReleaseKotlin", "highlighting", "language", "monoTypeface", "Landroid/graphics/Typeface;", "kotlin.jvm.PlatformType", "onBindViewHolder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "prepareCodeLines", "prepareCodeLines$codeview_compileReleaseKotlin", "setupLine", "line", "updateCode", "opts", "updateCode$codeview_compileReleaseKotlin", "newContent", "updateContent", "onUpdated", "isBorder", "isJustFirst", "isJustLast", "isLast", "Companion", "ViewHolder", "codeview-compileReleaseKotlin"})
public abstract class AbstractCodeAdapter<T>
extends RecyclerView.Adapter<ViewHolder> {
    @NotNull
    private final Context context;
    @NotNull
    private List<String> lines;
    @Nullable
    private List<String> droppedLines;
    @NotNull
    private Options options;
    private HashMap<Integer, List<T>> footerEntities;
    public static final int MAX_SHORTCUT_LINES = 6;
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final Context getContext() {
        return this.context;
    }

    @NotNull
    protected final List<String> getLines() {
        return this.lines;
    }

    protected final void setLines(@NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.lines = list;
    }

    @Nullable
    protected final List<String> getDroppedLines() {
        return this.droppedLines;
    }

    protected final void setDroppedLines(@Nullable List<String> list) {
        this.droppedLines = list;
    }

    @NotNull
    public final Options getOptions$codeview_compileReleaseKotlin() {
        return this.options;
    }

    public final void setOptions$codeview_compileReleaseKotlin(@NotNull Options options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"<set-?>");
        this.options = options;
    }

    public final void prepareCodeLines$codeview_compileReleaseKotlin() {
        boolean isFullShowing;
        List<String> allLines = UtilsKt.extractLines(this.options.getCode());
        boolean bl = isFullShowing = !this.options.getShortcut() || allLines.size() <= this.options.getMaxLines();
        if (isFullShowing) {
            this.lines = allLines;
        } else {
            ArrayList<String> resultLines = new ArrayList<String>((Collection)allLines.subList(0, this.options.getMaxLines()));
            String string = this.options.getShortcutNote();
            ArrayList<String> arrayList = resultLines;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
            String string4 = string3;
            arrayList.add(string4);
            this.lines = resultLines;
            this.droppedLines = new ArrayList(allLines.subList(this.options.getMaxLines(), CollectionsKt.getLastIndex(allLines)));
        }
    }

    public final void updateCode$codeview_compileReleaseKotlin(@NotNull String newContent) {
        Intrinsics.checkParameterIsNotNull((Object)newContent, (String)"newContent");
        this.options.setCode(newContent);
        this.prepareCodeLines$codeview_compileReleaseKotlin();
        this.notifyDataSetChanged();
    }

    public final void updateCode$codeview_compileReleaseKotlin(@NotNull Options opts) {
        Intrinsics.checkParameterIsNotNull((Object)opts, (String)"opts");
        this.options = opts;
        this.prepareCodeLines$codeview_compileReleaseKotlin();
        this.notifyDataSetChanged();
    }

    public final void addFooterEntity(int num, T entity) {
        List list = this.footerEntities.get(num);
        if (list == null) {
            list = new ArrayList();
        }
        List notes = list;
        this.footerEntities.put(num, CollectionsKt.plus((Collection)notes, entity));
        this.notifyDataSetChanged();
    }

    public final void highlight$codeview_compileReleaseKotlin(@NotNull Function0<Unit> onReady) {
        Intrinsics.checkParameterIsNotNull(onReady, (String)"onReady");
        Thread.INSTANCE.async((Function0<Unit>)((Function0)new Function0<Unit>(this, onReady){
            final /* synthetic */ AbstractCodeAdapter this$0;
            final /* synthetic */ Function0 $onReady;

            public final void invoke() {
                String string2 = this.this$0.getOptions$codeview_compileReleaseKotlin().getLanguage();
                if (string2 == null) {
                    string2 = AbstractCodeAdapter.access$classifyContent(this.this$0);
                }
                String language = string2;
                AbstractCodeAdapter.access$highlighting(this.this$0, language, this.$onReady);
            }
            {
                this.this$0 = abstractCodeAdapter;
                this.$onReady = function0;
                super(0);
            }
        }));
    }

    @NotNull
    public abstract View createFooter(@NotNull Context var1, T var2, boolean var3);

    private final String classifyContent() {
        String string;
        CodeProcessor processor = CodeProcessor.getInstance(this.context);
        if (processor.isTrained()) {
            String string2 = processor.classify(this.options.getCode()).get();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"processor.classify(options.code).get()");
        } else {
            string = CodeClassifier.DEFAULT_LANGUAGE;
        }
        return string;
    }

    private final void highlighting(String language, Function0<Unit> onReady) {
        String code = CodeHighlighter.INSTANCE.highlight(language, this.options.getCode(), this.options.getTheme());
        this.updateContent(code, onReady);
    }

    private final void updateContent(String code, Function0<Unit> onUpdated) {
        this.options.setCode(code);
        this.prepareCodeLines$codeview_compileReleaseKotlin();
        Thread.INSTANCE.ui((Function0<Unit>)((Function0)new Function0<Unit>(onUpdated){
            final /* synthetic */ Function0 $onUpdated;

            public final void invoke() {
                this.$onUpdated.invoke();
            }
            {
                this.$onUpdated = function0;
                super(0);
            }
        }));
    }

    private final Typeface monoTypeface() {
        return MonoFontCache.getInstance(this.context).getTypeface();
    }

    @NotNull
    public ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        View lineView = inflater.inflate(R.layout.item_code_line, parent, false);
        lineView.setBackgroundColor(CodeHighlighterKt.color(this.options.getTheme().getBgContent()));
        View view = lineView.findViewById(R.id.tv_line_num);
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
        }
        TextView tvLineNum = (TextView)view;
        tvLineNum.setTypeface(this.monoTypeface());
        tvLineNum.setTextColor(CodeHighlighterKt.color(this.options.getTheme().getNumColor()));
        tvLineNum.setBackgroundColor(CodeHighlighterKt.color(this.options.getTheme().getBgNum()));
        View view2 = lineView.findViewById(R.id.tv_line_content);
        if (view2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
        }
        TextView tvLineContent = (TextView)view2;
        tvLineContent.setTypeface(this.monoTypeface());
        View view3 = lineView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"lineView");
        ViewHolder holder = new ViewHolder(view3);
        holder.setIsRecyclable(false);
        return holder;
    }

    public void onBindViewHolder(@NotNull ViewHolder holder, int position) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        String codeLine = this.lines.get(position);
        holder.setMItem(codeLine);
        OnCodeLineClickListener onCodeLineClickListener = this.options.getLineClickListener();
        if (onCodeLineClickListener != null) {
            OnCodeLineClickListener onCodeLineClickListener2 = onCodeLineClickListener;
            OnCodeLineClickListener it = onCodeLineClickListener2;
            holder.itemView.setOnClickListener(new View.OnClickListener(this, holder, position, codeLine){
                final /* synthetic */ AbstractCodeAdapter this$0;
                final /* synthetic */ ViewHolder $holder$inlined;
                final /* synthetic */ int $position$inlined;
                final /* synthetic */ String $codeLine$inlined;

                public final void onClick(View it) {
                    block0: {
                        OnCodeLineClickListener onCodeLineClickListener = this.this$0.getOptions$codeview_compileReleaseKotlin().getLineClickListener();
                        if (onCodeLineClickListener == null) break block0;
                        onCodeLineClickListener.onCodeLineClicked(this.$position$inlined, this.$codeLine$inlined);
                    }
                }
                {
                    this.this$0 = abstractCodeAdapter;
                    this.$holder$inlined = viewHolder;
                    this.$position$inlined = n;
                    this.$codeLine$inlined = string2;
                }
            });
        }
        this.setupLine(position, codeLine, holder);
        this.displayLineFooter(position, holder);
        this.addExtraPadding(position, holder);
    }

    public int getItemCount() {
        return this.lines.size();
    }

    private final boolean isFirst(int $receiver) {
        return $receiver == 0;
    }

    private final boolean isLast(int $receiver) {
        return $receiver == this.getItemCount() - 1;
    }

    private final boolean isJustFirst(int $receiver) {
        return this.isFirst($receiver) && !this.isLast($receiver);
    }

    private final boolean isJustLast(int $receiver) {
        return this.isLast($receiver) && !this.isFirst($receiver);
    }

    private final boolean isBorder(int $receiver) {
        return this.isFirst($receiver) || this.isLast($receiver);
    }

    private final void setupLine(int position, String line, ViewHolder holder) {
        holder.getTvLineContent().setText((CharSequence)UtilsKt.html(line));
        holder.getTvLineContent().setTextColor(CodeHighlighterKt.color(this.options.getTheme().getNoteColor()));
        if (this.options.getShortcut() && position == MAX_SHORTCUT_LINES) {
            holder.getTvLineNum().setTextSize(10.0f);
            holder.getTvLineNum().setText((CharSequence)this.context.getString(R.string.dots));
        } else {
            holder.getTvLineNum().setTextSize(12.0f);
            holder.getTvLineNum().setText((CharSequence)String.valueOf(position + 1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void displayLineFooter(int position, ViewHolder holder) {
        block1: {
            void $receiver$iv;
            List<T> entityList = this.footerEntities.get(position);
            holder.getLlLineFooter().removeAllViews();
            List<T> list = entityList;
            if (list == null) break block1;
            List<T> list2 = list;
            List<T> it = list2;
            Collection collection = it;
            LinearLayout linearLayout = holder.getLlLineFooter();
            boolean bl = !collection.isEmpty();
            linearLayout.setVisibility(bl ? 0 : 8);
            collection = new Ref.BooleanRef();
            ((Ref.BooleanRef)collection).element = true;
            Iterable iterable = it;
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                void isFirst;
                Object element$iv;
                Object entity = element$iv = iterator.next();
                View footerView = this.createFooter(this.context, entity, isFirst.element);
                holder.getLlLineFooter().addView(footerView);
                isFirst.element = false;
            }
            collection = null;
        }
    }

    private final void addExtraPadding(int position, ViewHolder holder) {
        if (this.isBorder(position)) {
            int dp8 = UtilsKt.dpToPx(this.context, 8);
            int topPadding = this.isJustFirst(position) ? dp8 : 0;
            int bottomPadding = this.isJustLast(position) ? dp8 : 0;
            holder.getTvLineNum().setPadding(0, topPadding, 0, bottomPadding);
            holder.getTvLineContent().setPadding(0, topPadding, 0, bottomPadding);
        } else {
            holder.getTvLineNum().setPadding(0, 0, 0, 0);
            holder.getTvLineContent().setPadding(0, 0, 0, 0);
        }
    }

    public AbstractCodeAdapter(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.lines = new ArrayList();
        this.footerEntities = new HashMap();
        this.context = context;
        this.options = new Options(context, null, null, null, false, false, null, 0, null, 510, null);
        this.prepareCodeLines$codeview_compileReleaseKotlin();
    }

    public AbstractCodeAdapter(@NotNull Context context, @NotNull String code) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        this.lines = new ArrayList();
        this.footerEntities = new HashMap();
        this.context = context;
        this.options = new Options(context, code, null, null, false, false, null, 0, null, 508, null);
        this.prepareCodeLines$codeview_compileReleaseKotlin();
    }

    public AbstractCodeAdapter(@NotNull Context context, @NotNull Options options) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.lines = new ArrayList();
        this.footerEntities = new HashMap();
        this.context = context;
        this.options = options;
        this.prepareCodeLines$codeview_compileReleaseKotlin();
    }

    @NotNull
    public static final /* synthetic */ String access$classifyContent(AbstractCodeAdapter $this) {
        return $this.classifyContent();
    }

    public static final /* synthetic */ void access$highlighting(AbstractCodeAdapter $this, @NotNull String language, @NotNull Function0 onReady) {
        $this.highlighting(language, (Function0<Unit>)onReady);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\nH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lio/github/kbiakov/codeview/adapters/AbstractCodeAdapter$ViewHolder;", "Landroid/support/v7/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "llLineFooter", "Landroid/widget/LinearLayout;", "getLlLineFooter", "()Landroid/widget/LinearLayout;", "mItem", "", "getMItem", "()Ljava/lang/String;", "setMItem", "(Ljava/lang/String;)V", "tvLineContent", "Landroid/widget/TextView;", "getTvLineContent", "()Landroid/widget/TextView;", "tvLineNum", "getTvLineNum", "toString", "codeview-compileReleaseKotlin"})
    public static final class ViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final TextView tvLineNum;
        @NotNull
        private final TextView tvLineContent;
        @NotNull
        private final LinearLayout llLineFooter;
        @Nullable
        private String mItem;

        @NotNull
        public final TextView getTvLineNum() {
            return this.tvLineNum;
        }

        @NotNull
        public final TextView getTvLineContent() {
            return this.tvLineContent;
        }

        @NotNull
        public final LinearLayout getLlLineFooter() {
            return this.llLineFooter;
        }

        @Nullable
        public final String getMItem() {
            return this.mItem;
        }

        public final void setMItem(@Nullable String string) {
            this.mItem = string;
        }

        @NotNull
        public String toString() {
            return super.toString() + " '" + this.mItem + "'";
        }

        public ViewHolder(@NotNull View itemView) {
            Intrinsics.checkParameterIsNotNull((Object)itemView, (String)"itemView");
            super(itemView);
            View view = itemView.findViewById(R.id.tv_line_num);
            if (view == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
            }
            this.tvLineNum = (TextView)view;
            View view2 = itemView.findViewById(R.id.tv_line_content);
            if (view2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
            }
            this.tvLineContent = (TextView)view2;
            View view3 = itemView.findViewById(R.id.ll_line_footer);
            if (view3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.LinearLayout");
            }
            this.llLineFooter = (LinearLayout)view3;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/github/kbiakov/codeview/adapters/AbstractCodeAdapter$Companion;", "", "()V", "MAX_SHORTCUT_LINES", "", "codeview-compileReleaseKotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

