/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbiakov.codeview.adapters;

import android.content.Context;
import android.graphics.Typeface;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.github.kbiakov.codeview.OnCodeLineClickListener;
import io.github.kbiakov.codeview.R;
import io.github.kbiakov.codeview.Thread;
import io.github.kbiakov.codeview.UtilsKt;
import io.github.kbiakov.codeview.classifier.CodeClassifier;
import io.github.kbiakov.codeview.classifier.CodeProcessor;
import io.github.kbiakov.codeview.highlight.CodeHighlighter;
import io.github.kbiakov.codeview.highlight.CodeHighlighterKt;
import io.github.kbiakov.codeview.highlight.ColorTheme;
import io.github.kbiakov.codeview.highlight.ColorThemeData;
import io.github.kbiakov.codeview.highlight.MonoFontCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\b&\u0018\u0000 U*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0002UVBA\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u0007\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\u0003H\u0002J\u001b\u00100\u001a\u00020-2\u0006\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u00028\u0000\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u00020\u0007H\u0002J%\u00105\u001a\u0002062\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00102\u001a\u00028\u00002\u0006\u00107\u001a\u00020\tH&\u00a2\u0006\u0002\u00108J\u0018\u00109\u001a\u00020-2\u0006\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\u0003H\u0002J\b\u0010:\u001a\u00020\u000bH\u0016J \u0010;\u001a\u00020-2\n\b\u0002\u0010<\u001a\u0004\u0018\u00010\u00072\f\u0010=\u001a\b\u0012\u0004\u0012\u00020-0>J\u001e\u0010?\u001a\u00020-2\u0006\u0010<\u001a\u00020\u00072\f\u0010=\u001a\b\u0012\u0004\u0012\u00020-0>H\u0002J\u001a\u0010@\u001a\u00020-2\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\u0007H\u0002J\u0010\u0010A\u001a\n C*\u0004\u0018\u00010B0BH\u0002J\u0018\u0010D\u001a\u00020-2\u0006\u0010/\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u000bH\u0016J\u0018\u0010E\u001a\u00020\u00032\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\u000bH\u0016J \u0010I\u001a\u00020-2\u0006\u0010.\u001a\u00020\u000b2\u0006\u0010J\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u0003H\u0002J\u0010\u0010K\u001a\n C*\u0004\u0018\u00010\u00070\u0007H\u0002J\u000e\u0010L\u001a\u00020-2\u0006\u0010M\u001a\u00020\u0007J$\u0010N\u001a\u00020-2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00070\u001d2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020-0>H\u0002J\f\u0010Q\u001a\u00020\t*\u00020\u000bH\u0002J\f\u00107\u001a\u00020\t*\u00020\u000bH\u0002J\f\u0010R\u001a\u00020\t*\u00020\u000bH\u0002J\f\u0010S\u001a\u00020\t*\u00020\u000bH\u0002J\f\u0010T\u001a\u00020\t*\u00020\u000bH\u0002R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aRH\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001d0\u001c2\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001d0\u001c@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010)\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lio/github/kbiakov/codeview/adapters/AbstractCodeAdapter;", "T", "Landroid/support/v7/widget/RecyclerView$Adapter;", "Lio/github/kbiakov/codeview/adapters/AbstractCodeAdapter$ViewHolder;", "context", "Landroid/content/Context;", "content", "", "isShowFull", "", "maxLines", "", "shortcutNote", "listener", "Lio/github/kbiakov/codeview/OnCodeLineClickListener;", "(Landroid/content/Context;Ljava/lang/String;ZILjava/lang/String;Lio/github/kbiakov/codeview/OnCodeLineClickListener;)V", "codeListener", "getCodeListener$codeview_compileReleaseKotlin", "()Lio/github/kbiakov/codeview/OnCodeLineClickListener;", "setCodeListener$codeview_compileReleaseKotlin", "(Lio/github/kbiakov/codeview/OnCodeLineClickListener;)V", "colorTheme", "Lio/github/kbiakov/codeview/highlight/ColorThemeData;", "getColorTheme$codeview_compileReleaseKotlin", "()Lio/github/kbiakov/codeview/highlight/ColorThemeData;", "setColorTheme$codeview_compileReleaseKotlin", "(Lio/github/kbiakov/codeview/highlight/ColorThemeData;)V", "footerEntities", "Ljava/util/HashMap;", "", "getFooterEntities$codeview_compileReleaseKotlin", "()Ljava/util/HashMap;", "setFooterEntities$codeview_compileReleaseKotlin", "(Ljava/util/HashMap;)V", "isFullShowing", "isFullShowing$codeview_compileReleaseKotlin", "()Z", "setFullShowing$codeview_compileReleaseKotlin", "(Z)V", "mContent", "mContext", "mDroppedLines", "mLines", "mMaxLines", "addExtraPadding", "", "position", "holder", "addFooterEntity", "num", "entity", "(ILjava/lang/Object;)V", "classifyContent", "createFooter", "Landroid/view/View;", "isFirst", "(Landroid/content/Context;Ljava/lang/Object;Z)Landroid/view/View;", "displayLineFooter", "getItemCount", "highlightCode", "language", "onReady", "Lkotlin/Function0;", "highlighting", "initCodeContent", "monoTypeface", "Landroid/graphics/Typeface;", "kotlin.jvm.PlatformType", "onBindViewHolder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setupLine", "line", "showAllBottomNote", "updateCodeContent", "newContent", "updateContent", "codeLines", "onUpdated", "isBorder", "isJustFirst", "isJustLast", "isLast", "Companion", "ViewHolder", "codeview-compileReleaseKotlin"})
public abstract class AbstractCodeAdapter<T>
extends RecyclerView.Adapter<ViewHolder> {
    private final Context mContext;
    private String mContent;
    private List<String> mLines;
    private final int mMaxLines;
    private List<String> mDroppedLines;
    private boolean isFullShowing;
    @Nullable
    private OnCodeLineClickListener codeListener;
    @NotNull
    private ColorThemeData colorTheme;
    @NotNull
    private HashMap<Integer, List<T>> footerEntities;
    public static final int MAX_SHORTCUT_LINES = 6;
    public static final Companion Companion = new Companion(null);

    public final boolean isFullShowing$codeview_compileReleaseKotlin() {
        return this.isFullShowing;
    }

    public final void setFullShowing$codeview_compileReleaseKotlin(boolean bl) {
        this.isFullShowing = bl;
    }

    @Nullable
    public final OnCodeLineClickListener getCodeListener$codeview_compileReleaseKotlin() {
        return this.codeListener;
    }

    public final void setCodeListener$codeview_compileReleaseKotlin(@Nullable OnCodeLineClickListener onCodeLineClickListener) {
        this.codeListener = onCodeLineClickListener;
    }

    @NotNull
    public final ColorThemeData getColorTheme$codeview_compileReleaseKotlin() {
        return this.colorTheme;
    }

    public final void setColorTheme$codeview_compileReleaseKotlin(@NotNull ColorThemeData colorTheme) {
        Intrinsics.checkParameterIsNotNull((Object)colorTheme, (String)"colorTheme");
        this.colorTheme = colorTheme;
        this.notifyDataSetChanged();
    }

    @NotNull
    public final HashMap<Integer, List<T>> getFooterEntities$codeview_compileReleaseKotlin() {
        return this.footerEntities;
    }

    public final void setFooterEntities$codeview_compileReleaseKotlin(@NotNull HashMap<Integer, List<T>> footerEntities) {
        Intrinsics.checkParameterIsNotNull(footerEntities, (String)"footerEntities");
        this.footerEntities = footerEntities;
        this.notifyDataSetChanged();
    }

    private final void initCodeContent(boolean isShowFull, String shortcutNote) {
        List<String> lines = new ArrayList(UtilsKt.extractLines(this.mContent));
        boolean bl = this.isFullShowing = isShowFull || lines.size() <= this.mMaxLines;
        if (!this.isFullShowing) {
            this.mDroppedLines = new ArrayList(lines.subList(this.mMaxLines, CollectionsKt.getLastIndex((List)lines)));
            lines = lines.subList(0, this.mMaxLines);
            String string2 = shortcutNote;
            List<String> list = lines;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
            String string5 = string4;
            list.add(string5);
        }
        this.mLines = lines;
    }

    static /* bridge */ /* synthetic */ void initCodeContent$default(AbstractCodeAdapter abstractCodeAdapter, boolean bl, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: initCodeContent");
        }
        if ((n & 2) != 0) {
            String string2 = abstractCodeAdapter.showAllBottomNote();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"showAllBottomNote()");
            string = string2;
        }
        abstractCodeAdapter.initCodeContent(bl, string);
    }

    public final void updateCodeContent(@NotNull String newContent) {
        Intrinsics.checkParameterIsNotNull((Object)newContent, (String)"newContent");
        this.mContent = newContent;
        AbstractCodeAdapter.initCodeContent$default(this, this.isFullShowing, null, 2, null);
        this.notifyDataSetChanged();
    }

    public final void addFooterEntity(int num, T entity) {
        List list = this.footerEntities.get(num);
        if (list == null) {
            list = new ArrayList();
        }
        List notes = list;
        this.footerEntities.put(num, CollectionsKt.plus((Collection)notes, entity));
        this.notifyDataSetChanged();
    }

    public final void highlightCode(@Nullable String language, @NotNull Function0<Unit> onReady) {
        Intrinsics.checkParameterIsNotNull(onReady, (String)"onReady");
        Thread.INSTANCE.async((Function0<Unit>)((Function0)new Function0<Unit>(this, language, onReady){
            final /* synthetic */ AbstractCodeAdapter this$0;
            final /* synthetic */ String $language;
            final /* synthetic */ Function0 $onReady;

            public final void invoke() {
                String string2 = this.$language;
                if (string2 == null) {
                    string2 = AbstractCodeAdapter.access$classifyContent(this.this$0);
                }
                String classifiedLanguage = string2;
                AbstractCodeAdapter.access$highlighting(this.this$0, classifiedLanguage, this.$onReady);
            }
            {
                this.this$0 = abstractCodeAdapter;
                this.$language = string2;
                this.$onReady = function0;
                super(0);
            }
        }));
    }

    public static /* bridge */ /* synthetic */ void highlightCode$default(AbstractCodeAdapter abstractCodeAdapter, String string, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: highlightCode");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        abstractCodeAdapter.highlightCode(string, (Function0<Unit>)function0);
    }

    @NotNull
    public abstract View createFooter(@NotNull Context var1, T var2, boolean var3);

    private final String classifyContent() {
        String language;
        CodeProcessor processor = CodeProcessor.getInstance(this.mContext);
        String string2 = language = processor.isTrained() ? processor.classify(this.mContent).get() : CodeClassifier.DEFAULT_LANGUAGE;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"language");
        return string2;
    }

    private final void highlighting(String language, Function0<Unit> onReady) {
        String code = CodeHighlighter.INSTANCE.highlight(language, this.mContent, this.colorTheme);
        List<String> lines = UtilsKt.extractLines(code);
        this.updateContent(lines, onReady);
    }

    private final void updateContent(List<String> codeLines, Function0<Unit> onUpdated) {
        Thread.INSTANCE.ui((Function0<Unit>)((Function0)new Function0<Unit>(this, codeLines, onUpdated){
            final /* synthetic */ AbstractCodeAdapter this$0;
            final /* synthetic */ List $codeLines;
            final /* synthetic */ Function0 $onUpdated;

            public final void invoke() {
                AbstractCodeAdapter.access$setMLines$p(this.this$0, this.$codeLines);
                this.$onUpdated.invoke();
            }
            {
                this.this$0 = abstractCodeAdapter;
                this.$codeLines = list;
                this.$onUpdated = function0;
                super(0);
            }
        }));
    }

    private final String showAllBottomNote() {
        return this.mContext.getString(R.string.show_all);
    }

    private final Typeface monoTypeface() {
        return MonoFontCache.getInstance(this.mContext).getTypeface();
    }

    @NotNull
    public ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        View lineView = inflater.inflate(R.layout.item_code_line, parent, false);
        lineView.setBackgroundColor(CodeHighlighterKt.color(this.colorTheme.getBgContent()));
        View view = lineView.findViewById(R.id.tv_line_num);
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
        }
        TextView tvLineNum = (TextView)view;
        tvLineNum.setTypeface(this.monoTypeface());
        tvLineNum.setTextColor(CodeHighlighterKt.color(this.colorTheme.getNumColor()));
        tvLineNum.setBackgroundColor(CodeHighlighterKt.color(this.colorTheme.getBgNum()));
        View view2 = lineView.findViewById(R.id.tv_line_content);
        if (view2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
        }
        TextView tvLineContent = (TextView)view2;
        tvLineContent.setTypeface(this.monoTypeface());
        View view3 = lineView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"lineView");
        return new ViewHolder(view3);
    }

    public void onBindViewHolder(@NotNull ViewHolder holder, int position) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        String codeLine = this.mLines.get(position);
        holder.setMItem(codeLine);
        holder.itemView.setOnClickListener(new View.OnClickListener(this, position, codeLine){
            final /* synthetic */ AbstractCodeAdapter this$0;
            final /* synthetic */ int $position;
            final /* synthetic */ String $codeLine;

            public final void onClick(View it) {
                block0: {
                    OnCodeLineClickListener onCodeLineClickListener = this.this$0.getCodeListener$codeview_compileReleaseKotlin();
                    if (onCodeLineClickListener == null) break block0;
                    onCodeLineClickListener.onCodeLineClicked(this.$position, this.$codeLine);
                }
            }
            {
                this.this$0 = abstractCodeAdapter;
                this.$position = n;
                this.$codeLine = string2;
            }
        });
        this.setupLine(position, codeLine, holder);
        this.displayLineFooter(position, holder);
        this.addExtraPadding(position, holder);
    }

    public int getItemCount() {
        return this.mLines.size();
    }

    private final boolean isFirst(int $receiver) {
        return $receiver == 0;
    }

    private final boolean isLast(int $receiver) {
        return $receiver == this.getItemCount() - 1;
    }

    private final boolean isJustFirst(int $receiver) {
        return this.isFirst($receiver) && !this.isLast($receiver);
    }

    private final boolean isJustLast(int $receiver) {
        return this.isLast($receiver) && !this.isFirst($receiver);
    }

    private final boolean isBorder(int $receiver) {
        return this.isFirst($receiver) || this.isLast($receiver);
    }

    private final void setupLine(int position, String line, ViewHolder holder) {
        holder.getTvLineContent().setText((CharSequence)UtilsKt.html(line));
        holder.getTvLineContent().setTextColor(CodeHighlighterKt.color(this.colorTheme.getNoteColor()));
        if (!this.isFullShowing && position == MAX_SHORTCUT_LINES) {
            holder.getTvLineNum().setTextSize(10.0f);
            holder.getTvLineNum().setText((CharSequence)this.mContext.getString(R.string.dots));
        } else {
            holder.getTvLineNum().setTextSize(12.0f);
            holder.getTvLineNum().setText((CharSequence)String.valueOf(position + 1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void displayLineFooter(int position, ViewHolder holder) {
        block1: {
            void $receiver$iv;
            List<T> entityList = this.footerEntities.get(position);
            holder.getLlLineFooter().removeAllViews();
            List<T> list = entityList;
            if (list == null) break block1;
            List<T> list2 = list;
            List<T> it = list2;
            Collection collection = it;
            LinearLayout linearLayout = holder.getLlLineFooter();
            boolean bl = !collection.isEmpty();
            linearLayout.setVisibility(bl ? 0 : 8);
            collection = new Ref.BooleanRef();
            ((Ref.BooleanRef)collection).element = true;
            Iterable iterable = it;
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                void isFirst;
                Object element$iv;
                Object entity = element$iv = iterator.next();
                View footerView = this.createFooter(this.mContext, entity, isFirst.element);
                holder.getLlLineFooter().addView(footerView);
                isFirst.element = false;
            }
            collection = null;
        }
    }

    private final void addExtraPadding(int position, ViewHolder holder) {
        if (this.isBorder(position)) {
            int dp8 = UtilsKt.dpToPx(this.mContext, 8);
            int topPadding = this.isJustFirst(position) ? dp8 : 0;
            int bottomPadding = this.isJustLast(position) ? dp8 : 0;
            holder.getTvLineNum().setPadding(0, topPadding, 0, bottomPadding);
            holder.getTvLineContent().setPadding(0, topPadding, 0, bottomPadding);
        } else {
            holder.getTvLineNum().setPadding(0, 0, 0, 0);
            holder.getTvLineContent().setPadding(0, 0, 0, 0);
        }
    }

    public AbstractCodeAdapter(@NotNull Context context, @NotNull String content, boolean isShowFull, int maxLines, @NotNull String shortcutNote, @Nullable OnCodeLineClickListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)shortcutNote, (String)"shortcutNote");
        this.mLines = new ArrayList();
        this.mDroppedLines = null;
        this.isFullShowing = true;
        this.setColorTheme$codeview_compileReleaseKotlin(ColorTheme.with$default(ColorTheme.SOLARIZED_LIGHT, null, 0, 0, 0, 0, 31, null));
        this.setFooterEntities$codeview_compileReleaseKotlin(new HashMap<Integer, List<T>>());
        this.mContext = context;
        this.mContent = content;
        this.mMaxLines = maxLines;
        this.codeListener = listener;
        if (isShowFull) {
            this.isFullShowing = true;
            this.mLines = UtilsKt.extractLines(content);
        } else {
            this.initCodeContent(isShowFull, shortcutNote);
        }
    }

    public /* synthetic */ AbstractCodeAdapter(Context context, String string2, boolean bl, int n, String string3, OnCodeLineClickListener onCodeLineClickListener, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        if ((n2 & 8) != 0) {
            n = MAX_SHORTCUT_LINES;
        }
        if ((n2 & 0x10) != 0) {
            String string4 = context.getString(R.string.show_all);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"context.getString(R.string.show_all)");
            string3 = string4;
        }
        if ((n2 & 0x20) != 0) {
            onCodeLineClickListener = null;
        }
        this(context, string2, bl, n, string3, onCodeLineClickListener);
    }

    @NotNull
    public static final /* synthetic */ String access$classifyContent(AbstractCodeAdapter $this) {
        return $this.classifyContent();
    }

    public static final /* synthetic */ void access$highlighting(AbstractCodeAdapter $this, @NotNull String language, @NotNull Function0 onReady) {
        $this.highlighting(language, (Function0<Unit>)onReady);
    }

    @NotNull
    public static final /* synthetic */ List access$getMLines$p(AbstractCodeAdapter $this) {
        return $this.mLines;
    }

    public static final /* synthetic */ void access$setMLines$p(AbstractCodeAdapter $this, @NotNull List list) {
        $this.mLines = list;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001a\u001a\u00020\fH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lio/github/kbiakov/codeview/adapters/AbstractCodeAdapter$ViewHolder;", "Landroid/support/v7/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "llLineFooter", "Landroid/widget/LinearLayout;", "getLlLineFooter", "()Landroid/widget/LinearLayout;", "setLlLineFooter", "(Landroid/widget/LinearLayout;)V", "mItem", "", "getMItem", "()Ljava/lang/String;", "setMItem", "(Ljava/lang/String;)V", "tvLineContent", "Landroid/widget/TextView;", "getTvLineContent", "()Landroid/widget/TextView;", "setTvLineContent", "(Landroid/widget/TextView;)V", "tvLineNum", "getTvLineNum", "setTvLineNum", "toString", "codeview-compileReleaseKotlin"})
    public static final class ViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private TextView tvLineNum;
        @NotNull
        private TextView tvLineContent;
        @NotNull
        private LinearLayout llLineFooter;
        @Nullable
        private String mItem;

        @NotNull
        public final TextView getTvLineNum() {
            return this.tvLineNum;
        }

        public final void setTvLineNum(@NotNull TextView textView) {
            Intrinsics.checkParameterIsNotNull((Object)textView, (String)"<set-?>");
            this.tvLineNum = textView;
        }

        @NotNull
        public final TextView getTvLineContent() {
            return this.tvLineContent;
        }

        public final void setTvLineContent(@NotNull TextView textView) {
            Intrinsics.checkParameterIsNotNull((Object)textView, (String)"<set-?>");
            this.tvLineContent = textView;
        }

        @NotNull
        public final LinearLayout getLlLineFooter() {
            return this.llLineFooter;
        }

        public final void setLlLineFooter(@NotNull LinearLayout linearLayout) {
            Intrinsics.checkParameterIsNotNull((Object)linearLayout, (String)"<set-?>");
            this.llLineFooter = linearLayout;
        }

        @Nullable
        public final String getMItem() {
            return this.mItem;
        }

        public final void setMItem(@Nullable String string) {
            this.mItem = string;
        }

        @NotNull
        public String toString() {
            return super.toString() + " '" + this.mItem + "'";
        }

        public ViewHolder(@NotNull View itemView) {
            Intrinsics.checkParameterIsNotNull((Object)itemView, (String)"itemView");
            super(itemView);
            View view = itemView.findViewById(R.id.tv_line_num);
            if (view == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
            }
            this.tvLineNum = (TextView)view;
            View view2 = itemView.findViewById(R.id.tv_line_content);
            if (view2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
            }
            this.tvLineContent = (TextView)view2;
            View view3 = itemView.findViewById(R.id.ll_line_footer);
            if (view3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.LinearLayout");
            }
            this.llLineFooter = (LinearLayout)view3;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/github/kbiakov/codeview/adapters/AbstractCodeAdapter$Companion;", "", "()V", "MAX_SHORTCUT_LINES", "", "codeview-compileReleaseKotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

