/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbiakov.codeview.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import io.github.kbiakov.codeview.UtilsKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0014J0\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\tH\u0014J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/github/kbiakov/codeview/views/BidirectionalScrollView;", "Landroid/widget/HorizontalScrollView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "currentX", "currentY", "isMoved", "", "dispatchTouchEvent", "event", "Landroid/view/MotionEvent;", "measureChild", "", "child", "Landroid/view/View;", "parentWidthMeasureSpec", "parentHeightMeasureSpec", "measureChildWithMargins", "widthUsed", "heightUsed", "scroll", "codeview-compileReleaseKotlin"})
public final class BidirectionalScrollView
extends HorizontalScrollView {
    private int currentX;
    private int currentY;
    private boolean isMoved;

    public boolean dispatchTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        switch (event.getAction()) {
            case 0: {
                this.currentX = (int)event.getRawX();
                this.currentY = (int)event.getRawY();
                return super.dispatchTouchEvent(event);
            }
            case 2: {
                float deltaX = Math.abs((float)this.currentX - event.getRawX());
                float deltaY = Math.abs((float)this.currentY - event.getRawY());
                this.scroll(event);
                Context context = this.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                int movedOnDistance = UtilsKt.dpToPx(context, 2);
                if (!(deltaX > (float)movedOnDistance) && !(deltaY > (float)movedOnDistance)) break;
                this.isMoved = true;
                break;
            }
            case 1: {
                if (!this.isMoved) {
                    return super.dispatchTouchEvent(event);
                }
                this.isMoved = false;
                break;
            }
            case 3: {
                this.isMoved = false;
            }
        }
        return true;
    }

    private final void scroll(MotionEvent event) {
        int x2 = (int)event.getRawX();
        int y2 = (int)event.getRawY();
        int posX = this.currentX - x2;
        int posY = this.currentY - y2;
        this.scrollBy(posX, posY);
        this.currentX = x2;
        this.currentY = y2;
    }

    protected void measureChild(@NotNull View child, int parentWidthMeasureSpec, int parentHeightMeasureSpec) {
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    protected void measureChildWithMargins(@NotNull View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
        if (layoutParams == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
        }
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)layoutParams;
        int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(params.leftMargin + params.rightMargin), (int)0);
        int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(params.topMargin + params.bottomMargin), (int)0);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    public BidirectionalScrollView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
    }

    public BidirectionalScrollView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
    }

    public BidirectionalScrollView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
    }
}

