/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbiakov.codeview.classifier;

import io.github.kbiakov.codeview.classifier.Classification;
import io.github.kbiakov.codeview.classifier.IFeatureProbability;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u000f\b&\u0018\u0000 B*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0001BB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00028\u0001\u00a2\u0006\u0002\u0010(J$\u0010)\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u001b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000*H&J\u0013\u0010+\u001a\u00020,2\u0006\u0010'\u001a\u00028\u0001\u00a2\u0006\u0002\u0010-J\u001b\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00028\u00002\u0006\u0010'\u001a\u00028\u0001\u00a2\u0006\u0002\u00100J\u001b\u00101\u001a\u00020\n2\u0006\u0010/\u001a\u00028\u00002\u0006\u0010'\u001a\u00028\u0001\u00a2\u0006\u0002\u00102J\u001d\u00103\u001a\u0002042\u0006\u0010/\u001a\u00028\u00002\u0006\u0010'\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00105J\u001b\u00106\u001a\u0002042\u0006\u0010/\u001a\u00028\u00002\u0006\u0010'\u001a\u00028\u0001\u00a2\u0006\u0002\u00105J/\u00106\u001a\u0002042\u0006\u0010/\u001a\u00028\u00002\u0006\u0010'\u001a\u00028\u00012\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003\u00a2\u0006\u0002\u00108J7\u00106\u001a\u0002042\u0006\u0010/\u001a\u00028\u00002\u0006\u0010'\u001a\u00028\u00012\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00032\u0006\u00109\u001a\u000204\u00a2\u0006\u0002\u0010:JC\u00106\u001a\u0002042\u0006\u0010/\u001a\u00028\u00002\u0006\u0010'\u001a\u00028\u00012\u0016\b\u0002\u00107\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00032\u0006\u00109\u001a\u0002042\u0006\u0010;\u001a\u000204\u00a2\u0006\u0002\u0010<J\u0013\u0010=\u001a\u00020,2\u0006\u0010'\u001a\u00028\u0001\u00a2\u0006\u0002\u0010-J\u001b\u0010>\u001a\u00020,2\u0006\u0010/\u001a\u00028\u00002\u0006\u0010'\u001a\u00028\u0001\u00a2\u0006\u0002\u00100J!\u0010?\u001a\u00020,2\u0006\u0010'\u001a\u00028\u00012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000*\u00a2\u0006\u0002\u0010@J\u001a\u0010?\u001a\u00020,2\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR2\u0010\r\u001a\u001a\u0012\u0004\u0012\u00028\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\u000e0\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR$\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u0018R,\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001b0\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR&\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\n0\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0010\"\u0004\b\"\u0010\u0012R&\u0010#\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0010\"\u0004\b%\u0010\u0012\u00a8\u0006C"}, d2={"Lio/github/kbiakov/codeview/classifier/Classifier;", "T", "K", "Lio/github/kbiakov/codeview/classifier/IFeatureProbability;", "()V", "categories", "", "getCategories", "()Ljava/util/Set;", "categoriesTotal", "", "getCategoriesTotal", "()I", "featureCountPerCategory", "Ljava/util/HashMap;", "getFeatureCountPerCategory", "()Ljava/util/HashMap;", "setFeatureCountPerCategory", "(Ljava/util/HashMap;)V", "features", "getFeatures", "memoryCapacity", "getMemoryCapacity", "setMemoryCapacity", "(I)V", "memoryQueue", "Ljava/util/Queue;", "Lio/github/kbiakov/codeview/classifier/Classification;", "getMemoryQueue", "()Ljava/util/Queue;", "setMemoryQueue", "(Ljava/util/Queue;)V", "totalCategoryCount", "getTotalCategoryCount", "setTotalCategoryCount", "totalFeatureCount", "getTotalFeatureCount", "setTotalFeatureCount", "categoryCount", "category", "(Ljava/lang/Object;)Ljava/lang/Integer;", "classify", "", "decrementCategory", "", "(Ljava/lang/Object;)V", "decrementFeature", "feature", "(Ljava/lang/Object;Ljava/lang/Object;)V", "featureCount", "(Ljava/lang/Object;Ljava/lang/Object;)I", "featureProbability", "", "(Ljava/lang/Object;Ljava/lang/Object;)F", "featureWeighedAverage", "calculator", "(Ljava/lang/Object;Ljava/lang/Object;Lio/github/kbiakov/codeview/classifier/IFeatureProbability;)F", "weight", "(Ljava/lang/Object;Ljava/lang/Object;Lio/github/kbiakov/codeview/classifier/IFeatureProbability;F)F", "assumedProbability", "(Ljava/lang/Object;Ljava/lang/Object;Lio/github/kbiakov/codeview/classifier/IFeatureProbability;FF)F", "incrementCategory", "incrementFeature", "learn", "(Ljava/lang/Object;Ljava/util/Collection;)V", "classification", "Companion", "codeview-compileReleaseKotlin"})
public abstract class Classifier<T, K>
implements IFeatureProbability<T, K> {
    private int memoryCapacity = 1000;
    @NotNull
    private HashMap<K, HashMap<T, Integer>> featureCountPerCategory = new HashMap(io.github.kbiakov.codeview.classifier.Classifier$Companion.access$getINIT_CATEGORY_MAP_CAPACITY$p(Companion));
    @NotNull
    private HashMap<T, Integer> totalFeatureCount = new HashMap(io.github.kbiakov.codeview.classifier.Classifier$Companion.access$getINIT_FEATURE_MAP_CAPACITY$p(Companion));
    @NotNull
    private HashMap<K, Integer> totalCategoryCount = new HashMap(io.github.kbiakov.codeview.classifier.Classifier$Companion.access$getINIT_CATEGORY_MAP_CAPACITY$p(Companion));
    @NotNull
    private Queue<Classification<T, K>> memoryQueue = new LinkedList();
    private static final int INIT_CATEGORY_MAP_CAPACITY = 16;
    private static final int INIT_FEATURE_MAP_CAPACITY = 32;
    public static final Companion Companion = new Companion(null);

    public final int getMemoryCapacity() {
        return this.memoryCapacity;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMemoryCapacity(int memoryCapacity) {
        IntProgression intProgression = RangesKt.downTo((int)memoryCapacity, (int)(memoryCapacity + 1));
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = n;
        int n5 = n2;
        if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
            while (true) {
                void i;
                this.memoryQueue.poll();
                if (i == n2) break;
                n = i + n3;
            }
        }
        this.memoryCapacity = memoryCapacity;
    }

    @NotNull
    public final HashMap<K, HashMap<T, Integer>> getFeatureCountPerCategory() {
        return this.featureCountPerCategory;
    }

    public final void setFeatureCountPerCategory(@NotNull HashMap<K, HashMap<T, Integer>> hashMap) {
        Intrinsics.checkParameterIsNotNull(hashMap, (String)"<set-?>");
        this.featureCountPerCategory = hashMap;
    }

    @NotNull
    public final HashMap<T, Integer> getTotalFeatureCount() {
        return this.totalFeatureCount;
    }

    public final void setTotalFeatureCount(@NotNull HashMap<T, Integer> hashMap) {
        Intrinsics.checkParameterIsNotNull(hashMap, (String)"<set-?>");
        this.totalFeatureCount = hashMap;
    }

    @NotNull
    public final HashMap<K, Integer> getTotalCategoryCount() {
        return this.totalCategoryCount;
    }

    public final void setTotalCategoryCount(@NotNull HashMap<K, Integer> hashMap) {
        Intrinsics.checkParameterIsNotNull(hashMap, (String)"<set-?>");
        this.totalCategoryCount = hashMap;
    }

    @NotNull
    public final Queue<Classification<T, K>> getMemoryQueue() {
        return this.memoryQueue;
    }

    public final void setMemoryQueue(@NotNull Queue<Classification<T, K>> queue) {
        Intrinsics.checkParameterIsNotNull(queue, (String)"<set-?>");
        this.memoryQueue = queue;
    }

    @NotNull
    public final Set<T> getFeatures() {
        Set<T> set = this.totalFeatureCount.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"totalFeatureCount.keys");
        return set;
    }

    @NotNull
    public final Set<K> getCategories() {
        Set<K> set = this.totalCategoryCount.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"totalCategoryCount.keys");
        return set;
    }

    /*
     * WARNING - void declaration
     */
    public final int getCategoriesTotal() {
        void var3_3;
        Iterable $receiver$iv = this.totalCategoryCount.values();
        Iterator iterator$iv = $receiver$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void next;
            Integer n = (Integer)iterator$iv.next();
            Integer prev = (Integer)accumulator$iv;
            accumulator$iv = prev + next.intValue();
        }
        return ((Number)var3_3).intValue();
    }

    public final void incrementFeature(T feature, K category) {
        HashMap hashMap = this.featureCountPerCategory.get(category);
        if (hashMap == null) {
            hashMap = new HashMap(Classifier.Companion.getINIT_FEATURE_MAP_CAPACITY());
        }
        HashMap features = hashMap;
        Map map = this.featureCountPerCategory;
        Map<T, Integer> map2 = new HashMap(features);
        map.put(category, map2);
        Integer n = (Integer)features.get(feature);
        if (n == null) {
            n = 0;
        }
        Integer count = n;
        map2 = features;
        count = count + 1;
        Object object = count;
        map2.put(feature, (Integer)object);
        Integer n2 = this.totalFeatureCount.get(feature);
        if (n2 == null) {
            n2 = 0;
        }
        Integer totalCount = n2;
        object = this.totalFeatureCount;
        Integer n3 = totalCount = Integer.valueOf(totalCount + 1);
        object.put(feature, n3);
    }

    public final void incrementCategory(K category) {
        Integer n = this.totalCategoryCount.get(category);
        if (n == null) {
            n = 0;
        }
        Integer count = n;
        Map map = this.totalCategoryCount;
        Integer n2 = count = Integer.valueOf(count + 1);
        map.put(category, n2);
    }

    public final void decrementFeature(T feature, K category) {
        HashMap<T, Integer> hashMap = this.featureCountPerCategory.get(category);
        if (hashMap == null) {
            return;
        }
        HashMap<T, Integer> features = hashMap;
        Integer n = features.get(feature);
        if (n == null) {
            return;
        }
        Integer count = n;
        if (Intrinsics.areEqual((Object)count, (Object)1)) {
            features.remove(feature);
            if (features.isEmpty()) {
                this.featureCountPerCategory.remove(category);
            }
        } else {
            count = count + -1;
            features.put(feature, count);
        }
        Integer n2 = this.totalFeatureCount.get(feature);
        if (n2 == null) {
            return;
        }
        Integer totalCount = n2;
        if (Intrinsics.areEqual((Object)totalCount, (Object)1)) {
            this.totalFeatureCount.remove(feature);
        } else {
            totalCount = totalCount + -1;
            this.totalFeatureCount.put(feature, totalCount);
        }
    }

    public final void decrementCategory(K category) {
        Integer n = this.totalCategoryCount.get(category);
        if (n == null) {
            return;
        }
        Integer count = n;
        if (Intrinsics.areEqual((Object)count, (Object)1)) {
            this.totalCategoryCount.remove(category);
        } else {
            count = count + -1;
            this.totalCategoryCount.put(category, count);
        }
    }

    public final int featureCount(T feature, K category) {
        Integer count;
        HashMap<T, Integer> hashMap = this.featureCountPerCategory.get(category);
        if (hashMap == null) {
            return 0;
        }
        HashMap<T, Integer> features = hashMap;
        Integer n = count = features.get(feature);
        return n != null ? n : 0;
    }

    @NotNull
    public final Integer categoryCount(K category) {
        Integer n = this.totalCategoryCount.get(category);
        if (n == null) {
            n = 0;
        }
        return n;
    }

    @Override
    public float featureProbability(T feature, K category) {
        return Intrinsics.areEqual((Object)this.categoryCount(category), (Object)0) ? 0.0f : (float)this.featureCount(feature, category) / (float)((Number)this.categoryCount(category)).intValue();
    }

    public final float featureWeighedAverage(T feature, K category) {
        return Classifier.featureWeighedAverage$default(this, feature, category, null, 1.0f, 0.5f, 4, null);
    }

    public final float featureWeighedAverage(T feature, K category, @NotNull IFeatureProbability<T, K> calculator) {
        Intrinsics.checkParameterIsNotNull(calculator, (String)"calculator");
        return this.featureWeighedAverage(feature, category, calculator, 1.0f, 0.5f);
    }

    public final float featureWeighedAverage(T feature, K category, @NotNull IFeatureProbability<T, K> calculator, float weight) {
        Intrinsics.checkParameterIsNotNull(calculator, (String)"calculator");
        return this.featureWeighedAverage(feature, category, calculator, weight, 0.5f);
    }

    public final float featureWeighedAverage(T feature, K category, @Nullable IFeatureProbability<T, K> calculator, float weight, float assumedProbability) {
        float basicProbability = calculator == null ? this.featureProbability(feature, category) : calculator.featureProbability(feature, category);
        Integer n = this.totalFeatureCount.get(feature);
        if (n == null) {
            n = 0;
        }
        Integer totals = n;
        return (weight * assumedProbability + (float)((Number)totals).intValue() * basicProbability) / (weight + (float)((Number)totals).intValue());
    }

    public static /* bridge */ /* synthetic */ float featureWeighedAverage$default(Classifier classifier, Object object, Object object2, IFeatureProbability iFeatureProbability, float f, float f2, int n, Object object3) {
        if (object3 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: featureWeighedAverage");
        }
        if ((n & 4) != 0) {
            iFeatureProbability = null;
        }
        return classifier.featureWeighedAverage(object, object2, iFeatureProbability, f, f2);
    }

    public final void learn(K category, @NotNull Collection<? extends T> features) {
        Intrinsics.checkParameterIsNotNull(features, (String)"features");
        this.learn(new Classification(features, category, 0.0f, 4, null));
    }

    public final void learn(@NotNull Classification<T, K> classification) {
        Intrinsics.checkParameterIsNotNull(classification, (String)"classification");
        Iterable $receiver$iv = classification.getFeatureSet();
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object feature = element$iv = iterator.next();
            this.incrementFeature(feature, classification.getCategory());
        }
        this.incrementCategory(classification.getCategory());
        this.memoryQueue.offer(classification);
        if (this.memoryQueue.size() > this.memoryCapacity) {
            Classification<T, K> toForget = this.memoryQueue.remove();
            Iterable $receiver$iv2 = toForget.getFeatureSet();
            Iterator iterator2 = $receiver$iv2.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object feature = element$iv = iterator2.next();
                this.decrementFeature(feature, toForget.getCategory());
            }
            this.decrementCategory(toForget.getCategory());
        }
    }

    @Nullable
    public abstract Classification<T, K> classify(@NotNull Collection<? extends T> var1);

    static {
        INIT_CATEGORY_MAP_CAPACITY = 16;
        INIT_FEATURE_MAP_CAPACITY = 32;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lio/github/kbiakov/codeview/classifier/Classifier$Companion;", "", "()V", "INIT_CATEGORY_MAP_CAPACITY", "", "getINIT_CATEGORY_MAP_CAPACITY", "()I", "INIT_FEATURE_MAP_CAPACITY", "getINIT_FEATURE_MAP_CAPACITY", "codeview-compileReleaseKotlin"})
    public static final class Companion {
        private final int getINIT_CATEGORY_MAP_CAPACITY() {
            return INIT_CATEGORY_MAP_CAPACITY;
        }

        private final int getINIT_FEATURE_MAP_CAPACITY() {
            return INIT_FEATURE_MAP_CAPACITY;
        }

        private Companion() {
        }

        public static final /* synthetic */ int access$getINIT_CATEGORY_MAP_CAPACITY$p(Companion $this) {
            return $this.getINIT_CATEGORY_MAP_CAPACITY();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

