/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbiakov.codeview;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import android.widget.RelativeLayout;
import io.github.kbiakov.codeview.CodeContentAdapter;
import io.github.kbiakov.codeview.CodeView;
import io.github.kbiakov.codeview.CodeView$WhenMappings;
import io.github.kbiakov.codeview.CodeViewKt;
import io.github.kbiakov.codeview.OnCodeLineClickListener;
import io.github.kbiakov.codeview.R;
import io.github.kbiakov.codeview.Thread;
import io.github.kbiakov.codeview.UtilsKt;
import io.github.kbiakov.codeview.highlight.ColorTheme;
import io.github.kbiakov.codeview.highlight.ColorThemeData;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u00017B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u001a\u001a\u00020\u00002\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u0010\u001f\u001a\u00020\u0010J\u0010\u0010 \u001a\n \"*\u0004\u0018\u00010!0!H\u0002J\u0006\u0010#\u001a\u00020\u0000J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u001eJ\u0010\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020\u0014H\u0002J\u0010\u0010)\u001a\n \"*\u0004\u0018\u00010!0!H\u0002J\u000e\u0010*\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u000200J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u000201J\u0010\u00102\u001a\u00020\u00002\b\b\u0002\u00103\u001a\u000204J\b\u00105\u001a\u00020\u0000H\u0002J\u0010\u00106\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R$\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lio/github/kbiakov/codeview/CodeView;", "Landroid/widget/RelativeLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "adapter", "Lio/github/kbiakov/codeview/CodeContentAdapter;", "getAdapter", "()Lio/github/kbiakov/codeview/CodeContentAdapter;", "setAdapter", "(Lio/github/kbiakov/codeview/CodeContentAdapter;)V", "rvCodeContent", "Landroid/support/v7/widget/RecyclerView;", "state", "Lio/github/kbiakov/codeview/CodeView$ViewState;", "tasks", "Ljava/util/Queue;", "Lkotlin/Function0;", "", "vPlaceholder", "Landroid/view/View;", "vShadowBottomContent", "vShadowBottomLine", "vShadowRight", "addTask", "task", "build", "content", "", "getState", "hidePlaceholder", "Landroid/view/ViewPropertyAnimator;", "kotlin.jvm.PlatformType", "highlightCode", "language", "measurePlaceholder", "linesCount", "", "processBuildTasks", "refreshAnimated", "setCodeContent", "setCodeListener", "listener", "Lio/github/kbiakov/codeview/OnCodeLineClickListener;", "setColorTheme", "colorTheme", "Lio/github/kbiakov/codeview/highlight/ColorTheme;", "Lio/github/kbiakov/codeview/highlight/ColorThemeData;", "setShadowsVisible", "isVisible", "", "setupShadows", "update", "ViewState", "codeview-compileReleaseKotlin"})
public final class CodeView
extends RelativeLayout {
    private final View vPlaceholder;
    private final View vShadowRight;
    private final View vShadowBottomLine;
    private final View vShadowBottomContent;
    private final RecyclerView rvCodeContent;
    private final Queue<Function0<Unit>> tasks;
    private ViewState state;

    @NotNull
    public final ViewState getState() {
        return this.state;
    }

    @NotNull
    public final CodeContentAdapter getAdapter() {
        RecyclerView.Adapter adapter = this.rvCodeContent.getAdapter();
        if (adapter == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.github.kbiakov.codeview.CodeContentAdapter");
        }
        return (CodeContentAdapter)adapter;
    }

    public final void setAdapter(@NotNull CodeContentAdapter adapter) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)adapter), (String)"adapter");
        this.rvCodeContent.setAdapter((RecyclerView.Adapter)adapter);
        this.state = ViewState.PRESENTED;
    }

    private final CodeView addTask(Function0<Unit> task) {
        switch (CodeView$WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                this.tasks.add(task);
                break;
            }
            case 2: {
                CodeViewKt.delayed(Thread.INSTANCE, task);
                break;
            }
            case 3: {
                task.invoke();
            }
        }
        return this;
    }

    private final void processBuildTasks() {
        while (true) {
            Collection collection = this.tasks;
            if (!(!collection.isEmpty())) break;
            this.tasks.poll().invoke();
        }
    }

    @NotNull
    public final CodeView setColorTheme(@NotNull ColorTheme colorTheme) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)colorTheme), (String)"colorTheme");
        return this.addTask((Function0<Unit>)((Function0)new Function0<Unit>(this, colorTheme){
            final /* synthetic */ CodeView this$0;
            final /* synthetic */ ColorTheme $colorTheme;

            public final void invoke() {
                this.this$0.getAdapter().setColorTheme$codeview_compileReleaseKotlin(ColorTheme.with$default(this.$colorTheme, null, 0, 0, 0, 0, 31, null));
            }
            {
                this.this$0 = codeView;
                this.$colorTheme = colorTheme;
                super(0);
            }
        }));
    }

    @NotNull
    public final CodeView setColorTheme(@NotNull ColorThemeData colorTheme) {
        Intrinsics.checkParameterIsNotNull((Object)colorTheme, (String)"colorTheme");
        return this.addTask((Function0<Unit>)((Function0)new Function0<Unit>(this, colorTheme){
            final /* synthetic */ CodeView this$0;
            final /* synthetic */ ColorThemeData $colorTheme;

            public final void invoke() {
                this.this$0.getAdapter().setColorTheme$codeview_compileReleaseKotlin(this.$colorTheme);
            }
            {
                this.this$0 = codeView;
                this.$colorTheme = colorThemeData;
                super(0);
            }
        }));
    }

    @NotNull
    public final CodeView highlightCode(@NotNull String language) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        return this.addTask((Function0<Unit>)((Function0)new Function0<Unit>(this, language){
            final /* synthetic */ CodeView this$0;
            final /* synthetic */ String $language;

            public final void invoke() {
                this.this$0.getAdapter().highlightCode(this.$language);
            }
            {
                this.this$0 = codeView;
                this.$language = string2;
                super(0);
            }
        }));
    }

    @NotNull
    public final CodeView highlightCode() {
        return this.addTask((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ CodeView this$0;

            public final void invoke() {
                this.this$0.getAdapter().highlightCode((Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ highlightCode.2 this$0;

                    public final void invoke() {
                        CodeView.access$refreshAnimated(this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.this$0 = codeView;
                super(0);
            }
        }));
    }

    @NotNull
    public final CodeView setCodeListener(@NotNull OnCodeLineClickListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        return this.addTask((Function0<Unit>)((Function0)new Function0<Unit>(this, listener){
            final /* synthetic */ CodeView this$0;
            final /* synthetic */ OnCodeLineClickListener $listener;

            public final void invoke() {
                this.this$0.getAdapter().setCodeListener$codeview_compileReleaseKotlin(this.$listener);
            }
            {
                this.this$0 = codeView;
                this.$listener = onCodeLineClickListener;
                super(0);
            }
        }));
    }

    @NotNull
    public final CodeView setShadowsVisible(boolean isVisible) {
        return this.addTask((Function0<Unit>)((Function0)new Function0<Unit>(this, isVisible){
            final /* synthetic */ CodeView this$0;
            final /* synthetic */ boolean $isVisible;

            public final void invoke() {
                int visibility = this.$isVisible ? 0 : RelativeLayout.GONE;
                CodeView.access$getVShadowRight$p(this.this$0).setVisibility(visibility);
                CodeView.access$getVShadowBottomLine$p(this.this$0).setVisibility(visibility);
                CodeView.access$getVShadowBottomContent$p(this.this$0).setVisibility(visibility);
            }
            {
                this.this$0 = codeView;
                this.$isVisible = bl;
                super(0);
            }
        }));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ CodeView setShadowsVisible$default(CodeView codeView, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setShadowsVisible");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return codeView.setShadowsVisible(bl);
    }

    public final void setCodeContent(@NotNull String content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        switch (CodeView$WhenMappings.$EnumSwitchMapping$1[this.state.ordinal()]) {
            case 1: {
                this.build(content);
                break;
            }
            case 2: {
                CodeViewKt.delayed(Thread.INSTANCE, (Function0<Unit>)((Function0)new Function0<Unit>(this, content){
                    final /* synthetic */ CodeView this$0;
                    final /* synthetic */ String $content;

                    public final void invoke() {
                        CodeView.access$update(this.this$0, this.$content);
                    }
                    {
                        this.this$0 = codeView;
                        this.$content = string2;
                        super(0);
                    }
                }));
                break;
            }
            case 3: {
                this.update(content);
            }
        }
    }

    private final void build(String content) {
        int linesCount = UtilsKt.extractLines(content).size();
        this.measurePlaceholder(linesCount);
        this.state = ViewState.PREPARE;
        CodeViewKt.delayed(Thread.INSTANCE, (Function0<Unit>)((Function0)new Function0<Unit>(this, content){
            final /* synthetic */ CodeView this$0;
            final /* synthetic */ String $content;

            public final void invoke() {
                RecyclerView recyclerView = CodeView.access$getRvCodeContent$p(this.this$0);
                Context context = this.this$0.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                recyclerView.setAdapter((RecyclerView.Adapter)new CodeContentAdapter(context, this.$content, false, 0, null, null, 60, null));
                CodeView.access$processBuildTasks(this.this$0);
                CodeView.access$setupShadows(this.this$0);
                CodeView.access$hidePlaceholder(this.this$0);
                CodeView.access$setState$p(this.this$0, ViewState.PRESENTED);
            }
            {
                this.this$0 = codeView;
                this.$content = string2;
                super(0);
            }
        }));
    }

    private final void update(String content) {
        this.state = ViewState.PREPARE;
        this.measurePlaceholder(UtilsKt.extractLines(content).size());
        this.getAdapter().updateCodeContent(content);
        this.hidePlaceholder();
        this.state = ViewState.PRESENTED;
    }

    private final CodeView setupShadows() {
        return this.setShadowsVisible(!this.getAdapter().isFullShowing$codeview_compileReleaseKotlin());
    }

    private final void measurePlaceholder(int linesCount) {
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        int lineHeight = UtilsKt.dpToPx(context, 24);
        Context context2 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
        int topPadding = UtilsKt.dpToPx(context2, 8);
        int padding = (linesCount > 1 ? 2 : 1) * topPadding;
        int height = linesCount * lineHeight + padding;
        this.vPlaceholder.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, height));
        this.vPlaceholder.setVisibility(0);
    }

    private final ViewPropertyAnimator hidePlaceholder() {
        return CodeViewKt.didAnimated(this.vPlaceholder.animate().setDuration(350L).alpha(0.0f), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ CodeView this$0;

            public final void invoke() {
                CodeView.access$getVPlaceholder$p(this.this$0).setVisibility(8);
            }
            {
                this.this$0 = codeView;
                super(0);
            }
        }));
    }

    private final ViewPropertyAnimator refreshAnimated() {
        return CodeViewKt.didAnimated(this.animate().setDuration(150L).alpha(0.2f), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ CodeView this$0;

            public final void invoke() {
                this.this$0.getAdapter().notifyDataSetChanged();
                this.this$0.animate().alpha(1.0f);
            }
            {
                this.this$0 = codeView;
                super(0);
            }
        }));
    }

    public CodeView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        Object object = context.getSystemService("layout_inflater");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.LayoutInflater");
        }
        LayoutInflater inflater = (LayoutInflater)object;
        inflater.inflate(R.layout.layout_code_view, (ViewGroup)this, true);
        View view = this.findViewById(R.id.v_placeholder);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.v_placeholder)");
        this.vPlaceholder = view;
        View view2 = this.findViewById(R.id.v_shadow_right);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(R.id.v_shadow_right)");
        this.vShadowRight = view2;
        View view3 = this.findViewById(R.id.v_shadow_bottom_line);
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById(R.id.v_shadow_bottom_line)");
        this.vShadowBottomLine = view3;
        View view4 = this.findViewById(R.id.v_shadow_bottom_content);
        Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"findViewById(R.id.v_shadow_bottom_content)");
        this.vShadowBottomContent = view4;
        View view5 = this.findViewById(R.id.rv_code_content);
        if (view5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.support.v7.widget.RecyclerView");
        }
        this.rvCodeContent = (RecyclerView)view5;
        this.rvCodeContent.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        this.rvCodeContent.setNestedScrollingEnabled(true);
        this.tasks = new LinkedList();
        this.state = ViewState.BUILD;
    }

    public static final /* synthetic */ ViewPropertyAnimator access$refreshAnimated(CodeView $this) {
        return $this.refreshAnimated();
    }

    @NotNull
    public static final /* synthetic */ View access$getVShadowRight$p(CodeView $this) {
        return $this.vShadowRight;
    }

    @NotNull
    public static final /* synthetic */ View access$getVShadowBottomLine$p(CodeView $this) {
        return $this.vShadowBottomLine;
    }

    @NotNull
    public static final /* synthetic */ View access$getVShadowBottomContent$p(CodeView $this) {
        return $this.vShadowBottomContent;
    }

    public static final /* synthetic */ void access$update(CodeView $this, @NotNull String content) {
        $this.update(content);
    }

    @NotNull
    public static final /* synthetic */ RecyclerView access$getRvCodeContent$p(CodeView $this) {
        return $this.rvCodeContent;
    }

    public static final /* synthetic */ void access$processBuildTasks(CodeView $this) {
        $this.processBuildTasks();
    }

    @NotNull
    public static final /* synthetic */ CodeView access$setupShadows(CodeView $this) {
        return $this.setupShadows();
    }

    public static final /* synthetic */ ViewPropertyAnimator access$hidePlaceholder(CodeView $this) {
        return $this.hidePlaceholder();
    }

    @NotNull
    public static final /* synthetic */ ViewState access$getState$p(CodeView $this) {
        return $this.state;
    }

    public static final /* synthetic */ void access$setState$p(CodeView $this, @NotNull ViewState viewState) {
        $this.state = viewState;
    }

    @NotNull
    public static final /* synthetic */ View access$getVPlaceholder$p(CodeView $this) {
        return $this.vPlaceholder;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/github/kbiakov/codeview/CodeView$ViewState;", "", "(Ljava/lang/String;I)V", "BUILD", "PREPARE", "PRESENTED", "codeview-compileReleaseKotlin"})
    public static final class ViewState
    extends Enum<ViewState> {
        public static final /* enum */ ViewState BUILD;
        public static final /* enum */ ViewState PREPARE;
        public static final /* enum */ ViewState PRESENTED;
        private static final /* synthetic */ ViewState[] $VALUES;

        static {
            ViewState[] viewStateArray = new ViewState[3];
            ViewState[] viewStateArray2 = viewStateArray;
            viewStateArray[0] = BUILD = new ViewState();
            viewStateArray[1] = PREPARE = new ViewState();
            viewStateArray[2] = PRESENTED = new ViewState();
            $VALUES = viewStateArray;
        }

        public static ViewState[] values() {
            return (ViewState[])$VALUES.clone();
        }

        public static ViewState valueOf(String string2) {
            return Enum.valueOf(ViewState.class, string2);
        }
    }
}

