/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbiakov.codeview;

import android.content.Context;
import android.graphics.Typeface;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.github.kbiakov.codeview.OnCodeLineClickListener;
import io.github.kbiakov.codeview.R;
import io.github.kbiakov.codeview.Thread;
import io.github.kbiakov.codeview.UtilsKt;
import io.github.kbiakov.codeview.classifier.CodeClassifier;
import io.github.kbiakov.codeview.classifier.CodeProcessor;
import io.github.kbiakov.codeview.highlight.CodeHighlighter;
import io.github.kbiakov.codeview.highlight.CodeHighlighterKt;
import io.github.kbiakov.codeview.highlight.ColorTheme;
import io.github.kbiakov.codeview.highlight.ColorThemeData;
import io.github.kbiakov.codeview.highlight.MonoFontCache;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 C2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002CDBA\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0006\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ(\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0002J\b\u0010-\u001a\u00020\nH\u0016J\u0014\u0010.\u001a\u00020&2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020&00J\u000e\u0010.\u001a\u00020&2\u0006\u00101\u001a\u00020\u0006J \u00102\u001a\u00020&2\u0006\u00101\u001a\u00020\u00062\u000e\b\u0002\u0010/\u001a\b\u0012\u0004\u0012\u00020&00H\u0002J\u001a\u00103\u001a\u00020&2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\u0006H\u0002J\u0010\u00104\u001a\n 6*\u0004\u0018\u00010505H\u0002J\u0018\u00107\u001a\u00020&2\u0006\u00108\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\nH\u0016J\u0018\u00109\u001a\u00020\u00022\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\nH\u0016J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020&00H\u0002J\u000e\u0010>\u001a\u00020&2\u0006\u0010?\u001a\u00020\u0006J$\u0010@\u001a\u00020&2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00060\"2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020&00H\u0002R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lio/github/kbiakov/codeview/CodeContentAdapter;", "Landroid/support/v7/widget/RecyclerView$Adapter;", "Lio/github/kbiakov/codeview/CodeContentAdapter$ViewHolder;", "context", "Landroid/content/Context;", "content", "", "isShowFull", "", "maxLines", "", "shortcutNote", "listener", "Lio/github/kbiakov/codeview/OnCodeLineClickListener;", "(Landroid/content/Context;Ljava/lang/String;ZILjava/lang/String;Lio/github/kbiakov/codeview/OnCodeLineClickListener;)V", "codeListener", "getCodeListener$codeview_compileReleaseKotlin", "()Lio/github/kbiakov/codeview/OnCodeLineClickListener;", "setCodeListener$codeview_compileReleaseKotlin", "(Lio/github/kbiakov/codeview/OnCodeLineClickListener;)V", "colorTheme", "Lio/github/kbiakov/codeview/highlight/ColorThemeData;", "getColorTheme$codeview_compileReleaseKotlin", "()Lio/github/kbiakov/codeview/highlight/ColorThemeData;", "setColorTheme$codeview_compileReleaseKotlin", "(Lio/github/kbiakov/codeview/highlight/ColorThemeData;)V", "isFullShowing", "isFullShowing$codeview_compileReleaseKotlin", "()Z", "setFullShowing$codeview_compileReleaseKotlin", "(Z)V", "mContent", "mContext", "mDroppedLines", "", "mLines", "mMaxLines", "addExtraPadding", "", "position", "itemView", "Landroid/view/View;", "tvLineNum", "Landroid/widget/TextView;", "tvLineContent", "getItemCount", "highlightCode", "onReady", "Lkotlin/Function0;", "language", "highlighting", "initCodeContent", "monoTypeface", "Landroid/graphics/Typeface;", "kotlin.jvm.PlatformType", "onBindViewHolder", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "refresh", "updateCodeContent", "newContent", "updateContent", "codeLines", "onUpdated", "Companion", "ViewHolder", "codeview-compileReleaseKotlin"})
public final class CodeContentAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private final Context mContext;
    private String mContent;
    private List<String> mLines;
    private final int mMaxLines;
    private List<String> mDroppedLines;
    private boolean isFullShowing;
    @Nullable
    private OnCodeLineClickListener codeListener;
    @NotNull
    private ColorThemeData colorTheme;
    private static final int MAX_SHORTCUT_LINES = 6;
    public static final Companion Companion = new Companion(null);

    public final boolean isFullShowing$codeview_compileReleaseKotlin() {
        return this.isFullShowing;
    }

    public final void setFullShowing$codeview_compileReleaseKotlin(boolean bl) {
        this.isFullShowing = bl;
    }

    @Nullable
    public final OnCodeLineClickListener getCodeListener$codeview_compileReleaseKotlin() {
        return this.codeListener;
    }

    public final void setCodeListener$codeview_compileReleaseKotlin(@Nullable OnCodeLineClickListener onCodeLineClickListener) {
        this.codeListener = onCodeLineClickListener;
    }

    @NotNull
    public final ColorThemeData getColorTheme$codeview_compileReleaseKotlin() {
        return this.colorTheme;
    }

    public final void setColorTheme$codeview_compileReleaseKotlin(@NotNull ColorThemeData colorTheme) {
        Intrinsics.checkParameterIsNotNull((Object)colorTheme, (String)"colorTheme");
        this.colorTheme = colorTheme;
        this.notifyDataSetChanged();
    }

    private final void initCodeContent(boolean isShowFull, String shortcutNote) {
        List<String> lines = new ArrayList(UtilsKt.extractLines(this.mContent));
        boolean bl = this.isFullShowing = isShowFull || lines.size() <= this.mMaxLines;
        if (!this.isFullShowing) {
            this.mDroppedLines = new ArrayList(lines.subList(this.mMaxLines, CollectionsKt.getLastIndex((List)lines)));
            lines = lines.subList(0, this.mMaxLines);
            String string2 = shortcutNote;
            List<String> list = lines;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
            String string5 = string4;
            list.add(string5);
        }
        this.mLines = lines;
    }

    static /* bridge */ /* synthetic */ void initCodeContent$default(CodeContentAdapter codeContentAdapter, boolean bl, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: initCodeContent");
        }
        if ((n & 2) != 0) {
            String string3 = codeContentAdapter.mContext.getString(R.string.show_all);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"mContext.getString(R.string.show_all)");
            string2 = string3;
        }
        codeContentAdapter.initCodeContent(bl, string2);
    }

    public final void updateCodeContent(@NotNull String newContent) {
        Intrinsics.checkParameterIsNotNull((Object)newContent, (String)"newContent");
        this.mContent = newContent;
        CodeContentAdapter.initCodeContent$default(this, this.isFullShowing, null, 2, null);
        this.notifyDataSetChanged();
    }

    public final void highlightCode(@NotNull String language) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        Thread.INSTANCE.async((Function0<Unit>)((Function0)new Function0<Unit>(this, language){
            final /* synthetic */ CodeContentAdapter this$0;
            final /* synthetic */ String $language;

            public final void invoke() {
                CodeContentAdapter.highlighting$default(this.this$0, this.$language, null, 2, null);
            }
            {
                this.this$0 = codeContentAdapter;
                this.$language = string2;
                super(0);
            }
        }));
    }

    public final void highlightCode(@NotNull Function0<Unit> onReady) {
        Intrinsics.checkParameterIsNotNull(onReady, (String)"onReady");
        Thread.INSTANCE.async((Function0<Unit>)((Function0)new Function0<Unit>(this, onReady){
            final /* synthetic */ CodeContentAdapter this$0;
            final /* synthetic */ Function0 $onReady;

            public final void invoke() {
                String language;
                CodeProcessor processor = CodeProcessor.getInstance(CodeContentAdapter.access$getMContext$p(this.this$0));
                String string2 = language = processor.isTrained() ? processor.classify(CodeContentAdapter.access$getMContent$p(this.this$0)).get() : CodeClassifier.DEFAULT_LANGUAGE;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"language");
                CodeContentAdapter.access$highlighting(this.this$0, string2, this.$onReady);
            }
            {
                this.this$0 = codeContentAdapter;
                this.$onReady = function0;
                super(0);
            }
        }));
    }

    private final void updateContent(List<String> codeLines, Function0<Unit> onUpdated) {
        Thread.INSTANCE.ui((Function0<Unit>)((Function0)new Function0<Unit>(this, codeLines, onUpdated){
            final /* synthetic */ CodeContentAdapter this$0;
            final /* synthetic */ List $codeLines;
            final /* synthetic */ Function0 $onUpdated;

            public final void invoke() {
                CodeContentAdapter.access$setMLines$p(this.this$0, this.$codeLines);
                this.$onUpdated.invoke();
            }
            {
                this.this$0 = codeContentAdapter;
                this.$codeLines = list;
                this.$onUpdated = function0;
                super(0);
            }
        }));
    }

    private final Function0<Unit> refresh() {
        return (Function0)new Function0<Unit>(this){
            final /* synthetic */ CodeContentAdapter this$0;

            public final void invoke() {
                this.this$0.notifyDataSetChanged();
            }
            {
                this.this$0 = codeContentAdapter;
                super(0);
            }
        };
    }

    private final void highlighting(String language, Function0<Unit> onReady) {
        String code = CodeHighlighter.INSTANCE.highlight(language, this.mContent, this.colorTheme);
        List<String> lines = UtilsKt.extractLines(code);
        this.updateContent(lines, onReady);
    }

    static /* bridge */ /* synthetic */ void highlighting$default(CodeContentAdapter codeContentAdapter, String string2, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: highlighting");
        }
        if ((n & 2) != 0) {
            function0 = codeContentAdapter.refresh();
        }
        codeContentAdapter.highlighting(string2, function0);
    }

    private final Typeface monoTypeface() {
        return MonoFontCache.getInstance(this.mContext).getTypeface();
    }

    @NotNull
    public ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        View lineView = inflater.inflate(R.layout.item_code_line, parent, false);
        lineView.setBackgroundColor(CodeHighlighterKt.color(this.colorTheme.getBgContent()));
        View view = lineView.findViewById(R.id.tv_line_num);
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
        }
        TextView tvLineNum = (TextView)view;
        tvLineNum.setTypeface(this.monoTypeface());
        tvLineNum.setTextColor(CodeHighlighterKt.color(this.colorTheme.getNumColor()));
        tvLineNum.setBackgroundColor(CodeHighlighterKt.color(this.colorTheme.getBgNum()));
        View view2 = lineView.findViewById(R.id.tv_line_content);
        if (view2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
        }
        TextView tvLineContent = (TextView)view2;
        tvLineContent.setTypeface(this.monoTypeface());
        View view3 = lineView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"lineView");
        return new ViewHolder(view3);
    }

    public void onBindViewHolder(@NotNull ViewHolder holder, int position) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        String codeLine = this.mLines.get(position);
        holder.setMItem(codeLine);
        holder.itemView.setOnClickListener(new View.OnClickListener(this, position){
            final /* synthetic */ CodeContentAdapter this$0;
            final /* synthetic */ int $position;

            public final void onClick(View it) {
                block0: {
                    OnCodeLineClickListener onCodeLineClickListener = this.this$0.getCodeListener$codeview_compileReleaseKotlin();
                    if (onCodeLineClickListener == null) break block0;
                    onCodeLineClickListener.onCodeLineClicked(this.$position);
                }
            }
            {
                this.this$0 = codeContentAdapter;
                this.$position = n;
            }
        });
        holder.getTvLineContent().setText((CharSequence)UtilsKt.html(codeLine));
        if (!this.isFullShowing && position == CodeContentAdapter.MAX_SHORTCUT_LINES) {
            holder.getTvLineNum().setTextSize(10.0f);
            holder.getTvLineNum().setText((CharSequence)this.mContext.getString(R.string.dots));
            holder.getTvLineContent().setTextColor(CodeHighlighterKt.color(this.colorTheme.getNoteColor()));
        } else {
            holder.getTvLineNum().setTextSize(12.0f);
            holder.getTvLineNum().setText((CharSequence)String.valueOf(position + 1));
        }
        View view = holder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"holder.itemView");
        this.addExtraPadding(position, view, holder.getTvLineNum(), holder.getTvLineContent());
    }

    public int getItemCount() {
        return this.mLines.size();
    }

    private final void addExtraPadding(int position, View itemView, TextView tvLineNum, TextView tvLineContent) {
        boolean isLast;
        int dp8 = UtilsKt.dpToPx(this.mContext, 8);
        boolean isFirst = position == 0;
        boolean bl = isLast = position == this.getItemCount() - 1;
        if (isFirst || isLast) {
            itemView.getLayoutParams().height = dp8 * 4;
            int topPadding = isFirst ? dp8 : 0;
            int bottomPadding = isLast ? dp8 : 0;
            tvLineNum.setPadding(0, topPadding, 0, bottomPadding);
            tvLineContent.setPadding(0, topPadding, 0, bottomPadding);
        } else {
            itemView.getLayoutParams().height = dp8 * 3;
            tvLineNum.setPadding(0, 0, 0, 0);
            tvLineContent.setPadding(0, 0, 0, 0);
        }
    }

    public CodeContentAdapter(@NotNull Context context, @NotNull String content, boolean isShowFull, int maxLines, @NotNull String shortcutNote, @Nullable OnCodeLineClickListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)shortcutNote, (String)"shortcutNote");
        this.mLines = new ArrayList();
        this.mDroppedLines = null;
        this.isFullShowing = true;
        this.setColorTheme$codeview_compileReleaseKotlin(ColorTheme.with$default(ColorTheme.SOLARIZED_LIGHT, null, 0, 0, 0, 0, 31, null));
        this.mContext = context;
        this.mContent = content;
        this.mMaxLines = maxLines;
        this.codeListener = listener;
        if (isShowFull) {
            this.isFullShowing = true;
            this.mLines = UtilsKt.extractLines(content);
        } else {
            this.initCodeContent(isShowFull, shortcutNote);
        }
    }

    public /* synthetic */ CodeContentAdapter(Context context, String string2, boolean bl, int n, String string3, OnCodeLineClickListener onCodeLineClickListener, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        if ((n2 & 8) != 0) {
            n = CodeContentAdapter.MAX_SHORTCUT_LINES;
        }
        if ((n2 & 0x10) != 0) {
            String string4 = context.getString(R.string.show_all);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"context.getString(R.string.show_all)");
            string3 = string4;
        }
        if ((n2 & 0x20) != 0) {
            onCodeLineClickListener = null;
        }
        this(context, string2, bl, n, string3, onCodeLineClickListener);
    }

    @NotNull
    public static final /* synthetic */ Context access$getMContext$p(CodeContentAdapter $this) {
        return $this.mContext;
    }

    @NotNull
    public static final /* synthetic */ String access$getMContent$p(CodeContentAdapter $this) {
        return $this.mContent;
    }

    public static final /* synthetic */ void access$setMContent$p(CodeContentAdapter $this, @NotNull String string2) {
        $this.mContent = string2;
    }

    public static final /* synthetic */ void access$highlighting(CodeContentAdapter $this, @NotNull String language, @NotNull Function0 onReady) {
        $this.highlighting(language, (Function0<Unit>)onReady);
    }

    @NotNull
    public static final /* synthetic */ List access$getMLines$p(CodeContentAdapter $this) {
        return $this.mLines;
    }

    public static final /* synthetic */ void access$setMLines$p(CodeContentAdapter $this, @NotNull List list) {
        $this.mLines = list;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0006H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lio/github/kbiakov/codeview/CodeContentAdapter$ViewHolder;", "Landroid/support/v7/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "mItem", "", "getMItem", "()Ljava/lang/String;", "setMItem", "(Ljava/lang/String;)V", "tvLineContent", "Landroid/widget/TextView;", "getTvLineContent", "()Landroid/widget/TextView;", "setTvLineContent", "(Landroid/widget/TextView;)V", "tvLineNum", "getTvLineNum", "setTvLineNum", "toString", "codeview-compileReleaseKotlin"})
    public static final class ViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private TextView tvLineNum;
        @NotNull
        private TextView tvLineContent;
        @Nullable
        private String mItem;

        @NotNull
        public final TextView getTvLineNum() {
            return this.tvLineNum;
        }

        public final void setTvLineNum(@NotNull TextView textView) {
            Intrinsics.checkParameterIsNotNull((Object)textView, (String)"<set-?>");
            this.tvLineNum = textView;
        }

        @NotNull
        public final TextView getTvLineContent() {
            return this.tvLineContent;
        }

        public final void setTvLineContent(@NotNull TextView textView) {
            Intrinsics.checkParameterIsNotNull((Object)textView, (String)"<set-?>");
            this.tvLineContent = textView;
        }

        @Nullable
        public final String getMItem() {
            return this.mItem;
        }

        public final void setMItem(@Nullable String string) {
            this.mItem = string;
        }

        @NotNull
        public String toString() {
            return super.toString() + " '" + this.mItem + "'";
        }

        public ViewHolder(@NotNull View itemView) {
            Intrinsics.checkParameterIsNotNull((Object)itemView, (String)"itemView");
            super(itemView);
            View view = itemView.findViewById(R.id.tv_line_num);
            if (view == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
            }
            this.tvLineNum = (TextView)view;
            View view2 = itemView.findViewById(R.id.tv_line_content);
            if (view2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
            }
            this.tvLineContent = (TextView)view2;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/github/kbiakov/codeview/CodeContentAdapter$Companion;", "", "()V", "MAX_SHORTCUT_LINES", "", "codeview-compileReleaseKotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

