/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbiakov.codeview.classifier;

import android.content.Context;
import io.github.kbiakov.codeview.classifier.CodeClassifier;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class CodeProcessor {
    private static final String TAG = "CodeClassifier";
    private static volatile CodeProcessor sInstance;
    private static Future<CodeProcessor> sTrainingTaskFuture;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CodeProcessor getInstance(Context context) {
        if (!CodeProcessor.notInstanceAvailable()) return sInstance;
        Class<CodeClassifier> clazz = CodeClassifier.class;
        synchronized (CodeClassifier.class) {
            if (!CodeProcessor.notInstanceAvailable()) return sInstance;
            sInstance = new CodeProcessor(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    private CodeProcessor(Context context) {
        CodeClassifier.INSTANCE.train(context);
    }

    private static boolean notInstanceAvailable() {
        if (sInstance == null) {
            if (!sTrainingTaskFuture.isDone()) {
                try {
                    sInstance = sTrainingTaskFuture.get();
                    return false;
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    public boolean isTrained() {
        return sTrainingTaskFuture != null;
    }

    public static void init(Context context) {
        if (sInstance != null) {
            throw new IllegalStateException("Attempt to train code classifier twice.\nIt should be initialized once at start to make train asynchronously.");
        }
        ExecutorService service = Executors.newSingleThreadExecutor();
        sTrainingTaskFuture = service.submit(new TrainingTask(context));
    }

    public Future<String> classify(String snippet) {
        ExecutorService service = Executors.newSingleThreadExecutor();
        return service.submit(new ClassifyingTask(snippet));
    }

    private static class ClassifyingTask
    implements Callable<String> {
        private String snippet;

        public ClassifyingTask(String snippet) {
            this.snippet = snippet;
        }

        @Override
        public String call() {
            return CodeClassifier.INSTANCE.classify(this.snippet);
        }
    }

    private static class TrainingTask
    implements Callable<CodeProcessor> {
        private Context context;

        public TrainingTask(Context context) {
            this.context = context;
        }

        @Override
        public CodeProcessor call() {
            return new CodeProcessor(this.context);
        }
    }
}

