/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbiakov.codeview.highlight;

import io.github.kbiakov.codeview.highlight.CodeHighlighter;
import io.github.kbiakov.codeview.highlight.CodeHighlighterKt;
import io.github.kbiakov.codeview.highlight.ColorThemeData;
import io.github.kbiakov.codeview.highlight.SyntaxColors;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import prettify.PrettifyParser;
import syntaxhighlight.ParseResult;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000=\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b*\u0001\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ&\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\f\u0010\u0019\u001a\u00020\u0006*\u00020\u0006H\u0002J\f\u0010\u001a\u001a\u00020\u0006*\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/github/kbiakov/codeview/highlight/CodeHighlighter;", "", "()V", "LT_BRACE", "Lkotlin/text/Regex;", "LT_REGULAR", "", "LT_TMP", "parser", "Lprettify/PrettifyParser;", "buildColorsMap", "io/github/kbiakov/codeview/highlight/CodeHighlighter$buildColorsMap$1", "colorTheme", "Lio/github/kbiakov/codeview/highlight/ColorThemeData;", "(Lio/github/kbiakov/codeview/highlight/ColorThemeData;)Lio/github/kbiakov/codeview/highlight/CodeHighlighter$buildColorsMap$1;", "getColor", "colorsMap", "Ljava/util/HashMap;", "result", "Lsyntaxhighlight/ParseResult;", "highlight", "codeLanguage", "rawSource", "parseContent", "codeContent", "escapeLT", "expandLT", "codeview-compileReleaseKotlin"})
public final class CodeHighlighter {
    private static final Regex LT_BRACE;
    private static final String LT_REGULAR = "&lt;";
    private static final String LT_TMP = "^";
    private static final PrettifyParser parser;
    public static final CodeHighlighter INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String highlight(@NotNull String codeLanguage, @NotNull String rawSource, @NotNull ColorThemeData colorTheme) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)codeLanguage, (String)"codeLanguage");
        Intrinsics.checkParameterIsNotNull((Object)rawSource, (String)"rawSource");
        Intrinsics.checkParameterIsNotNull((Object)colorTheme, (String)"colorTheme");
        String source = this.escapeLT(rawSource);
        List results = parser.parse(codeLanguage, source);
        buildColorsMap.1 colorsMap = this.buildColorsMap(colorTheme);
        StringBuilder highlighted = new StringBuilder();
        Iterable iterable = results;
        for (Object element$iv : $receiver$iv) {
            ParseResult result = (ParseResult)element$iv;
            HashMap hashMap = colorsMap;
            ParseResult parseResult = result;
            Intrinsics.checkExpressionValueIsNotNull((Object)parseResult, (String)"result");
            String color = INSTANCE.getColor(hashMap, parseResult);
            ParseResult parseResult2 = result;
            Intrinsics.checkExpressionValueIsNotNull((Object)parseResult2, (String)"result");
            String content = INSTANCE.parseContent(source, parseResult2);
            highlighted.append("<font color=" + "\"" + color + "\"" + ">" + content + "</font>");
        }
        String string = highlighted.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"highlighted.toString()");
        return string;
    }

    private final String parseContent(String codeContent, ParseResult result) {
        int length = result.getOffset() + result.getLength();
        String string = codeContent;
        int n = result.getOffset();
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, length);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String content = string3;
        return this.expandLT(content);
    }

    private final String getColor(HashMap<String, String> colorsMap, ParseResult result) {
        String string = colorsMap.get(result.getStyleKeys().get(0));
        if (string == null) {
            string = colorsMap.get("pln");
        }
        return string;
    }

    private final buildColorsMap.1 buildColorsMap(ColorThemeData colorTheme) {
        return new HashMap<String, String>(colorTheme){
            final /* synthetic */ ColorThemeData $colorTheme;
            {
                this.$colorTheme = $captured_local_variable$0;
                SyntaxColors syntaxColors = $captured_local_variable$0.getSyntaxColors();
                this.put("typ", CodeHighlighterKt.hex(syntaxColors.getType()));
                this.put("kwd", CodeHighlighterKt.hex(syntaxColors.getKeyword()));
                this.put("lit", CodeHighlighterKt.hex(syntaxColors.getLiteral()));
                this.put("com", CodeHighlighterKt.hex(syntaxColors.getComment()));
                this.put("str", CodeHighlighterKt.hex(syntaxColors.getString()));
                this.put("pun", CodeHighlighterKt.hex(syntaxColors.getPunctuation()));
                this.put("pln", CodeHighlighterKt.hex(syntaxColors.getPlain()));
                this.put("tag", CodeHighlighterKt.hex(syntaxColors.getTag()));
                this.put("dec", CodeHighlighterKt.hex(syntaxColors.getDeclaration()));
                this.put("src", CodeHighlighterKt.hex(syntaxColors.getPlain()));
                this.put("atn", CodeHighlighterKt.hex(syntaxColors.getAttrName()));
                this.put("atv", CodeHighlighterKt.hex(syntaxColors.getAttrValue()));
                this.put("nocode", CodeHighlighterKt.hex(syntaxColors.getPlain()));
            }
        };
    }

    private final String escapeLT(@NotNull String $receiver) {
        CharSequence charSequence = $receiver;
        Regex regex = LT_BRACE;
        String string = LT_TMP;
        return regex.replace(charSequence, string);
    }

    private final String expandLT(@NotNull String $receiver) {
        return StringsKt.replace$default((String)$receiver, (String)LT_TMP, (String)LT_REGULAR, (boolean)false, (int)4, null);
    }

    private CodeHighlighter() {
        INSTANCE = this;
        String string = "<";
        LT_BRACE = new Regex(string);
        LT_REGULAR = LT_REGULAR;
        LT_TMP = LT_TMP;
        parser = new PrettifyParser();
    }

    static {
        new CodeHighlighter();
    }
}

