/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.jsonviewer.library;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.yuyh.jsonviewer.library.adapter.BaseJsonViewerAdapter;
import com.yuyh.jsonviewer.library.adapter.JsonViewerAdapter;
import com.yuyh.jsonviewer.library.view.JsonItemView;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonRecyclerView
extends RecyclerView {
    private BaseJsonViewerAdapter mAdapter;
    int mode;
    float oldDist;
    private RecyclerView.OnItemTouchListener touchListener = new RecyclerView.OnItemTouchListener(){

        public boolean onInterceptTouchEvent(RecyclerView rv, MotionEvent event) {
            switch (event.getAction() & event.getActionMasked()) {
                case 0: {
                    JsonRecyclerView.this.mode = 1;
                    break;
                }
                case 1: {
                    JsonRecyclerView.this.mode = 0;
                    break;
                }
                case 6: {
                    --JsonRecyclerView.this.mode;
                    break;
                }
                case 5: {
                    JsonRecyclerView.this.oldDist = JsonRecyclerView.this.spacing(event);
                    ++JsonRecyclerView.this.mode;
                    break;
                }
                case 2: {
                    float newDist;
                    if (JsonRecyclerView.this.mode < 2 || !(Math.abs((newDist = JsonRecyclerView.this.spacing(event)) - JsonRecyclerView.this.oldDist) > 0.5f)) break;
                    JsonRecyclerView.this.zoom(newDist / JsonRecyclerView.this.oldDist);
                    JsonRecyclerView.this.oldDist = newDist;
                }
            }
            return false;
        }

        public void onTouchEvent(RecyclerView rv, MotionEvent event) {
        }

        public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        }
    };

    public JsonRecyclerView(Context context) {
        this(context, null);
    }

    public JsonRecyclerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public JsonRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    private void initView() {
        this.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
    }

    public void bindJson(String jsonStr) {
        this.mAdapter = null;
        this.mAdapter = new JsonViewerAdapter(jsonStr);
        this.setAdapter(this.mAdapter);
    }

    public void bindJson(JSONArray array) {
        this.mAdapter = null;
        this.mAdapter = new JsonViewerAdapter(array);
        this.setAdapter(this.mAdapter);
    }

    public void bindJson(JSONObject object) {
        this.mAdapter = null;
        this.mAdapter = new JsonViewerAdapter(object);
        this.setAdapter(this.mAdapter);
    }

    public void setKeyColor(int color) {
        BaseJsonViewerAdapter.KEY_COLOR = color;
    }

    public void setValueTextColor(int color) {
        BaseJsonViewerAdapter.TEXT_COLOR = color;
    }

    public void setValueNumberColor(int color) {
        BaseJsonViewerAdapter.NUMBER_COLOR = color;
    }

    public void setValueBooleanColor(int color) {
        BaseJsonViewerAdapter.BOOLEAN_COLOR = color;
    }

    public void setValueUrlColor(int color) {
        BaseJsonViewerAdapter.URL_COLOR = color;
    }

    public void setValueNullColor(int color) {
        BaseJsonViewerAdapter.NUMBER_COLOR = color;
    }

    public void setBracesColor(int color) {
        BaseJsonViewerAdapter.BRACES_COLOR = color;
    }

    public void setTextSize(float sizeDP) {
        if (sizeDP < 10.0f) {
            sizeDP = 10.0f;
        } else if (sizeDP > 30.0f) {
            sizeDP = 30.0f;
        }
        if (BaseJsonViewerAdapter.TEXT_SIZE_DP != sizeDP) {
            BaseJsonViewerAdapter.TEXT_SIZE_DP = sizeDP;
            if (this.mAdapter != null) {
                this.updateAll(sizeDP);
            }
        }
    }

    public void setScaleEnable(boolean enable) {
        if (enable) {
            this.addOnItemTouchListener(this.touchListener);
        } else {
            this.removeOnItemTouchListener(this.touchListener);
        }
    }

    public void updateAll(float textSize) {
        RecyclerView.LayoutManager manager = this.getLayoutManager();
        int count = manager.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = manager.getChildAt(i);
            this.loop(view, textSize);
        }
    }

    private void loop(View view, float textSize) {
        if (view instanceof JsonItemView) {
            JsonItemView group = (JsonItemView)view;
            group.setTextSize(textSize);
            int childCount = group.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View view1 = group.getChildAt(i);
                this.loop(view1, textSize);
            }
        }
    }

    private void zoom(float f) {
        this.setTextSize(BaseJsonViewerAdapter.TEXT_SIZE_DP * f);
    }

    private float spacing(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }
}

