/*
 * Decompiled with CFR 0.152.
 */
package io.federecio.dropwizard.swagger;

import com.google.common.base.Predicate;
import com.google.common.reflect.TypeToken;
import io.swagger.annotations.Api;
import io.swagger.annotations.SwaggerDefinition;
import io.swagger.jaxrs.config.BeanConfig;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.Path;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class FastBeanConfig
extends BeanConfig {
    public Set<Class<?>> classes() {
        ConfigurationBuilder config = new ConfigurationBuilder();
        HashSet<String> acceptablePackages = new HashSet<String>();
        boolean allowAllPackages = false;
        if (this.getResourcePackage() != null && !"".equals(this.getResourcePackage())) {
            String[] parts;
            for (String pkg : parts = this.getResourcePackage().split(",")) {
                if ("".equals(pkg)) continue;
                acceptablePackages.add(pkg);
                config.addUrls(ClasspathHelper.forPackage((String)pkg, (ClassLoader[])new ClassLoader[0]));
            }
        } else {
            allowAllPackages = true;
        }
        config.setExpandSuperTypes(this.getExpandSuperTypes());
        config.setScanners(new Scanner[]{new ResourcesScanner(), new TypeAnnotationsScanner(), new SubTypesScanner()});
        if (!allowAllPackages) {
            config.setInputsFilter((Predicate)new FilterBuilder().includePackage(acceptablePackages.toArray(new String[acceptablePackages.size()])));
        }
        Reflections reflections = new Reflections((Configuration)config);
        Set classes = reflections.getTypesAnnotatedWith(Path.class);
        Set typesAnnotatedWith = reflections.getTypesAnnotatedWith(SwaggerDefinition.class);
        classes.addAll(typesAnnotatedWith);
        block1: for (Class cls : reflections.getTypesAnnotatedWith(Api.class)) {
            for (Class intfc : TypeToken.of((Class)cls).getTypes().interfaces().rawTypes()) {
                Path ann = intfc.getAnnotation(Path.class);
                if (ann == null) continue;
                classes.add(cls);
                continue block1;
            }
        }
        HashSet output = new HashSet();
        block3: for (Class cls : classes) {
            if (allowAllPackages) {
                output.add(cls);
                continue;
            }
            for (String pkg : acceptablePackages) {
                if (!(cls.getPackage().getName() + ".").startsWith(pkg + ".")) continue;
                output.add(cls);
                continue block3;
            }
        }
        return output;
    }
}

