/*
 * Decompiled with CFR 0.152.
 */
package io.federecio.dropwizard.sample;

import com.google.common.collect.Lists;
import io.dropwizard.Application;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.auth.AuthDynamicFeature;
import io.dropwizard.auth.AuthFilter;
import io.dropwizard.auth.AuthValueFactoryProvider;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.PrincipalImpl;
import io.dropwizard.auth.basic.BasicCredentialAuthFilter;
import io.dropwizard.auth.chained.ChainedAuthFilter;
import io.dropwizard.auth.oauth.OAuthCredentialAuthFilter;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.federecio.dropwizard.sample.OAuth2Resource;
import io.federecio.dropwizard.sample.SampleBasicAuthenticator;
import io.federecio.dropwizard.sample.SampleConfiguration;
import io.federecio.dropwizard.sample.SampleOAuth2Authenticator;
import io.federecio.dropwizard.sample.SampleResource;
import io.federecio.dropwizard.swagger.SwaggerBundle;
import io.federecio.dropwizard.swagger.SwaggerBundleConfiguration;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.container.ContainerRequestFilter;
import org.glassfish.jersey.server.filter.RolesAllowedDynamicFeature;

public class SampleApplication
extends Application<SampleConfiguration> {
    public static void main(String[] args) throws Exception {
        new SampleApplication().run(args);
    }

    public String getName() {
        return "sample";
    }

    public void initialize(Bootstrap<SampleConfiguration> bootstrap) {
        bootstrap.addBundle((ConfiguredBundle)new SwaggerBundle<SampleConfiguration>(){

            @Override
            protected SwaggerBundleConfiguration getSwaggerBundleConfiguration(SampleConfiguration configuration) {
                return configuration.getSwagger();
            }
        });
    }

    public void run(SampleConfiguration configuration, Environment environment) throws Exception {
        BasicCredentialAuthFilter basicCredentialAuthFilter = (BasicCredentialAuthFilter)new BasicCredentialAuthFilter.Builder().setAuthenticator((Authenticator)new SampleBasicAuthenticator()).setPrefix("Basic").buildAuthFilter();
        OAuthCredentialAuthFilter oauthCredentialAuthFilter = (OAuthCredentialAuthFilter)new OAuthCredentialAuthFilter.Builder().setAuthenticator((Authenticator)new SampleOAuth2Authenticator()).setPrefix("Bearer").buildAuthFilter();
        ArrayList filters = Lists.newArrayList((Object[])new AuthFilter[]{basicCredentialAuthFilter, oauthCredentialAuthFilter});
        environment.jersey().register((Object)new AuthDynamicFeature((ContainerRequestFilter)new ChainedAuthFilter((List)filters)));
        environment.jersey().register(RolesAllowedDynamicFeature.class);
        environment.jersey().register((Object)new AuthValueFactoryProvider.Binder(PrincipalImpl.class));
        environment.jersey().register((Object)new SampleResource());
        environment.jersey().register((Object)new OAuth2Resource(configuration.getSwagger().getSwaggerOAuth2Configuration()));
    }
}

