/*
 * Decompiled with CFR 0.152.
 */
package io.federecio.dropwizard.sample;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.federecio.dropwizard.swagger.SwaggerOAuth2Configuration;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

@Path(value="/oauth2")
public class OAuth2Resource {
    public static final String MOCKED_OAUTH2_TOKEN = UUID.randomUUID().toString();
    private final SwaggerOAuth2Configuration oAuth2Configuration;

    public OAuth2Resource(SwaggerOAuth2Configuration oAuth2Configuration) {
        this.oAuth2Configuration = oAuth2Configuration;
    }

    @GET
    @Path(value="/auth")
    @Produces(value={"application/json"})
    public Response auth(@QueryParam(value="response_type") String responseType, @QueryParam(value="client_id") @DefaultValue(value="") String clientId, @QueryParam(value="client_secret") @DefaultValue(value="") String clientSecret, @QueryParam(value="scope") String scope, @QueryParam(value="state") String state, @QueryParam(value="redirect_uri") String redirectUri, @QueryParam(value="realm") @DefaultValue(value="") String realm) throws URISyntaxException {
        try {
            Preconditions.checkArgument((boolean)clientId.equals(this.oAuth2Configuration.getClientId()), (Object)"Bad client id");
            if (!Strings.isNullOrEmpty((String)this.oAuth2Configuration.getClientSecret())) {
                Preconditions.checkArgument((boolean)clientSecret.equals(this.oAuth2Configuration.getClientSecret()), (Object)"Bad client secret");
            }
            Preconditions.checkArgument((boolean)realm.equals(this.oAuth2Configuration.getRealm()), (Object)"Bad realm");
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage());
        }
        URI redirectWithAccessToken = UriBuilder.fromUri((String)redirectUri).queryParam("state", new Object[]{state}).queryParam("access_token", new Object[]{MOCKED_OAUTH2_TOKEN}).build(new Object[0]);
        return Response.seeOther((URI)redirectWithAccessToken).build();
    }
}

