/*
 * Decompiled with CFR 0.152.
 */
package com.smarteist.autoimageslider.IndicatorView.draw.drawer.type;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import com.smarteist.autoimageslider.IndicatorView.animation.type.IndicatorAnimationType;
import com.smarteist.autoimageslider.IndicatorView.draw.data.Indicator;
import com.smarteist.autoimageslider.IndicatorView.draw.drawer.type.BaseDrawer;

public class BasicDrawer
extends BaseDrawer {
    private Paint strokePaint = new Paint();

    public BasicDrawer(@NonNull Paint paint, @NonNull Indicator indicator) {
        super(paint, indicator);
        this.strokePaint.setStyle(Paint.Style.STROKE);
        this.strokePaint.setAntiAlias(true);
        this.strokePaint.setStrokeWidth((float)indicator.getStroke());
    }

    public void draw(@NonNull Canvas canvas, int position, boolean isSelectedItem, int coordinateX, int coordinateY) {
        Paint paint;
        float radius = this.indicator.getRadius();
        int strokePx = this.indicator.getStroke();
        float scaleFactor = this.indicator.getScaleFactor();
        int selectedColor = this.indicator.getSelectedColor();
        int unselectedColor = this.indicator.getUnselectedColor();
        int selectedPosition = this.indicator.getSelectedPosition();
        IndicatorAnimationType animationType = this.indicator.getAnimationType();
        if (animationType == IndicatorAnimationType.SCALE && !isSelectedItem) {
            radius *= scaleFactor;
        } else if (animationType == IndicatorAnimationType.SCALE_DOWN && isSelectedItem) {
            radius *= scaleFactor;
        }
        int color = unselectedColor;
        if (position == selectedPosition) {
            color = selectedColor;
        }
        if (animationType == IndicatorAnimationType.FILL && position != selectedPosition) {
            paint = this.strokePaint;
            paint.setStrokeWidth((float)strokePx);
        } else {
            paint = this.paint;
        }
        paint.setColor(color);
        canvas.drawCircle((float)coordinateX, (float)coordinateY, radius, paint);
    }
}

