/*
 * Decompiled with CFR 0.152.
 */
package com.smarteist.autoimageslider.IndicatorView.draw.drawer.type;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import com.smarteist.autoimageslider.IndicatorView.animation.data.Value;
import com.smarteist.autoimageslider.IndicatorView.animation.data.type.DropAnimationValue;
import com.smarteist.autoimageslider.IndicatorView.draw.data.Indicator;
import com.smarteist.autoimageslider.IndicatorView.draw.data.Orientation;
import com.smarteist.autoimageslider.IndicatorView.draw.drawer.type.BaseDrawer;

public class DropDrawer
extends BaseDrawer {
    public DropDrawer(@NonNull Paint paint, @NonNull Indicator indicator) {
        super(paint, indicator);
    }

    public void draw(@NonNull Canvas canvas, @NonNull Value value, int coordinateX, int coordinateY) {
        if (!(value instanceof DropAnimationValue)) {
            return;
        }
        DropAnimationValue v = (DropAnimationValue)value;
        int unselectedColor = this.indicator.getUnselectedColor();
        int selectedColor = this.indicator.getSelectedColor();
        float radius = this.indicator.getRadius();
        this.paint.setColor(unselectedColor);
        canvas.drawCircle((float)coordinateX, (float)coordinateY, radius, this.paint);
        this.paint.setColor(selectedColor);
        if (this.indicator.getOrientation() == Orientation.HORIZONTAL) {
            canvas.drawCircle((float)v.getWidth(), (float)v.getHeight(), (float)v.getRadius(), this.paint);
        } else {
            canvas.drawCircle((float)v.getHeight(), (float)v.getWidth(), (float)v.getRadius(), this.paint);
        }
    }
}

