/*
 * Decompiled with CFR 0.152.
 */
package com.smarteist.autoimageslider;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.v4.view.PagerAdapter;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import com.smarteist.autoimageslider.IndicatorAnimations;
import com.smarteist.autoimageslider.IndicatorView.PageIndicatorView;
import com.smarteist.autoimageslider.IndicatorView.animation.type.AnimationType;
import com.smarteist.autoimageslider.IndicatorView.draw.controller.AttributeController;
import com.smarteist.autoimageslider.IndicatorView.draw.controller.DrawController;
import com.smarteist.autoimageslider.IndicatorView.draw.data.Orientation;
import com.smarteist.autoimageslider.IndicatorView.draw.data.RtlMode;
import com.smarteist.autoimageslider.IndicatorView.utils.DensityUtils;
import com.smarteist.autoimageslider.InfiniteAdapter.InfinitePagerAdapter;
import com.smarteist.autoimageslider.R;
import com.smarteist.autoimageslider.SliderAnimations;
import com.smarteist.autoimageslider.SliderPager;
import com.smarteist.autoimageslider.SliderViewAdapter;
import com.smarteist.autoimageslider.Transformations.AntiClockSpinTransformation;
import com.smarteist.autoimageslider.Transformations.Clock_SpinTransformation;
import com.smarteist.autoimageslider.Transformations.CubeInDepthTransformation;
import com.smarteist.autoimageslider.Transformations.CubeInRotationTransformation;
import com.smarteist.autoimageslider.Transformations.CubeInScalingTransformation;
import com.smarteist.autoimageslider.Transformations.CubeOutDepthTransformation;
import com.smarteist.autoimageslider.Transformations.CubeOutRotationTransformation;
import com.smarteist.autoimageslider.Transformations.CubeOutScalingTransformation;
import com.smarteist.autoimageslider.Transformations.DepthTransformation;
import com.smarteist.autoimageslider.Transformations.FadeTransformation;
import com.smarteist.autoimageslider.Transformations.FanTransformation;
import com.smarteist.autoimageslider.Transformations.FidgetSpinTransformation;
import com.smarteist.autoimageslider.Transformations.GateTransformation;
import com.smarteist.autoimageslider.Transformations.HingeTransformation;
import com.smarteist.autoimageslider.Transformations.HorizontalFlipTransformation;
import com.smarteist.autoimageslider.Transformations.PopTransformation;
import com.smarteist.autoimageslider.Transformations.SimpleTransformation;
import com.smarteist.autoimageslider.Transformations.SpinnerTransformation;
import com.smarteist.autoimageslider.Transformations.TossTransformation;
import com.smarteist.autoimageslider.Transformations.VerticalFlipTransformation;
import com.smarteist.autoimageslider.Transformations.VerticalShutTransformation;
import com.smarteist.autoimageslider.Transformations.ZoomOutTransformation;

public class SliderView
extends FrameLayout
implements Runnable,
View.OnTouchListener,
SliderViewAdapter.DataSetListener,
SliderPager.OnPageChangeListener {
    public static final int AUTO_CYCLE_DIRECTION_RIGHT = 0;
    public static final int AUTO_CYCLE_DIRECTION_LEFT = 1;
    public static final int AUTO_CYCLE_DIRECTION_BACK_AND_FORTH = 2;
    public static final String TAG = "Slider View : ";
    private final Handler mHandler = new Handler();
    private boolean mFlagBackAndForth;
    private boolean mIsAutoCycle;
    private int mAutoCycleDirection;
    private int mScrollTimeInMillis;
    private PageIndicatorView mPagerIndicator;
    private SliderViewAdapter mPagerAdapter;
    private SliderPager mSliderPager;
    private InfinitePagerAdapter mInfinitePagerAdapter;
    private boolean mPausedSliding = false;
    private OnSliderPageListener mPageListener;
    private boolean mIsInfiniteAdapter = true;

    public SliderView(Context context) {
        super(context);
        this.setupSlideView(context);
    }

    public SliderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setupSlideView(context);
        this.setUpAttributes(context, attrs);
    }

    public SliderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setupSlideView(context);
        this.setUpAttributes(context, attrs);
    }

    private void setUpAttributes(@NonNull Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SliderView, 0, 0);
        int indicatorOrientation = typedArray.getInt(R.styleable.SliderView_sliderIndicatorOrientation, Orientation.HORIZONTAL.ordinal());
        Orientation orientation = indicatorOrientation == 0 ? Orientation.HORIZONTAL : Orientation.VERTICAL;
        int indicatorRadius = (int)typedArray.getDimension(R.styleable.SliderView_sliderIndicatorRadius, (float)DensityUtils.dpToPx(2));
        int indicatorPadding = (int)typedArray.getDimension(R.styleable.SliderView_sliderIndicatorPadding, (float)DensityUtils.dpToPx(3));
        int indicatorMargin = (int)typedArray.getDimension(R.styleable.SliderView_sliderIndicatorMargin, (float)DensityUtils.dpToPx(12));
        int indicatorMarginLeft = (int)typedArray.getDimension(R.styleable.SliderView_sliderIndicatorMarginLeft, (float)DensityUtils.dpToPx(12));
        int indicatorMarginTop = (int)typedArray.getDimension(R.styleable.SliderView_sliderIndicatorMarginTop, (float)DensityUtils.dpToPx(12));
        int indicatorMarginRight = (int)typedArray.getDimension(R.styleable.SliderView_sliderIndicatorMarginRight, (float)DensityUtils.dpToPx(12));
        int indicatorMarginBottom = (int)typedArray.getDimension(R.styleable.SliderView_sliderIndicatorMarginBottom, (float)DensityUtils.dpToPx(12));
        int indicatorGravity = typedArray.getInt(R.styleable.SliderView_sliderIndicatorGravity, 81);
        int indicatorUnselectedColor = typedArray.getColor(R.styleable.SliderView_sliderIndicatorUnselectedColor, Color.parseColor((String)"#33ffffff"));
        int indicatorSelectedColor = typedArray.getColor(R.styleable.SliderView_sliderIndicatorSelectedColor, Color.parseColor((String)"#ffffff"));
        int indicatorAnimationDuration = typedArray.getInt(R.styleable.SliderView_sliderIndicatorAnimationDuration, 350);
        int indicatorRtlMode = typedArray.getInt(R.styleable.SliderView_sliderIndicatorRtlMode, RtlMode.Off.ordinal());
        RtlMode rtlMode = AttributeController.getRtlMode(indicatorRtlMode);
        int sliderAnimationDuration = typedArray.getInt(R.styleable.SliderView_sliderAnimationDuration, 250);
        int sliderScrollTimeInSec = typedArray.getInt(R.styleable.SliderView_sliderScrollTimeInSec, 2);
        boolean sliderAutoCycleEnabled = typedArray.getBoolean(R.styleable.SliderView_sliderAutoCycleEnabled, true);
        boolean sliderStartAutoCycle = typedArray.getBoolean(R.styleable.SliderView_sliderStartAutoCycle, false);
        int sliderAutoCycleDirection = typedArray.getInt(R.styleable.SliderView_sliderAutoCycleDirection, 0);
        this.setIndicatorOrientation(orientation);
        this.setIndicatorRadius(indicatorRadius);
        this.setIndicatorPadding(indicatorPadding);
        this.setIndicatorMargin(indicatorMargin);
        this.setIndicatorMarginCustom(indicatorMarginLeft, indicatorMarginTop, indicatorMarginRight, indicatorMarginBottom);
        this.setIndicatorGravity(indicatorGravity);
        this.setIndicatorMargins(indicatorMarginLeft, indicatorMarginTop, indicatorMarginRight, indicatorMarginBottom);
        this.setIndicatorUnselectedColor(indicatorUnselectedColor);
        this.setIndicatorSelectedColor(indicatorSelectedColor);
        this.setIndicatorAnimationDuration(indicatorAnimationDuration);
        this.setIndicatorRtlMode(rtlMode);
        this.setSliderAnimationDuration(sliderAnimationDuration);
        this.setScrollTimeInSec(sliderScrollTimeInSec);
        this.setAutoCycle(sliderAutoCycleEnabled);
        this.setAutoCycleDirection(sliderAutoCycleDirection);
        this.setAutoCycle(sliderStartAutoCycle);
        typedArray.recycle();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void setupSlideView(Context context) {
        View wrapperView = LayoutInflater.from((Context)context).inflate(R.layout.slider_view, (ViewGroup)this, true);
        this.mSliderPager = (SliderPager)wrapperView.findViewById(R.id.vp_slider_layout);
        this.mSliderPager.setOnTouchListener(this);
        this.mSliderPager.addOnPageChangeListener(this);
        this.mPagerIndicator = (PageIndicatorView)wrapperView.findViewById(R.id.pager_indicator);
        this.mPagerIndicator.setViewPager(this.mSliderPager);
    }

    public void setOnIndicatorClickListener(DrawController.ClickListener listener) {
        this.mPagerIndicator.setClickListener(listener);
    }

    public void setCurrentPageListener(OnSliderPageListener listener) {
        this.mPageListener = listener;
    }

    public void setSliderAdapter(@NonNull SliderViewAdapter pagerAdapter) {
        this.mPagerAdapter = pagerAdapter;
        this.mInfinitePagerAdapter = new InfinitePagerAdapter(pagerAdapter);
        this.mSliderPager.setAdapter(this.mInfinitePagerAdapter);
        this.mPagerAdapter.dataSetChangedListener(this);
        this.mPagerIndicator.setCount(this.getAdapterItemsCount());
        this.mPagerIndicator.setDynamicCount(true);
        this.setCurrentPagePosition(0);
    }

    public void setSliderAdapter(@NonNull SliderViewAdapter pagerAdapter, boolean infiniteAdapter) {
        this.mIsInfiniteAdapter = infiniteAdapter;
        if (!infiniteAdapter) {
            this.mPagerAdapter = pagerAdapter;
            this.mSliderPager.setAdapter(pagerAdapter);
            this.mPagerIndicator.setCount(this.getAdapterItemsCount());
            this.mPagerIndicator.setDynamicCount(true);
        } else {
            this.setSliderAdapter(pagerAdapter);
        }
    }

    public SliderPager getSliderPager() {
        return this.mSliderPager;
    }

    public PagerAdapter getSliderAdapter() {
        return this.mPagerAdapter;
    }

    public boolean isAutoCycle() {
        return this.mIsAutoCycle;
    }

    public void setAutoCycle(boolean autoCycle) {
        this.mIsAutoCycle = autoCycle;
    }

    public void setOffscreenPageLimit(int limit) {
        this.mSliderPager.setOffscreenPageLimit(limit);
    }

    public int getScrollTimeInSec() {
        return this.mScrollTimeInMillis / 1000;
    }

    public void setScrollTimeInSec(int time) {
        this.mScrollTimeInMillis = time * 1000;
    }

    public int getScrollTimeInMillis() {
        return this.mScrollTimeInMillis;
    }

    public void setScrollTimeInMillis(int millis) {
        this.mScrollTimeInMillis = millis;
    }

    public void setSliderTransformAnimation(SliderAnimations animation) {
        switch (animation) {
            case ANTICLOCKSPINTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new AntiClockSpinTransformation());
                break;
            }
            case CLOCK_SPINTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new Clock_SpinTransformation());
                break;
            }
            case CUBEINDEPTHTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new CubeInDepthTransformation());
                break;
            }
            case CUBEINROTATIONTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new CubeInRotationTransformation());
                break;
            }
            case CUBEINSCALINGTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new CubeInScalingTransformation());
                break;
            }
            case CUBEOUTDEPTHTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new CubeOutDepthTransformation());
                break;
            }
            case CUBEOUTROTATIONTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new CubeOutRotationTransformation());
                break;
            }
            case CUBEOUTSCALINGTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new CubeOutScalingTransformation());
                break;
            }
            case DEPTHTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new DepthTransformation());
                break;
            }
            case FADETRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new FadeTransformation());
                break;
            }
            case FANTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new FanTransformation());
                break;
            }
            case FIDGETSPINTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new FidgetSpinTransformation());
                break;
            }
            case GATETRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new GateTransformation());
                break;
            }
            case HINGETRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new HingeTransformation());
                break;
            }
            case HORIZONTALFLIPTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new HorizontalFlipTransformation());
                break;
            }
            case POPTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new PopTransformation());
                break;
            }
            case SPINNERTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new SpinnerTransformation());
                break;
            }
            case TOSSTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new TossTransformation());
                break;
            }
            case VERTICALFLIPTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new VerticalFlipTransformation());
                break;
            }
            case VERTICALSHUTTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new VerticalShutTransformation());
                break;
            }
            case ZOOMOUTTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new ZoomOutTransformation());
                break;
            }
            default: {
                this.mSliderPager.setPageTransformer(false, new SimpleTransformation());
            }
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (event.getAction() == 2) {
            this.mPausedSliding = true;
        } else if (event.getAction() == 1) {
            this.mPausedSliding = false;
        }
        return false;
    }

    public void setCustomSliderTransformAnimation(SliderPager.PageTransformer animation) {
        this.mSliderPager.setPageTransformer(false, animation);
    }

    public void setSliderAnimationDuration(int duration) {
        this.mSliderPager.setScrollDuration(duration);
    }

    public void setSliderAnimationDuration(int duration, Interpolator interpolator) {
        this.mSliderPager.setScrollDuration(duration, interpolator);
    }

    public void setCurrentPagePosition(int position) {
        if (this.getSliderAdapter() != null) {
            if (this.mIsInfiniteAdapter) {
                int midpoint = (this.getAdapterItemsCount() - 1) * 16200;
                this.mSliderPager.setCurrentItem(midpoint + position, true);
            } else {
                this.mSliderPager.setCurrentItem(position, true);
            }
        } else {
            throw new NullPointerException("Adapter not set");
        }
    }

    public int getCurrentPagePosition() {
        if (this.getSliderAdapter() != null) {
            if (this.mIsInfiniteAdapter) {
                return this.getSliderPager().getCurrentItem() % this.mPagerAdapter.getCount();
            }
            return this.getSliderPager().getCurrentItem();
        }
        throw new NullPointerException("Adapter not set");
    }

    public void setIndicatorAnimationDuration(long duration) {
        this.mPagerIndicator.setAnimationDuration(duration);
    }

    public void setIndicatorGravity(int gravity) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mPagerIndicator.getLayoutParams();
        layoutParams.gravity = gravity;
        this.mPagerIndicator.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setIndicatorPadding(int padding) {
        this.mPagerIndicator.setPadding(padding);
    }

    public void setIndicatorMargins(int left, int top, int right, int bottom) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mPagerIndicator.getLayoutParams();
        layoutParams.setMargins(left, top, right, bottom);
        this.mPagerIndicator.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setIndicatorOrientation(Orientation orientation) {
        this.mPagerIndicator.setOrientation(orientation);
    }

    public void setIndicatorAnimation(IndicatorAnimations animations) {
        switch (animations) {
            case DROP: {
                this.mPagerIndicator.setAnimationType(AnimationType.DROP);
                break;
            }
            case FILL: {
                this.mPagerIndicator.setAnimationType(AnimationType.FILL);
                break;
            }
            case NONE: {
                this.mPagerIndicator.setAnimationType(AnimationType.NONE);
                break;
            }
            case SWAP: {
                this.mPagerIndicator.setAnimationType(AnimationType.SWAP);
                break;
            }
            case WORM: {
                this.mPagerIndicator.setAnimationType(AnimationType.WORM);
                break;
            }
            case COLOR: {
                this.mPagerIndicator.setAnimationType(AnimationType.COLOR);
                break;
            }
            case SCALE: {
                this.mPagerIndicator.setAnimationType(AnimationType.SCALE);
                break;
            }
            case SLIDE: {
                this.mPagerIndicator.setAnimationType(AnimationType.SLIDE);
                break;
            }
            case SCALE_DOWN: {
                this.mPagerIndicator.setAnimationType(AnimationType.SCALE_DOWN);
                break;
            }
            case THIN_WORM: {
                this.mPagerIndicator.setAnimationType(AnimationType.THIN_WORM);
            }
        }
    }

    public void setIndicatorVisibility(boolean visibility) {
        if (visibility) {
            this.mPagerIndicator.setVisibility(0);
        } else {
            this.mPagerIndicator.setVisibility(8);
        }
    }

    private int getAdapterItemsCount() {
        try {
            return this.getSliderAdapter().getCount();
        }
        catch (NullPointerException e) {
            Log.e((String)TAG, (String)"getAdapterItemsCount: Slider Adapter is null so, it can't get count of items");
            return 0;
        }
    }

    public void startAutoCycle() {
        this.mHandler.removeCallbacks((Runnable)this);
        this.mHandler.postDelayed((Runnable)this, (long)this.mScrollTimeInMillis);
    }

    public void stopAutoCycle() {
        this.mHandler.removeCallbacks((Runnable)this);
    }

    public void setAutoCycleDirection(int direction) {
        this.mAutoCycleDirection = direction;
    }

    public int getAutoCycleDirection() {
        return this.mAutoCycleDirection;
    }

    public int getIndicatorRadius() {
        return this.mPagerIndicator.getRadius();
    }

    public void setIndicatorRtlMode(RtlMode rtlMode) {
        this.mPagerIndicator.setRtlMode(rtlMode);
    }

    public void setIndicatorRadius(int pagerIndicatorRadius) {
        this.mPagerIndicator.setRadius(pagerIndicatorRadius);
    }

    public void setIndicatorMargin(int margin) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mPagerIndicator.getLayoutParams();
        layoutParams.setMargins(margin, margin, margin, margin);
        this.mPagerIndicator.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setIndicatorMarginCustom(int left, int top, int right, int bottom) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mPagerIndicator.getLayoutParams();
        layoutParams.setMargins(left, top, right, bottom);
        this.mPagerIndicator.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setIndicatorSelectedColor(int color) {
        this.mPagerIndicator.setSelectedColor(color);
    }

    public int getIndicatorSelectedColor() {
        return this.mPagerIndicator.getSelectedColor();
    }

    public void setIndicatorUnselectedColor(int color) {
        this.mPagerIndicator.setUnselectedColor(color);
    }

    public int getIndicatorUnselectedColor() {
        return this.mPagerIndicator.getUnselectedColor();
    }

    @Override
    public void run() {
        try {
            if (!this.mPausedSliding) {
                this.slideToNextPosition();
            }
        }
        finally {
            if (this.mIsAutoCycle) {
                this.mHandler.postDelayed((Runnable)this, (long)this.mScrollTimeInMillis);
            }
        }
    }

    public void slideToNextPosition() {
        int currentPosition = this.mSliderPager.getCurrentItem();
        int adapterItemsCount = this.getAdapterItemsCount();
        if (this.mAutoCycleDirection == 2 && adapterItemsCount > 1) {
            if (currentPosition % (adapterItemsCount - 1) == 0) {
                boolean bl = this.mFlagBackAndForth = !this.mFlagBackAndForth;
            }
            if (this.mFlagBackAndForth) {
                this.mSliderPager.setCurrentItem(++currentPosition, true);
            } else {
                this.mSliderPager.setCurrentItem(--currentPosition, true);
            }
        } else if (this.mAutoCycleDirection == 1) {
            this.mSliderPager.setCurrentItem(--currentPosition, true);
        } else {
            this.mSliderPager.setCurrentItem(++currentPosition, true);
        }
    }

    public void slideToPreviousPosition() {
        int currentPosition = this.mSliderPager.getCurrentItem();
        int adapterItemsCount = this.getAdapterItemsCount();
        if (this.mAutoCycleDirection == 2 && adapterItemsCount > 1) {
            if (currentPosition % (adapterItemsCount - 1) == 0) {
                boolean bl = this.mFlagBackAndForth = !this.mFlagBackAndForth;
            }
            if (this.mFlagBackAndForth) {
                this.mSliderPager.setCurrentItem(--currentPosition, true);
            } else {
                this.mSliderPager.setCurrentItem(++currentPosition, true);
            }
        } else if (this.mAutoCycleDirection == 1) {
            this.mSliderPager.setCurrentItem(++currentPosition, true);
        } else {
            this.mSliderPager.setCurrentItem(--currentPosition, true);
        }
    }

    @Override
    public void dataSetChanged() {
        if (this.mIsInfiniteAdapter) {
            this.mInfinitePagerAdapter.notifyDataSetChanged();
            this.mSliderPager.setCurrentItem((this.getAdapterItemsCount() - 1) * 16200, false);
        }
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    @Override
    public void onPageSelected(int position) {
        if (this.mPageListener != null) {
            this.mPageListener.onSliderPageChanged(position);
        }
    }

    @Override
    public void onPageScrollStateChanged(int state) {
    }

    public static interface OnSliderPageListener {
        public void onSliderPageChanged(int var1);
    }
}

