/*
 * Decompiled with CFR 0.152.
 */
package com.smarteist.autoimageslider;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import java.util.LinkedList;
import java.util.Queue;

public abstract class SliderViewAdapter<VH extends ViewHolder>
extends PagerAdapter {
    private DataSetListener dataSetListener;
    private Queue<VH> destroyedItems = new LinkedList<VH>();

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        ViewHolder viewHolder = (ViewHolder)this.destroyedItems.poll();
        if (viewHolder != null) {
            container.addView(viewHolder.itemView);
            this.onBindViewHolder(viewHolder, position);
        } else {
            viewHolder = this.onCreateViewHolder(container);
            container.addView(viewHolder.itemView);
            this.onBindViewHolder(viewHolder, position);
        }
        return viewHolder;
    }

    public final void destroyItem(ViewGroup container, int position, @NonNull Object object) {
        container.removeView(((ViewHolder)object).itemView);
        this.destroyedItems.add((ViewHolder)object);
    }

    public final boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return ((ViewHolder)object).itemView == view;
    }

    public int getItemPosition(Object object) {
        return -2;
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        if (this.dataSetListener != null) {
            this.dataSetListener.dataSetChanged();
        }
    }

    public abstract VH onCreateViewHolder(ViewGroup var1);

    public abstract void onBindViewHolder(VH var1, int var2);

    void dataSetChangedListener(DataSetListener dataSetListener) {
        this.dataSetListener = dataSetListener;
    }

    static interface DataSetListener {
        public void dataSetChanged();
    }

    public static abstract class ViewHolder {
        public final View itemView;

        public ViewHolder(View itemView) {
            this.itemView = itemView;
        }
    }
}

