/*
 * Decompiled with CFR 0.152.
 */
package com.smarteist.autoimageslider;

import android.content.Context;
import android.util.AttributeSet;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import androidx.viewpager.widget.ViewPager;
import java.lang.reflect.Field;

public class SliderPager
extends ViewPager {
    public static final int DEFAULT_SCROLL_DURATION = 200;

    public SliderPager(Context context) {
        super(context);
    }

    public SliderPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setScrollDuration(int millis, Interpolator interpolator) {
        try {
            Class<ViewPager> viewpager = ViewPager.class;
            Field scroller = viewpager.getDeclaredField("mScroller");
            scroller.setAccessible(true);
            if (interpolator != null) {
                OwnScroller ownScroller = new OwnScroller(this.getContext(), millis, interpolator);
                scroller.set((Object)this, (Object)ownScroller);
            } else {
                OwnScroller ownScroller = new OwnScroller(this.getContext(), millis);
                scroller.set((Object)this, (Object)ownScroller);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setScrollDuration(int millis) {
        this.setScrollDuration(millis, null);
    }

    class OwnScroller
    extends Scroller {
        private int durationScrollMillis;

        OwnScroller(Context context, int durationScroll) {
            super(context, (Interpolator)new DecelerateInterpolator());
            this.durationScrollMillis = durationScroll;
        }

        OwnScroller(Context context, int durationScroll, Interpolator interpolator) {
            super(context, interpolator);
            this.durationScrollMillis = durationScroll;
        }

        public void startScroll(int startX, int startY, int dx, int dy, int duration) {
            super.startScroll(startX, startY, dx, dy, this.durationScrollMillis);
        }
    }
}

