/*
 * Decompiled with CFR 0.152.
 */
package com.smarteist.autoimageslider.IndicatorView.animation.type;

import android.animation.Animator;
import android.animation.ValueAnimator;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.smarteist.autoimageslider.IndicatorView.animation.controller.ValueController;

public abstract class BaseAnimation<T extends Animator> {
    public static final int DEFAULT_ANIMATION_TIME = 350;
    protected long animationDuration = 350L;
    protected ValueController.UpdateListener listener;
    protected T animator;

    public BaseAnimation(@Nullable ValueController.UpdateListener listener) {
        this.listener = listener;
        this.animator = this.createAnimator();
    }

    @NonNull
    public abstract T createAnimator();

    public abstract BaseAnimation progress(float var1);

    public BaseAnimation duration(long duration) {
        this.animationDuration = duration;
        if (this.animator instanceof ValueAnimator) {
            this.animator.setDuration(this.animationDuration);
        }
        return this;
    }

    public void start() {
        if (this.animator != null && !this.animator.isRunning()) {
            this.animator.start();
        }
    }

    public void end() {
        if (this.animator != null && this.animator.isStarted()) {
            this.animator.end();
        }
    }
}

