/*
 * Decompiled with CFR 0.152.
 */
package com.smarteist.autoimageslider.IndicatorView.draw.drawer.type;

import android.graphics.Canvas;
import android.graphics.Paint;
import androidx.annotation.NonNull;
import com.smarteist.autoimageslider.IndicatorView.animation.data.Value;
import com.smarteist.autoimageslider.IndicatorView.animation.data.type.ScaleAnimationValue;
import com.smarteist.autoimageslider.IndicatorView.draw.data.Indicator;
import com.smarteist.autoimageslider.IndicatorView.draw.drawer.type.BaseDrawer;

public class ScaleDownDrawer
extends BaseDrawer {
    public ScaleDownDrawer(@NonNull Paint paint, @NonNull Indicator indicator) {
        super(paint, indicator);
    }

    public void draw(@NonNull Canvas canvas, @NonNull Value value, int position, int coordinateX, int coordinateY) {
        if (!(value instanceof ScaleAnimationValue)) {
            return;
        }
        ScaleAnimationValue v = (ScaleAnimationValue)value;
        float radius = this.indicator.getRadius();
        int color = this.indicator.getSelectedColor();
        int selectedPosition = this.indicator.getSelectedPosition();
        int selectingPosition = this.indicator.getSelectingPosition();
        int lastSelectedPosition = this.indicator.getLastSelectedPosition();
        if (this.indicator.isInteractiveAnimation()) {
            if (position == selectingPosition) {
                radius = v.getRadius();
                color = v.getColor();
            } else if (position == selectedPosition) {
                radius = v.getRadiusReverse();
                color = v.getColorReverse();
            }
        } else if (position == selectedPosition) {
            radius = v.getRadius();
            color = v.getColor();
        } else if (position == lastSelectedPosition) {
            radius = v.getRadiusReverse();
            color = v.getColorReverse();
        }
        this.paint.setColor(color);
        canvas.drawCircle((float)coordinateX, (float)coordinateY, radius, this.paint);
    }
}

