/*
 * Decompiled with CFR 0.152.
 */
package com.smarteist.autoimageslider.IndicatorView.draw.controller;

import android.graphics.Canvas;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.smarteist.autoimageslider.IndicatorView.animation.data.Value;
import com.smarteist.autoimageslider.IndicatorView.animation.type.AnimationType;
import com.smarteist.autoimageslider.IndicatorView.draw.data.Indicator;
import com.smarteist.autoimageslider.IndicatorView.draw.drawer.Drawer;
import com.smarteist.autoimageslider.IndicatorView.utils.CoordinatesUtils;

public class DrawController {
    private Value value;
    private Drawer drawer;
    private Indicator indicator;
    private ClickListener listener;

    public DrawController(@NonNull Indicator indicator) {
        this.indicator = indicator;
        this.drawer = new Drawer(indicator);
    }

    public void updateValue(@Nullable Value value) {
        this.value = value;
    }

    public void setClickListener(@Nullable ClickListener listener) {
        this.listener = listener;
    }

    public void touch(@Nullable MotionEvent event) {
        if (event == null) {
            return;
        }
        switch (event.getAction()) {
            case 1: {
                this.onIndicatorTouched(event.getX(), event.getY());
                break;
            }
        }
    }

    private void onIndicatorTouched(float x, float y) {
        int position;
        if (this.listener != null && (position = CoordinatesUtils.getPosition(this.indicator, x, y)) >= 0) {
            this.listener.onIndicatorClicked(position);
        }
    }

    public void draw(@NonNull Canvas canvas) {
        int count = this.indicator.getCount();
        for (int position = 0; position < count; ++position) {
            int coordinateX = CoordinatesUtils.getXCoordinate(this.indicator, position);
            int coordinateY = CoordinatesUtils.getYCoordinate(this.indicator, position);
            this.drawIndicator(canvas, position, coordinateX, coordinateY);
        }
    }

    private void drawIndicator(@NonNull Canvas canvas, int position, int coordinateX, int coordinateY) {
        boolean interactiveAnimation = this.indicator.isInteractiveAnimation();
        int selectedPosition = this.indicator.getSelectedPosition();
        int selectingPosition = this.indicator.getSelectingPosition();
        int lastSelectedPosition = this.indicator.getLastSelectedPosition();
        boolean selectedItem = !interactiveAnimation && (position == selectedPosition || position == lastSelectedPosition);
        boolean selectingItem = interactiveAnimation && (position == selectedPosition || position == selectingPosition);
        boolean isSelectedItem = selectedItem | selectingItem;
        this.drawer.setup(position, coordinateX, coordinateY);
        if (this.value != null && isSelectedItem) {
            this.drawWithAnimation(canvas);
        } else {
            this.drawer.drawBasic(canvas, isSelectedItem);
        }
    }

    private void drawWithAnimation(@NonNull Canvas canvas) {
        AnimationType animationType = this.indicator.getAnimationType();
        switch (animationType) {
            case NONE: {
                this.drawer.drawBasic(canvas, true);
                break;
            }
            case COLOR: {
                this.drawer.drawColor(canvas, this.value);
                break;
            }
            case SCALE: {
                this.drawer.drawScale(canvas, this.value);
                break;
            }
            case WORM: {
                this.drawer.drawWorm(canvas, this.value);
                break;
            }
            case SLIDE: {
                this.drawer.drawSlide(canvas, this.value);
                break;
            }
            case FILL: {
                this.drawer.drawFill(canvas, this.value);
                break;
            }
            case THIN_WORM: {
                this.drawer.drawThinWorm(canvas, this.value);
                break;
            }
            case DROP: {
                this.drawer.drawDrop(canvas, this.value);
                break;
            }
            case SWAP: {
                this.drawer.drawSwap(canvas, this.value);
                break;
            }
            case SCALE_DOWN: {
                this.drawer.drawScaleDown(canvas, this.value);
            }
        }
    }

    public static interface ClickListener {
        public void onIndicatorClicked(int var1);
    }
}

