/*
 * Decompiled with CFR 0.152.
 */
package com.smarteist.autoimageslider;

import android.content.Context;
import android.os.Handler;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.smarteist.autoimageslider.CircularSliderHandle;
import com.smarteist.autoimageslider.IndicatorAnimations;
import com.smarteist.autoimageslider.IndicatorView.PageIndicatorView;
import com.smarteist.autoimageslider.IndicatorView.animation.type.AnimationType;
import com.smarteist.autoimageslider.R;
import com.smarteist.autoimageslider.SliderAdapter;
import com.smarteist.autoimageslider.SliderAnimations;
import com.smarteist.autoimageslider.SliderView;
import com.smarteist.autoimageslider.Transformations.AntiClockSpinTransformation;
import com.smarteist.autoimageslider.Transformations.Clock_SpinTransformation;
import com.smarteist.autoimageslider.Transformations.CubeInDepthTransformation;
import com.smarteist.autoimageslider.Transformations.CubeInRotationTransformation;
import com.smarteist.autoimageslider.Transformations.CubeInScalingTransformation;
import com.smarteist.autoimageslider.Transformations.CubeOutDepthTransformation;
import com.smarteist.autoimageslider.Transformations.CubeOutRotationTransformation;
import com.smarteist.autoimageslider.Transformations.CubeOutScalingTransformation;
import com.smarteist.autoimageslider.Transformations.DepthTransformation;
import com.smarteist.autoimageslider.Transformations.FadeTransformation;
import com.smarteist.autoimageslider.Transformations.FanTransformation;
import com.smarteist.autoimageslider.Transformations.FidgetSpinTransformation;
import com.smarteist.autoimageslider.Transformations.GateTransformation;
import com.smarteist.autoimageslider.Transformations.HingeTransformation;
import com.smarteist.autoimageslider.Transformations.HorizontalFlipTransformation;
import com.smarteist.autoimageslider.Transformations.PopTransformation;
import com.smarteist.autoimageslider.Transformations.SimpleTransformation;
import com.smarteist.autoimageslider.Transformations.SpinnerTransformation;
import com.smarteist.autoimageslider.Transformations.TossTransformation;
import com.smarteist.autoimageslider.Transformations.VerticalFlipTransformation;
import com.smarteist.autoimageslider.Transformations.VerticalShutTransformation;
import com.smarteist.autoimageslider.Transformations.ZoomOutTransformation;
import java.util.Timer;
import java.util.TimerTask;

public class SliderLayout
extends FrameLayout
implements CircularSliderHandle.CurrentPageListener {
    private static final long DELAY_MS = 500L;
    private static PagerAdapter mFlippingPagerAdapter;
    private int currentPage = 0;
    private CircularSliderHandle circularSliderHandle;
    private ViewPager mSliderPager;
    private PageIndicatorView pagerIndicator;
    private int scrollTimeInSec = 2;
    private Handler handler = new Handler();
    private Timer flippingTimer;
    private boolean autoScrolling = true;

    public SliderLayout(Context context) {
        super(context);
        this.setLayout(context);
    }

    public SliderLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setLayout(context);
    }

    public SliderLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setLayout(context);
    }

    public boolean isAutoScrolling() {
        return this.autoScrolling;
    }

    public void setAutoScrolling(boolean autoScrolling) {
        this.autoScrolling = autoScrolling;
        this.startAutoCycle();
    }

    private static PagerAdapter getFlippingPagerAdapter() {
        return mFlippingPagerAdapter;
    }

    public int getScrollTimeInSec() {
        return this.scrollTimeInSec;
    }

    public void setScrollTimeInSec(int time) {
        this.scrollTimeInSec = time;
        this.startAutoCycle();
    }

    public void setSliderTransformAnimation(SliderAnimations animation) {
        switch (animation) {
            case ANTICLOCKSPINTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, (ViewPager.PageTransformer)new AntiClockSpinTransformation());
                break;
            }
            case CLOCK_SPINTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, (ViewPager.PageTransformer)new Clock_SpinTransformation());
                break;
            }
            case CUBEINDEPTHTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, (ViewPager.PageTransformer)new CubeInDepthTransformation());
                break;
            }
            case CUBEINROTATIONTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, (ViewPager.PageTransformer)new CubeInRotationTransformation());
                break;
            }
            case CUBEINSCALINGTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, (ViewPager.PageTransformer)new CubeInScalingTransformation());
                break;
            }
            case CUBEOUTDEPTHTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, (ViewPager.PageTransformer)new CubeOutDepthTransformation());
                break;
            }
            case CUBEOUTROTATIONTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, (ViewPager.PageTransformer)new CubeOutRotationTransformation());
                break;
            }
            case CUBEOUTSCALINGTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, (ViewPager.PageTransformer)new CubeOutScalingTransformation());
                break;
            }
            case DEPTHTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, (ViewPager.PageTransformer)new DepthTransformation());
                break;
            }
            case FADETRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, (ViewPager.PageTransformer)new FadeTransformation());
                break;
            }
            case FANTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, (ViewPager.PageTransformer)new FanTransformation());
                break;
            }
            case FIDGETSPINTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, (ViewPager.PageTransformer)new FidgetSpinTransformation());
                break;
            }
            case GATETRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, (ViewPager.PageTransformer)new GateTransformation());
                break;
            }
            case HINGETRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, (ViewPager.PageTransformer)new HingeTransformation());
                break;
            }
            case HORIZONTALFLIPTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, (ViewPager.PageTransformer)new HorizontalFlipTransformation());
                break;
            }
            case POPTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, (ViewPager.PageTransformer)new PopTransformation());
                break;
            }
            case SIMPLETRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, (ViewPager.PageTransformer)new SimpleTransformation());
                break;
            }
            case SPINNERTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, (ViewPager.PageTransformer)new SpinnerTransformation());
                break;
            }
            case TOSSTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, (ViewPager.PageTransformer)new TossTransformation());
                break;
            }
            case VERTICALFLIPTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, (ViewPager.PageTransformer)new VerticalFlipTransformation());
                break;
            }
            case VERTICALSHUTTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, (ViewPager.PageTransformer)new VerticalShutTransformation());
                break;
            }
            case ZOOMOUTTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, (ViewPager.PageTransformer)new ZoomOutTransformation());
                break;
            }
            default: {
                this.mSliderPager.setPageTransformer(false, (ViewPager.PageTransformer)new SimpleTransformation());
            }
        }
    }

    public void setCustomSliderTransformAnimation(ViewPager.PageTransformer animation) {
        this.mSliderPager.setPageTransformer(false, animation);
    }

    public int getCurrentPagePosition() {
        if (SliderLayout.getFlippingPagerAdapter() != null) {
            return this.mSliderPager.getCurrentItem() % mFlippingPagerAdapter.getCount();
        }
        throw new NullPointerException("Adapter not set");
    }

    public void setIndicatorAnimation(IndicatorAnimations animations) {
        switch (animations) {
            case DROP: {
                this.pagerIndicator.setAnimationType(AnimationType.DROP);
                break;
            }
            case FILL: {
                this.pagerIndicator.setAnimationType(AnimationType.FILL);
                break;
            }
            case NONE: {
                this.pagerIndicator.setAnimationType(AnimationType.NONE);
                break;
            }
            case SWAP: {
                this.pagerIndicator.setAnimationType(AnimationType.SWAP);
                break;
            }
            case WORM: {
                this.pagerIndicator.setAnimationType(AnimationType.WORM);
                break;
            }
            case COLOR: {
                this.pagerIndicator.setAnimationType(AnimationType.COLOR);
                break;
            }
            case SCALE: {
                this.pagerIndicator.setAnimationType(AnimationType.SCALE);
                break;
            }
            case SLIDE: {
                this.pagerIndicator.setAnimationType(AnimationType.SLIDE);
                break;
            }
            case SCALE_DOWN: {
                this.pagerIndicator.setAnimationType(AnimationType.SCALE_DOWN);
                break;
            }
            case THIN_WORM: {
                this.pagerIndicator.setAnimationType(AnimationType.THIN_WORM);
            }
        }
    }

    public void setPagerIndicatorVisibility(boolean visibility) {
        if (visibility) {
            this.pagerIndicator.setVisibility(0);
        } else {
            this.pagerIndicator.setVisibility(8);
        }
    }

    private void setLayout(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.slider_layout, (ViewGroup)this, true);
        this.mSliderPager = (ViewPager)view.findViewById(R.id.vp_slider_layout);
        this.pagerIndicator = (PageIndicatorView)view.findViewById(R.id.pager_indicator);
        this.pagerIndicator.setDynamicCount(true);
        mFlippingPagerAdapter = new SliderAdapter(context);
        this.mSliderPager.setAdapter(mFlippingPagerAdapter);
        this.circularSliderHandle = new CircularSliderHandle(this.mSliderPager);
        this.circularSliderHandle.setCurrentPageListener(this);
        this.mSliderPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.circularSliderHandle);
        this.startAutoCycle();
    }

    public void clearSliderViews() {
        ((SliderAdapter)mFlippingPagerAdapter).removeAllSliderViews();
    }

    public void addSliderView(SliderView sliderView) {
        ((SliderAdapter)mFlippingPagerAdapter).addSliderView(sliderView);
        if (this.pagerIndicator != null && this.mSliderPager != null) {
            this.pagerIndicator.setViewPager(this.mSliderPager);
        }
    }

    private void startAutoCycle() {
        if (this.flippingTimer != null) {
            this.flippingTimer.cancel();
            this.flippingTimer.purge();
        }
        if (!this.autoScrolling) {
            return;
        }
        final Runnable scrollingThread = new Runnable(){

            @Override
            public void run() {
                if (SliderLayout.this.currentPage == SliderLayout.getFlippingPagerAdapter().getCount()) {
                    SliderLayout.this.currentPage = 0;
                }
                SliderLayout.this.mSliderPager.setCurrentItem(SliderLayout.this.currentPage++, true);
            }
        };
        this.flippingTimer = new Timer();
        this.flippingTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                SliderLayout.this.handler.post(scrollingThread);
            }
        }, 500L, (long)(this.scrollTimeInSec * 1000));
    }

    @Override
    public void onCurrentPageChanged(int currentPosition) {
        this.currentPage = currentPosition;
    }
}

