/*
 * Decompiled with CFR 0.152.
 */
package com.smarteist.autoimageslider;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.smarteist.autoimageslider.R;
import com.smarteist.autoimageslider.SliderView;

public class DefaultSliderView
extends SliderView {
    private String description;
    private int descriptionTextColor = -1;
    private float descriptionTextSize = 1.0f;

    @Override
    public View getView() {
        View v = LayoutInflater.from((Context)this.context).inflate(R.layout.image_slider_layout_item, null, true);
        ImageView autoSliderImage = (ImageView)v.findViewById(R.id.iv_auto_image_slider);
        TextView tv_description = (TextView)v.findViewById(R.id.tv_auto_image_slider);
        tv_description.getBackground();
        if (this.descriptionTextSize != 1.0f) {
            tv_description.setTextSize(this.descriptionTextSize);
        }
        tv_description.setTextColor(this.descriptionTextColor);
        tv_description.setText((CharSequence)this.getDescription());
        this.bindViewData(v, autoSliderImage);
        return v;
    }

    @Override
    void bindViewData(View v, ImageView autoSliderImage) {
        final DefaultSliderView con = this;
        v.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (DefaultSliderView.this.onSliderClickListener != null) {
                    DefaultSliderView.this.onSliderClickListener.onSliderClick(con);
                }
            }
        });
        try {
            autoSliderImage.setScaleType(this.getScaleType());
            if (this.imageUrl != null) {
                Glide.with((Context)this.context).asDrawable().load(this.imageUrl).into(autoSliderImage);
            }
            if (this.imageRes != 0) {
                Glide.with((Context)this.context).asDrawable().load(Integer.valueOf(this.imageRes)).into(autoSliderImage);
            }
        }
        catch (Exception exception) {
            Log.d((String)"Exception", (String)exception.getMessage());
        }
    }

    public DefaultSliderView(Context context) {
        super(context);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public void setDescriptionTextColor(int descriptionTextColor) {
        this.descriptionTextColor = descriptionTextColor;
    }

    public void setDescriptionTextSize(float descriptionTextSize) {
        this.descriptionTextSize = descriptionTextSize;
    }
}

