/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.util;

import android.support.annotation.NonNull;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MarkEnforcingInputStream
extends FilterInputStream {
    private static final int UNSET = Integer.MIN_VALUE;
    private static final int END_OF_STREAM = -1;
    private int availableBytes = Integer.MIN_VALUE;

    public MarkEnforcingInputStream(@NonNull InputStream in) {
        super(in);
    }

    @Override
    public synchronized void mark(int readLimit) {
        super.mark(readLimit);
        this.availableBytes = readLimit;
    }

    @Override
    public int read() throws IOException {
        if (this.getBytesToRead(1L) == -1L) {
            return -1;
        }
        int result = super.read();
        this.updateAvailableBytesAfterRead(1L);
        return result;
    }

    @Override
    public int read(@NonNull byte[] buffer, int byteOffset, int byteCount) throws IOException {
        int toRead = (int)this.getBytesToRead(byteCount);
        if (toRead == -1) {
            return -1;
        }
        int read = super.read(buffer, byteOffset, toRead);
        this.updateAvailableBytesAfterRead(read);
        return read;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.availableBytes = Integer.MIN_VALUE;
    }

    @Override
    public long skip(long byteCount) throws IOException {
        long toSkip = this.getBytesToRead(byteCount);
        if (toSkip == -1L) {
            return 0L;
        }
        long read = super.skip(toSkip);
        this.updateAvailableBytesAfterRead(read);
        return read;
    }

    @Override
    public int available() throws IOException {
        return this.availableBytes == Integer.MIN_VALUE ? super.available() : Math.min(this.availableBytes, super.available());
    }

    private long getBytesToRead(long targetByteCount) {
        if (this.availableBytes == 0) {
            return -1L;
        }
        if (this.availableBytes != Integer.MIN_VALUE && targetByteCount > (long)this.availableBytes) {
            return this.availableBytes;
        }
        return targetByteCount;
    }

    private void updateAvailableBytesAfterRead(long bytesRead) {
        if (this.availableBytes != Integer.MIN_VALUE && bytesRead != -1L) {
            this.availableBytes = (int)((long)this.availableBytes - bytesRead);
        }
    }
}

