/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.util;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bumptech.glide.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.Queue;

public class ExceptionCatchingInputStream
extends InputStream {
    private static final Queue<ExceptionCatchingInputStream> QUEUE = Util.createQueue(0);
    private InputStream wrapped;
    private IOException exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ExceptionCatchingInputStream obtain(@NonNull InputStream toWrap) {
        ExceptionCatchingInputStream result;
        Queue<ExceptionCatchingInputStream> queue = QUEUE;
        synchronized (queue) {
            result = QUEUE.poll();
        }
        if (result == null) {
            result = new ExceptionCatchingInputStream();
        }
        result.setInputStream(toWrap);
        return result;
    }

    static void clearQueue() {
        while (!QUEUE.isEmpty()) {
            QUEUE.remove();
        }
    }

    ExceptionCatchingInputStream() {
    }

    void setInputStream(@NonNull InputStream toWrap) {
        this.wrapped = toWrap;
    }

    @Override
    public int available() throws IOException {
        return this.wrapped.available();
    }

    @Override
    public void close() throws IOException {
        this.wrapped.close();
    }

    @Override
    public void mark(int readLimit) {
        this.wrapped.mark(readLimit);
    }

    @Override
    public boolean markSupported() {
        return this.wrapped.markSupported();
    }

    @Override
    public int read(byte[] buffer) {
        int read;
        try {
            read = this.wrapped.read(buffer);
        }
        catch (IOException e) {
            this.exception = e;
            read = -1;
        }
        return read;
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) {
        int read;
        try {
            read = this.wrapped.read(buffer, byteOffset, byteCount);
        }
        catch (IOException e) {
            this.exception = e;
            read = -1;
        }
        return read;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.wrapped.reset();
    }

    @Override
    public long skip(long byteCount) {
        long skipped;
        try {
            skipped = this.wrapped.skip(byteCount);
        }
        catch (IOException e) {
            this.exception = e;
            skipped = 0L;
        }
        return skipped;
    }

    @Override
    public int read() {
        int result;
        try {
            result = this.wrapped.read();
        }
        catch (IOException e) {
            this.exception = e;
            result = -1;
        }
        return result;
    }

    @Nullable
    public IOException getException() {
        return this.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.exception = null;
        this.wrapped = null;
        Queue<ExceptionCatchingInputStream> queue = QUEUE;
        synchronized (queue) {
            QUEUE.offer(this);
        }
    }
}

