/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.provider;

import android.support.annotation.NonNull;
import com.bumptech.glide.load.ResourceDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceDecoderRegistry {
    private final List<String> bucketPriorityList = new ArrayList<String>();
    private final Map<String, List<Entry<?, ?>>> decoders = new HashMap();

    public synchronized void setBucketPriorityList(@NonNull List<String> buckets) {
        ArrayList<String> previousBuckets = new ArrayList<String>(this.bucketPriorityList);
        this.bucketPriorityList.clear();
        this.bucketPriorityList.addAll(buckets);
        for (String previousBucket : previousBuckets) {
            if (buckets.contains(previousBucket)) continue;
            this.bucketPriorityList.add(previousBucket);
        }
    }

    @NonNull
    public synchronized <T, R> List<ResourceDecoder<T, R>> getDecoders(@NonNull Class<T> dataClass, @NonNull Class<R> resourceClass) {
        ArrayList<ResourceDecoder<T, R>> result = new ArrayList<ResourceDecoder<T, R>>();
        for (String bucket : this.bucketPriorityList) {
            List<Entry<?, ?>> entries = this.decoders.get(bucket);
            if (entries == null) continue;
            for (Entry<T, T> entry : entries) {
                if (!entry.handles(dataClass, resourceClass)) continue;
                result.add(entry.decoder);
            }
        }
        return result;
    }

    @NonNull
    public synchronized <T, R> List<Class<R>> getResourceClasses(@NonNull Class<T> dataClass, @NonNull Class<R> resourceClass) {
        ArrayList<Class<R>> result = new ArrayList<Class<R>>();
        for (String bucket : this.bucketPriorityList) {
            List<Entry<?, ?>> entries = this.decoders.get(bucket);
            if (entries == null) continue;
            for (Entry<T, T> entry : entries) {
                if (!entry.handles(dataClass, resourceClass) || result.contains(entry.resourceClass)) continue;
                result.add(entry.resourceClass);
            }
        }
        return result;
    }

    public synchronized <T, R> void append(@NonNull String bucket, @NonNull ResourceDecoder<T, R> decoder, @NonNull Class<T> dataClass, @NonNull Class<R> resourceClass) {
        this.getOrAddEntryList(bucket).add(new Entry<T, R>(dataClass, resourceClass, decoder));
    }

    public synchronized <T, R> void prepend(@NonNull String bucket, @NonNull ResourceDecoder<T, R> decoder, @NonNull Class<T> dataClass, @NonNull Class<R> resourceClass) {
        this.getOrAddEntryList(bucket).add(0, new Entry<T, R>(dataClass, resourceClass, decoder));
    }

    @NonNull
    private synchronized List<Entry<?, ?>> getOrAddEntryList(@NonNull String bucket) {
        List<Entry<?, ?>> entries;
        if (!this.bucketPriorityList.contains(bucket)) {
            this.bucketPriorityList.add(bucket);
        }
        if ((entries = this.decoders.get(bucket)) == null) {
            entries = new ArrayList();
            this.decoders.put(bucket, entries);
        }
        return entries;
    }

    private static class Entry<T, R> {
        private final Class<T> dataClass;
        final Class<R> resourceClass;
        final ResourceDecoder<T, R> decoder;

        public Entry(@NonNull Class<T> dataClass, @NonNull Class<R> resourceClass, ResourceDecoder<T, R> decoder) {
            this.dataClass = dataClass;
            this.resourceClass = resourceClass;
            this.decoder = decoder;
        }

        public boolean handles(@NonNull Class<?> dataClass, @NonNull Class<?> resourceClass) {
            return this.dataClass.isAssignableFrom(dataClass) && resourceClass.isAssignableFrom(this.resourceClass);
        }
    }
}

