/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.manager;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import android.view.View;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.manager.ApplicationLifecycle;
import com.bumptech.glide.manager.EmptyRequestManagerTreeNode;
import com.bumptech.glide.manager.Lifecycle;
import com.bumptech.glide.manager.RequestManagerFragment;
import com.bumptech.glide.manager.RequestManagerTreeNode;
import com.bumptech.glide.manager.SupportRequestManagerFragment;
import com.bumptech.glide.util.Preconditions;
import com.bumptech.glide.util.Util;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class RequestManagerRetriever
implements Handler.Callback {
    @VisibleForTesting
    static final String FRAGMENT_TAG = "com.bumptech.glide.manager";
    private static final String TAG = "RMRetriever";
    private static final int ID_REMOVE_FRAGMENT_MANAGER = 1;
    private static final int ID_REMOVE_SUPPORT_FRAGMENT_MANAGER = 2;
    private static final String FRAGMENT_INDEX_KEY = "key";
    private volatile RequestManager applicationManager;
    @VisibleForTesting
    final Map<android.app.FragmentManager, RequestManagerFragment> pendingRequestManagerFragments = new HashMap<android.app.FragmentManager, RequestManagerFragment>();
    @VisibleForTesting
    final Map<FragmentManager, SupportRequestManagerFragment> pendingSupportRequestManagerFragments = new HashMap<FragmentManager, SupportRequestManagerFragment>();
    private final Handler handler;
    private final RequestManagerFactory factory;
    private final ArrayMap<View, android.support.v4.app.Fragment> tempViewToSupportFragment = new ArrayMap();
    private final ArrayMap<View, Fragment> tempViewToFragment = new ArrayMap();
    private final Bundle tempBundle = new Bundle();
    private static final RequestManagerFactory DEFAULT_FACTORY = new RequestManagerFactory(){

        @Override
        @NonNull
        public RequestManager build(@NonNull Glide glide, @NonNull Lifecycle lifecycle, @NonNull RequestManagerTreeNode requestManagerTreeNode, @NonNull Context context) {
            return new RequestManager(glide, lifecycle, requestManagerTreeNode, context);
        }
    };

    public RequestManagerRetriever(@Nullable RequestManagerFactory factory) {
        this.factory = factory != null ? factory : DEFAULT_FACTORY;
        this.handler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private RequestManager getApplicationManager(@NonNull Context context) {
        if (this.applicationManager == null) {
            RequestManagerRetriever requestManagerRetriever = this;
            synchronized (requestManagerRetriever) {
                if (this.applicationManager == null) {
                    Glide glide = Glide.get(context.getApplicationContext());
                    this.applicationManager = this.factory.build(glide, new ApplicationLifecycle(), new EmptyRequestManagerTreeNode(), context.getApplicationContext());
                }
            }
        }
        return this.applicationManager;
    }

    @NonNull
    public RequestManager get(@NonNull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("You cannot start a load on a null Context");
        }
        if (Util.isOnMainThread() && !(context instanceof Application)) {
            if (context instanceof FragmentActivity) {
                return this.get((FragmentActivity)context);
            }
            if (context instanceof Activity) {
                return this.get((Activity)context);
            }
            if (context instanceof ContextWrapper) {
                return this.get(((ContextWrapper)context).getBaseContext());
            }
        }
        return this.getApplicationManager(context);
    }

    @NonNull
    public RequestManager get(@NonNull FragmentActivity activity) {
        if (Util.isOnBackgroundThread()) {
            return this.get(activity.getApplicationContext());
        }
        RequestManagerRetriever.assertNotDestroyed((Activity)activity);
        FragmentManager fm = activity.getSupportFragmentManager();
        return this.supportFragmentGet((Context)activity, fm, null, RequestManagerRetriever.isActivityVisible((Activity)activity));
    }

    @NonNull
    public RequestManager get(@NonNull android.support.v4.app.Fragment fragment) {
        Preconditions.checkNotNull(fragment.getActivity(), "You cannot start a load on a fragment before it is attached or after it is destroyed");
        if (Util.isOnBackgroundThread()) {
            return this.get(fragment.getActivity().getApplicationContext());
        }
        FragmentManager fm = fragment.getChildFragmentManager();
        return this.supportFragmentGet((Context)fragment.getActivity(), fm, fragment, fragment.isVisible());
    }

    @NonNull
    public RequestManager get(@NonNull Activity activity) {
        if (Util.isOnBackgroundThread()) {
            return this.get(activity.getApplicationContext());
        }
        RequestManagerRetriever.assertNotDestroyed(activity);
        android.app.FragmentManager fm = activity.getFragmentManager();
        return this.fragmentGet((Context)activity, fm, null, RequestManagerRetriever.isActivityVisible(activity));
    }

    @NonNull
    public RequestManager get(@NonNull View view) {
        if (Util.isOnBackgroundThread()) {
            return this.get(view.getContext().getApplicationContext());
        }
        Preconditions.checkNotNull(view);
        Preconditions.checkNotNull(view.getContext(), "Unable to obtain a request manager for a view without a Context");
        Activity activity = this.findActivity(view.getContext());
        if (activity == null) {
            return this.get(view.getContext().getApplicationContext());
        }
        if (activity instanceof FragmentActivity) {
            android.support.v4.app.Fragment fragment = this.findSupportFragment(view, (FragmentActivity)activity);
            return fragment != null ? this.get(fragment) : this.get(activity);
        }
        Fragment fragment = this.findFragment(view, activity);
        if (fragment == null) {
            return this.get(activity);
        }
        return this.get(fragment);
    }

    private static void findAllSupportFragmentsWithViews(@Nullable Collection<android.support.v4.app.Fragment> topLevelFragments, @NonNull Map<View, android.support.v4.app.Fragment> result) {
        if (topLevelFragments == null) {
            return;
        }
        for (android.support.v4.app.Fragment fragment : topLevelFragments) {
            if (fragment == null || fragment.getView() == null) continue;
            result.put(fragment.getView(), fragment);
            RequestManagerRetriever.findAllSupportFragmentsWithViews(fragment.getChildFragmentManager().getFragments(), result);
        }
    }

    @Nullable
    private android.support.v4.app.Fragment findSupportFragment(@NonNull View target, @NonNull FragmentActivity activity) {
        this.tempViewToSupportFragment.clear();
        RequestManagerRetriever.findAllSupportFragmentsWithViews(activity.getSupportFragmentManager().getFragments(), this.tempViewToSupportFragment);
        android.support.v4.app.Fragment result = null;
        View activityRoot = activity.findViewById(0x1020002);
        View current = target;
        while (!current.equals(activityRoot) && (result = (android.support.v4.app.Fragment)this.tempViewToSupportFragment.get((Object)current)) == null && current.getParent() instanceof View) {
            current = (View)current.getParent();
        }
        this.tempViewToSupportFragment.clear();
        return result;
    }

    @Deprecated
    @Nullable
    private Fragment findFragment(@NonNull View target, @NonNull Activity activity) {
        this.tempViewToFragment.clear();
        this.findAllFragmentsWithViews(activity.getFragmentManager(), this.tempViewToFragment);
        Fragment result = null;
        View activityRoot = activity.findViewById(0x1020002);
        View current = target;
        while (!current.equals(activityRoot) && (result = (Fragment)this.tempViewToFragment.get((Object)current)) == null && current.getParent() instanceof View) {
            current = (View)current.getParent();
        }
        this.tempViewToFragment.clear();
        return result;
    }

    @Deprecated
    @TargetApi(value=26)
    private void findAllFragmentsWithViews(@NonNull android.app.FragmentManager fragmentManager, @NonNull ArrayMap<View, Fragment> result) {
        if (Build.VERSION.SDK_INT >= 26) {
            for (Fragment fragment : fragmentManager.getFragments()) {
                if (fragment.getView() == null) continue;
                result.put((Object)fragment.getView(), (Object)fragment);
                this.findAllFragmentsWithViews(fragment.getChildFragmentManager(), result);
            }
        } else {
            this.findAllFragmentsWithViewsPreO(fragmentManager, result);
        }
    }

    @Deprecated
    private void findAllFragmentsWithViewsPreO(@NonNull android.app.FragmentManager fragmentManager, @NonNull ArrayMap<View, Fragment> result) {
        int index = 0;
        while (true) {
            this.tempBundle.putInt(FRAGMENT_INDEX_KEY, index++);
            Fragment fragment = null;
            try {
                fragment = fragmentManager.getFragment(this.tempBundle, FRAGMENT_INDEX_KEY);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fragment == null) break;
            if (fragment.getView() == null) continue;
            result.put((Object)fragment.getView(), (Object)fragment);
            if (Build.VERSION.SDK_INT < 17) continue;
            this.findAllFragmentsWithViews(fragment.getChildFragmentManager(), result);
        }
    }

    @Nullable
    private Activity findActivity(@NonNull Context context) {
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            return this.findActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    @TargetApi(value=17)
    private static void assertNotDestroyed(@NonNull Activity activity) {
        if (Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) {
            throw new IllegalArgumentException("You cannot start a load for a destroyed activity");
        }
    }

    @Deprecated
    @NonNull
    @TargetApi(value=17)
    public RequestManager get(@NonNull Fragment fragment) {
        if (fragment.getActivity() == null) {
            throw new IllegalArgumentException("You cannot start a load on a fragment before it is attached");
        }
        if (Util.isOnBackgroundThread() || Build.VERSION.SDK_INT < 17) {
            return this.get(fragment.getActivity().getApplicationContext());
        }
        android.app.FragmentManager fm = fragment.getChildFragmentManager();
        return this.fragmentGet((Context)fragment.getActivity(), fm, fragment, fragment.isVisible());
    }

    @Deprecated
    @NonNull
    RequestManagerFragment getRequestManagerFragment(Activity activity) {
        return this.getRequestManagerFragment(activity.getFragmentManager(), null, RequestManagerRetriever.isActivityVisible(activity));
    }

    @NonNull
    private RequestManagerFragment getRequestManagerFragment(@NonNull android.app.FragmentManager fm, @Nullable Fragment parentHint, boolean isParentVisible) {
        RequestManagerFragment current = (RequestManagerFragment)fm.findFragmentByTag(FRAGMENT_TAG);
        if (current == null && (current = this.pendingRequestManagerFragments.get(fm)) == null) {
            current = new RequestManagerFragment();
            current.setParentFragmentHint(parentHint);
            if (isParentVisible) {
                current.getGlideLifecycle().onStart();
            }
            this.pendingRequestManagerFragments.put(fm, current);
            fm.beginTransaction().add((Fragment)current, FRAGMENT_TAG).commitAllowingStateLoss();
            this.handler.obtainMessage(1, (Object)fm).sendToTarget();
        }
        return current;
    }

    @Deprecated
    @NonNull
    private RequestManager fragmentGet(@NonNull Context context, @NonNull android.app.FragmentManager fm, @Nullable Fragment parentHint, boolean isParentVisible) {
        RequestManagerFragment current = this.getRequestManagerFragment(fm, parentHint, isParentVisible);
        RequestManager requestManager = current.getRequestManager();
        if (requestManager == null) {
            Glide glide = Glide.get(context);
            requestManager = this.factory.build(glide, current.getGlideLifecycle(), current.getRequestManagerTreeNode(), context);
            current.setRequestManager(requestManager);
        }
        return requestManager;
    }

    @NonNull
    SupportRequestManagerFragment getSupportRequestManagerFragment(FragmentActivity activity) {
        return this.getSupportRequestManagerFragment(activity.getSupportFragmentManager(), null, RequestManagerRetriever.isActivityVisible((Activity)activity));
    }

    private static boolean isActivityVisible(Activity activity) {
        return !activity.isFinishing();
    }

    @NonNull
    private SupportRequestManagerFragment getSupportRequestManagerFragment(@NonNull FragmentManager fm, @Nullable android.support.v4.app.Fragment parentHint, boolean isParentVisible) {
        SupportRequestManagerFragment current = (SupportRequestManagerFragment)fm.findFragmentByTag(FRAGMENT_TAG);
        if (current == null && (current = this.pendingSupportRequestManagerFragments.get(fm)) == null) {
            current = new SupportRequestManagerFragment();
            current.setParentFragmentHint(parentHint);
            if (isParentVisible) {
                current.getGlideLifecycle().onStart();
            }
            this.pendingSupportRequestManagerFragments.put(fm, current);
            fm.beginTransaction().add((android.support.v4.app.Fragment)current, FRAGMENT_TAG).commitAllowingStateLoss();
            this.handler.obtainMessage(2, (Object)fm).sendToTarget();
        }
        return current;
    }

    @NonNull
    private RequestManager supportFragmentGet(@NonNull Context context, @NonNull FragmentManager fm, @Nullable android.support.v4.app.Fragment parentHint, boolean isParentVisible) {
        SupportRequestManagerFragment current = this.getSupportRequestManagerFragment(fm, parentHint, isParentVisible);
        RequestManager requestManager = current.getRequestManager();
        if (requestManager == null) {
            Glide glide = Glide.get(context);
            requestManager = this.factory.build(glide, current.getGlideLifecycle(), current.getRequestManagerTreeNode(), context);
            current.setRequestManager(requestManager);
        }
        return requestManager;
    }

    public boolean handleMessage(Message message) {
        boolean handled = true;
        Object removed = null;
        android.app.FragmentManager key = null;
        switch (message.what) {
            case 1: {
                android.app.FragmentManager fm;
                key = fm = (android.app.FragmentManager)message.obj;
                removed = this.pendingRequestManagerFragments.remove(fm);
                break;
            }
            case 2: {
                FragmentManager supportFm = (FragmentManager)message.obj;
                key = supportFm;
                removed = this.pendingSupportRequestManagerFragments.remove(supportFm);
                break;
            }
            default: {
                handled = false;
            }
        }
        if (handled && removed == null && Log.isLoggable((String)TAG, (int)5)) {
            Log.w((String)TAG, (String)("Failed to remove expected request manager fragment, manager: " + key));
        }
        return handled;
    }

    public static interface RequestManagerFactory {
        @NonNull
        public RequestManager build(@NonNull Glide var1, @NonNull Lifecycle var2, @NonNull RequestManagerTreeNode var3, @NonNull Context var4);
    }
}

