/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.util.Log;
import com.bumptech.glide.load.DecodeFormat;
import java.io.File;

final class HardwareConfigState {
    private static final int MIN_HARDWARE_DIMENSION = 128;
    private static final File FD_SIZE_LIST = new File("/proc/self/fd");
    private static final int MINIMUM_DECODES_BETWEEN_FD_CHECKS = 50;
    private static final int MAXIMUM_FDS_FOR_HARDWARE_CONFIGS = 700;
    private volatile int decodesSinceLastFdCheck;
    private volatile boolean isHardwareConfigAllowed = true;
    private static volatile HardwareConfigState instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static HardwareConfigState getInstance() {
        if (instance != null) return instance;
        Class<HardwareConfigState> clazz = HardwareConfigState.class;
        synchronized (HardwareConfigState.class) {
            if (instance != null) return instance;
            instance = new HardwareConfigState();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private HardwareConfigState() {
    }

    @TargetApi(value=26)
    boolean setHardwareConfigIfAllowed(int targetWidth, int targetHeight, BitmapFactory.Options optionsWithScaling, DecodeFormat decodeFormat, boolean isHardwareConfigAllowed, boolean isExifOrientationRequired) {
        boolean result;
        if (!isHardwareConfigAllowed || Build.VERSION.SDK_INT < 26 || decodeFormat == DecodeFormat.PREFER_ARGB_8888_DISALLOW_HARDWARE || isExifOrientationRequired) {
            return false;
        }
        boolean bl = result = targetWidth >= 128 && targetHeight >= 128 && this.isFdSizeBelowHardwareLimit();
        if (result) {
            optionsWithScaling.inPreferredConfig = Bitmap.Config.HARDWARE;
            optionsWithScaling.inMutable = false;
        }
        return result;
    }

    private synchronized boolean isFdSizeBelowHardwareLimit() {
        if (++this.decodesSinceLastFdCheck >= 50) {
            this.decodesSinceLastFdCheck = 0;
            int currentFds = FD_SIZE_LIST.list().length;
            boolean bl = this.isHardwareConfigAllowed = currentFds < 700;
            if (!this.isHardwareConfigAllowed && Log.isLoggable((String)"Downsampler", (int)5)) {
                Log.w((String)"Downsampler", (String)("Excluding HARDWARE bitmap config because we're over the file descriptor limit, file descriptors " + currentFds + ", limit " + 700));
            }
        }
        return this.isHardwareConfigAllowed;
    }
}

