/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.cache;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.cache.MemoryCache;
import com.bumptech.glide.util.LruCache;

public class LruResourceCache
extends LruCache<Key, Resource<?>>
implements MemoryCache {
    private MemoryCache.ResourceRemovedListener listener;

    public LruResourceCache(long size) {
        super(size);
    }

    @Override
    public void setResourceRemovedListener(@NonNull MemoryCache.ResourceRemovedListener listener) {
        this.listener = listener;
    }

    @Override
    protected void onItemEvicted(@NonNull Key key, @Nullable Resource<?> item) {
        if (this.listener != null && item != null) {
            this.listener.onResourceRemoved(item);
        }
    }

    @Override
    protected int getSize(@Nullable Resource<?> item) {
        if (item == null) {
            return super.getSize(null);
        }
        return item.getSize();
    }

    @Override
    @SuppressLint(value={"InlinedApi"})
    public void trimMemory(int level) {
        if (level >= 40) {
            this.clearMemory();
        } else if (level >= 20 || level == 15) {
            this.trimToSize(this.getMaxSize() / 2L);
        }
    }
}

