/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.data;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import android.util.Log;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.HttpException;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.util.ContentLengthInputStream;
import com.bumptech.glide.util.LogTime;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;

public class HttpUrlFetcher
implements DataFetcher<InputStream> {
    private static final String TAG = "HttpUrlFetcher";
    private static final int MAXIMUM_REDIRECTS = 5;
    @VisibleForTesting
    static final HttpUrlConnectionFactory DEFAULT_CONNECTION_FACTORY = new DefaultHttpUrlConnectionFactory();
    private static final int INVALID_STATUS_CODE = -1;
    private final GlideUrl glideUrl;
    private final int timeout;
    private final HttpUrlConnectionFactory connectionFactory;
    private HttpURLConnection urlConnection;
    private InputStream stream;
    private volatile boolean isCancelled;

    public HttpUrlFetcher(GlideUrl glideUrl, int timeout) {
        this(glideUrl, timeout, DEFAULT_CONNECTION_FACTORY);
    }

    @VisibleForTesting
    HttpUrlFetcher(GlideUrl glideUrl, int timeout, HttpUrlConnectionFactory connectionFactory) {
        this.glideUrl = glideUrl;
        this.timeout = timeout;
        this.connectionFactory = connectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadData(@NonNull Priority priority, @NonNull DataFetcher.DataCallback<? super InputStream> callback) {
        long startTime = LogTime.getLogTime();
        try {
            InputStream result = this.loadDataWithRedirects(this.glideUrl.toURL(), 0, null, this.glideUrl.getHeaders());
            callback.onDataReady(result);
        }
        catch (IOException e) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Failed to load data for url", (Throwable)e);
            }
            callback.onLoadFailed(e);
        }
        finally {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("Finished http url fetcher fetch in " + LogTime.getElapsedMillis(startTime)));
            }
        }
    }

    private InputStream loadDataWithRedirects(URL url, int redirects, URL lastUrl, Map<String, String> headers) throws IOException {
        if (redirects >= 5) {
            throw new HttpException("Too many (> 5) redirects!");
        }
        try {
            if (lastUrl != null && url.toURI().equals(lastUrl.toURI())) {
                throw new HttpException("In re-direct loop");
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.urlConnection = this.connectionFactory.build(url);
        for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
            this.urlConnection.addRequestProperty(headerEntry.getKey(), headerEntry.getValue());
        }
        this.urlConnection.setConnectTimeout(this.timeout);
        this.urlConnection.setReadTimeout(this.timeout);
        this.urlConnection.setUseCaches(false);
        this.urlConnection.setDoInput(true);
        this.urlConnection.setInstanceFollowRedirects(false);
        this.urlConnection.connect();
        this.stream = this.urlConnection.getInputStream();
        if (this.isCancelled) {
            return null;
        }
        int statusCode = this.urlConnection.getResponseCode();
        if (HttpUrlFetcher.isHttpOk(statusCode)) {
            return this.getStreamForSuccessfulRequest(this.urlConnection);
        }
        if (HttpUrlFetcher.isHttpRedirect(statusCode)) {
            String redirectUrlString = this.urlConnection.getHeaderField("Location");
            if (TextUtils.isEmpty((CharSequence)redirectUrlString)) {
                throw new HttpException("Received empty or null redirect url");
            }
            URL redirectUrl = new URL(url, redirectUrlString);
            this.cleanup();
            return this.loadDataWithRedirects(redirectUrl, redirects + 1, url, headers);
        }
        if (statusCode == -1) {
            throw new HttpException(statusCode);
        }
        throw new HttpException(this.urlConnection.getResponseMessage(), statusCode);
    }

    private static boolean isHttpOk(int statusCode) {
        return statusCode / 100 == 2;
    }

    private static boolean isHttpRedirect(int statusCode) {
        return statusCode / 100 == 3;
    }

    private InputStream getStreamForSuccessfulRequest(HttpURLConnection urlConnection) throws IOException {
        if (TextUtils.isEmpty((CharSequence)urlConnection.getContentEncoding())) {
            int contentLength = urlConnection.getContentLength();
            this.stream = ContentLengthInputStream.obtain(urlConnection.getInputStream(), contentLength);
        } else {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Got non empty content encoding: " + urlConnection.getContentEncoding()));
            }
            this.stream = urlConnection.getInputStream();
        }
        return this.stream;
    }

    @Override
    public void cleanup() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.urlConnection != null) {
            this.urlConnection.disconnect();
        }
        this.urlConnection = null;
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
    }

    @Override
    @NonNull
    public Class<InputStream> getDataClass() {
        return InputStream.class;
    }

    @Override
    @NonNull
    public DataSource getDataSource() {
        return DataSource.REMOTE;
    }

    private static class DefaultHttpUrlConnectionFactory
    implements HttpUrlConnectionFactory {
        DefaultHttpUrlConnectionFactory() {
        }

        @Override
        public HttpURLConnection build(URL url) throws IOException {
            return (HttpURLConnection)url.openConnection();
        }
    }

    static interface HttpUrlConnectionFactory {
        public HttpURLConnection build(URL var1) throws IOException;
    }
}

