/*
 * Decompiled with CFR 0.152.
 */
package com.smarteist.autoimageslider.IndicatorView.animation.controller;

import android.support.annotation.NonNull;
import com.smarteist.autoimageslider.IndicatorView.animation.controller.ValueController;
import com.smarteist.autoimageslider.IndicatorView.animation.type.AnimationType;
import com.smarteist.autoimageslider.IndicatorView.animation.type.BaseAnimation;
import com.smarteist.autoimageslider.IndicatorView.animation.type.DropAnimation;
import com.smarteist.autoimageslider.IndicatorView.animation.type.WormAnimation;
import com.smarteist.autoimageslider.IndicatorView.draw.data.Indicator;
import com.smarteist.autoimageslider.IndicatorView.draw.data.Orientation;
import com.smarteist.autoimageslider.IndicatorView.utils.CoordinatesUtils;

public class AnimationController {
    private ValueController valueController;
    private ValueController.UpdateListener listener;
    private BaseAnimation runningAnimation;
    private Indicator indicator;
    private float progress;
    private boolean isInteractive;

    public AnimationController(@NonNull Indicator indicator, @NonNull ValueController.UpdateListener listener) {
        this.valueController = new ValueController(listener);
        this.listener = listener;
        this.indicator = indicator;
    }

    public void interactive(float progress) {
        this.isInteractive = true;
        this.progress = progress;
        this.animate();
    }

    public void basic() {
        this.isInteractive = false;
        this.progress = 0.0f;
        this.animate();
    }

    public void end() {
        if (this.runningAnimation != null) {
            this.runningAnimation.end();
        }
    }

    private void animate() {
        AnimationType animationType = this.indicator.getAnimationType();
        switch (animationType) {
            case NONE: {
                this.listener.onValueUpdated(null);
                break;
            }
            case COLOR: {
                this.colorAnimation();
                break;
            }
            case SCALE: {
                this.scaleAnimation();
                break;
            }
            case WORM: {
                this.wormAnimation();
                break;
            }
            case FILL: {
                this.fillAnimation();
                break;
            }
            case SLIDE: {
                this.slideAnimation();
                break;
            }
            case THIN_WORM: {
                this.thinWormAnimation();
                break;
            }
            case DROP: {
                this.dropAnimation();
                break;
            }
            case SWAP: {
                this.swapAnimation();
                break;
            }
            case SCALE_DOWN: {
                this.scaleDownAnimation();
            }
        }
    }

    private void colorAnimation() {
        int selectedColor = this.indicator.getSelectedColor();
        int unselectedColor = this.indicator.getUnselectedColor();
        long animationDuration = this.indicator.getAnimationDuration();
        BaseAnimation animation = this.valueController.color().with(unselectedColor, selectedColor).duration(animationDuration);
        if (this.isInteractive) {
            animation.progress(this.progress);
        } else {
            animation.start();
        }
        this.runningAnimation = animation;
    }

    private void scaleAnimation() {
        int selectedColor = this.indicator.getSelectedColor();
        int unselectedColor = this.indicator.getUnselectedColor();
        int radiusPx = this.indicator.getRadius();
        float scaleFactor = this.indicator.getScaleFactor();
        long animationDuration = this.indicator.getAnimationDuration();
        BaseAnimation animation = this.valueController.scale().with(unselectedColor, selectedColor, radiusPx, scaleFactor).duration(animationDuration);
        if (this.isInteractive) {
            animation.progress(this.progress);
        } else {
            animation.start();
        }
        this.runningAnimation = animation;
    }

    private void wormAnimation() {
        int fromPosition = this.indicator.isInteractiveAnimation() ? this.indicator.getSelectedPosition() : this.indicator.getLastSelectedPosition();
        int toPosition = this.indicator.isInteractiveAnimation() ? this.indicator.getSelectingPosition() : this.indicator.getSelectedPosition();
        int from = CoordinatesUtils.getCoordinate(this.indicator, fromPosition);
        int to = CoordinatesUtils.getCoordinate(this.indicator, toPosition);
        boolean isRightSide = toPosition > fromPosition;
        int radiusPx = this.indicator.getRadius();
        long animationDuration = this.indicator.getAnimationDuration();
        WormAnimation animation = this.valueController.worm().with(from, to, radiusPx, isRightSide).duration(animationDuration);
        if (this.isInteractive) {
            ((BaseAnimation)animation).progress(this.progress);
        } else {
            animation.start();
        }
        this.runningAnimation = animation;
    }

    private void slideAnimation() {
        int fromPosition = this.indicator.isInteractiveAnimation() ? this.indicator.getSelectedPosition() : this.indicator.getLastSelectedPosition();
        int toPosition = this.indicator.isInteractiveAnimation() ? this.indicator.getSelectingPosition() : this.indicator.getSelectedPosition();
        int from = CoordinatesUtils.getCoordinate(this.indicator, fromPosition);
        int to = CoordinatesUtils.getCoordinate(this.indicator, toPosition);
        long animationDuration = this.indicator.getAnimationDuration();
        BaseAnimation animation = this.valueController.slide().with(from, to).duration(animationDuration);
        if (this.isInteractive) {
            animation.progress(this.progress);
        } else {
            animation.start();
        }
        this.runningAnimation = animation;
    }

    private void fillAnimation() {
        int selectedColor = this.indicator.getSelectedColor();
        int unselectedColor = this.indicator.getUnselectedColor();
        int radiusPx = this.indicator.getRadius();
        int strokePx = this.indicator.getStroke();
        long animationDuration = this.indicator.getAnimationDuration();
        BaseAnimation animation = this.valueController.fill().with(unselectedColor, selectedColor, radiusPx, strokePx).duration(animationDuration);
        if (this.isInteractive) {
            animation.progress(this.progress);
        } else {
            animation.start();
        }
        this.runningAnimation = animation;
    }

    private void thinWormAnimation() {
        int fromPosition = this.indicator.isInteractiveAnimation() ? this.indicator.getSelectedPosition() : this.indicator.getLastSelectedPosition();
        int toPosition = this.indicator.isInteractiveAnimation() ? this.indicator.getSelectingPosition() : this.indicator.getSelectedPosition();
        int from = CoordinatesUtils.getCoordinate(this.indicator, fromPosition);
        int to = CoordinatesUtils.getCoordinate(this.indicator, toPosition);
        boolean isRightSide = toPosition > fromPosition;
        int radiusPx = this.indicator.getRadius();
        long animationDuration = this.indicator.getAnimationDuration();
        WormAnimation animation = this.valueController.thinWorm().with(from, to, radiusPx, isRightSide).duration(animationDuration);
        if (this.isInteractive) {
            ((BaseAnimation)animation).progress(this.progress);
        } else {
            animation.start();
        }
        this.runningAnimation = animation;
    }

    private void dropAnimation() {
        int fromPosition = this.indicator.isInteractiveAnimation() ? this.indicator.getSelectedPosition() : this.indicator.getLastSelectedPosition();
        int toPosition = this.indicator.isInteractiveAnimation() ? this.indicator.getSelectingPosition() : this.indicator.getSelectedPosition();
        int widthFrom = CoordinatesUtils.getCoordinate(this.indicator, fromPosition);
        int widthTo = CoordinatesUtils.getCoordinate(this.indicator, toPosition);
        int paddingTop = this.indicator.getPaddingTop();
        int paddingLeft = this.indicator.getPaddingLeft();
        int padding = this.indicator.getOrientation() == Orientation.HORIZONTAL ? paddingTop : paddingLeft;
        int radius = this.indicator.getRadius();
        int heightFrom = radius * 3 + padding;
        int heightTo = radius + padding;
        long animationDuration = this.indicator.getAnimationDuration();
        DropAnimation animation = this.valueController.drop().duration(animationDuration).with(widthFrom, widthTo, heightFrom, heightTo, radius);
        if (this.isInteractive) {
            ((BaseAnimation)animation).progress(this.progress);
        } else {
            animation.start();
        }
        this.runningAnimation = animation;
    }

    private void swapAnimation() {
        int fromPosition = this.indicator.isInteractiveAnimation() ? this.indicator.getSelectedPosition() : this.indicator.getLastSelectedPosition();
        int toPosition = this.indicator.isInteractiveAnimation() ? this.indicator.getSelectingPosition() : this.indicator.getSelectedPosition();
        int from = CoordinatesUtils.getCoordinate(this.indicator, fromPosition);
        int to = CoordinatesUtils.getCoordinate(this.indicator, toPosition);
        long animationDuration = this.indicator.getAnimationDuration();
        BaseAnimation animation = this.valueController.swap().with(from, to).duration(animationDuration);
        if (this.isInteractive) {
            animation.progress(this.progress);
        } else {
            animation.start();
        }
        this.runningAnimation = animation;
    }

    private void scaleDownAnimation() {
        int selectedColor = this.indicator.getSelectedColor();
        int unselectedColor = this.indicator.getUnselectedColor();
        int radiusPx = this.indicator.getRadius();
        float scaleFactor = this.indicator.getScaleFactor();
        long animationDuration = this.indicator.getAnimationDuration();
        BaseAnimation animation = this.valueController.scaleDown().with(unselectedColor, selectedColor, radiusPx, scaleFactor).duration(animationDuration);
        if (this.isInteractive) {
            animation.progress(this.progress);
        } else {
            animation.start();
        }
        this.runningAnimation = animation;
    }
}

