/*
 * Decompiled with CFR 0.152.
 */
package imageslider.smarteist.com.autoimageslider;

import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.DrawableRes;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.smarteist.autoimageslider.R;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SliderView {
    private OnSliderClickListener onSliderClickListener;
    private String description;
    @DrawableRes
    private int imageRes = 0;
    private String imageUrl;
    private ImageView.ScaleType scaleType = ImageView.ScaleType.CENTER_CROP;
    private Context context;

    public SliderView(Context context) {
        this.context = context;
    }

    private String getDescription() {
        return this.description;
    }

    public SliderView setDescription(String description) {
        this.description = description;
        return this;
    }

    public int getImageRes() {
        return this.imageRes;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public SliderView setImageUrl(String imageUrl) {
        if (this.imageRes != 0) {
            throw new IllegalStateException("Can't set multiple images");
        }
        this.imageUrl = imageUrl;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SliderView setImageByte(byte[] imageByte) {
        ContextWrapper wrapper = new ContextWrapper(this.context);
        File file = new File(wrapper.getCacheDir().getAbsolutePath(), "Cached" + System.currentTimeMillis() + ".jpeg");
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])imageByte, (int)0, (int)imageByte.length);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.PNG, 95, (OutputStream)out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.imageUrl = String.valueOf(Uri.fromFile((File)file));
        return this;
    }

    public SliderView setImageDrawable(int imageDrawable) {
        if (!TextUtils.isEmpty((CharSequence)this.imageUrl)) {
            throw new IllegalStateException("Can't set multiple images");
        }
        this.imageRes = imageDrawable;
        return this;
    }

    private ImageView.ScaleType getScaleType() {
        return this.scaleType;
    }

    public SliderView setImageScaleType(ImageView.ScaleType scaleType) {
        this.scaleType = scaleType;
        return this;
    }

    public View getView() {
        View v = LayoutInflater.from((Context)this.context).inflate(R.layout.image_slider_layout_item, null, true);
        ImageView autoSliderImage = (ImageView)v.findViewById(R.id.iv_auto_image_slider);
        TextView description = (TextView)v.findViewById(R.id.tv_auto_image_slider);
        description.getBackground();
        description.setText((CharSequence)this.getDescription());
        this.bindData(v, autoSliderImage);
        return v;
    }

    public SliderView setOnSliderClickListener(OnSliderClickListener l) {
        this.onSliderClickListener = l;
        return this;
    }

    private void bindData(View v, ImageView autoSliderImage) {
        final SliderView con = this;
        v.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (SliderView.this.onSliderClickListener != null) {
                    SliderView.this.onSliderClickListener.onSliderClick(con);
                }
            }
        });
        try {
            autoSliderImage.setScaleType(this.getScaleType());
            if (this.imageUrl != null) {
                autoSliderImage.setImageURI(Uri.parse((String)this.imageUrl));
            }
            if (this.imageRes != 0) {
                autoSliderImage.setImageResource(this.imageRes);
            }
        }
        catch (Exception exception) {
            Log.d((String)"Exception", (String)exception.getMessage());
        }
    }

    public static interface OnSliderClickListener {
        public void onSliderClick(SliderView var1);
    }
}

