/*
 * Decompiled with CFR 0.152.
 */
package imageslider.smarteist.com.autoimageslider;

import android.content.Context;
import android.os.Handler;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.rd.PageIndicatorView;
import com.rd.animation.type.AnimationType;
import com.smarteist.autoimageslider.R;
import imageslider.smarteist.com.autoimageslider.CircularSliderHandle;
import imageslider.smarteist.com.autoimageslider.SliderAdapter;
import imageslider.smarteist.com.autoimageslider.SliderView;
import java.util.Timer;
import java.util.TimerTask;

public class SliderLayout
extends FrameLayout
implements CircularSliderHandle.CurrentPageListener {
    private static final long DELAY_MS = 500L;
    private static PagerAdapter mFlippingPagerAdapter;
    int currentPage = 0;
    CircularSliderHandle circularSliderHandle;
    private ViewPager mFlippingPager;
    private PageIndicatorView pagerIndicator;
    private int scrollTimeInSec = 2;
    private Handler handler = new Handler();
    private Timer flippingTimer;

    public SliderLayout(Context context) {
        super(context);
        this.setLayout(context);
    }

    public SliderLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setLayout(context);
    }

    public SliderLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setLayout(context);
    }

    private static PagerAdapter getFlippingPagerAdapter() {
        return mFlippingPagerAdapter;
    }

    public int getScrollTimeInSec() {
        return this.scrollTimeInSec;
    }

    public void setScrollTimeInSec(int time) {
        this.scrollTimeInSec = time;
        this.startAutoCycle();
    }

    public int getCurrentPagePosition() {
        if (SliderLayout.getFlippingPagerAdapter() != null) {
            return this.mFlippingPager.getCurrentItem() % mFlippingPagerAdapter.getCount();
        }
        throw new NullPointerException("Adapter not set");
    }

    public void setIndicatotAnimation(Animations animations) {
        switch (animations) {
            case DROP: {
                this.pagerIndicator.setAnimationType(AnimationType.DROP);
                break;
            }
            case FILL: {
                this.pagerIndicator.setAnimationType(AnimationType.FILL);
                break;
            }
            case NONE: {
                this.pagerIndicator.setAnimationType(AnimationType.NONE);
                break;
            }
            case SWAP: {
                this.pagerIndicator.setAnimationType(AnimationType.SWAP);
                break;
            }
            case WORM: {
                this.pagerIndicator.setAnimationType(AnimationType.WORM);
                break;
            }
            case COLOR: {
                this.pagerIndicator.setAnimationType(AnimationType.COLOR);
                break;
            }
            case SCALE: {
                this.pagerIndicator.setAnimationType(AnimationType.SCALE);
                break;
            }
            case SLIDE: {
                this.pagerIndicator.setAnimationType(AnimationType.SLIDE);
                break;
            }
            case SCALE_DOWN: {
                this.pagerIndicator.setAnimationType(AnimationType.SCALE_DOWN);
                break;
            }
            case THIN_WORM: {
                this.pagerIndicator.setAnimationType(AnimationType.THIN_WORM);
            }
        }
    }

    private void setLayout(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.slider_layout, (ViewGroup)this, true);
        this.mFlippingPager = (ViewPager)view.findViewById(R.id.vp_slider_layout);
        this.pagerIndicator = (PageIndicatorView)view.findViewById(R.id.pager_indicator);
        mFlippingPagerAdapter = new SliderAdapter(context);
        this.mFlippingPager.setAdapter(mFlippingPagerAdapter);
        this.circularSliderHandle = new CircularSliderHandle(this.mFlippingPager);
        this.circularSliderHandle.setCurrentPageListener(this);
        this.mFlippingPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.circularSliderHandle);
        this.startAutoCycle();
    }

    public void addSliderView(SliderView sliderView) {
        ((SliderAdapter)mFlippingPagerAdapter).addSliderView(sliderView);
        this.pagerIndicator.setViewPager(this.mFlippingPager);
    }

    private void startAutoCycle() {
        if (this.flippingTimer != null) {
            this.flippingTimer.cancel();
        }
        final Runnable Update = new Runnable(){

            @Override
            public void run() {
                if (SliderLayout.this.currentPage == SliderLayout.getFlippingPagerAdapter().getCount()) {
                    SliderLayout.this.currentPage = 0;
                }
                SliderLayout.this.mFlippingPager.setCurrentItem(SliderLayout.this.currentPage++, true);
            }
        };
        this.flippingTimer = new Timer();
        this.flippingTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                SliderLayout.this.handler.post(Update);
            }
        }, 500L, (long)(this.scrollTimeInSec * 1000));
    }

    @Override
    public void onCurrentPageChanged(int currentPosition) {
        this.currentPage = currentPosition;
    }

    public static enum Animations {
        WORM,
        THIN_WORM,
        COLOR,
        DROP,
        FILL,
        NONE,
        SCALE,
        SCALE_DOWN,
        SLIDE,
        SWAP;

    }
}

