/*
 * Decompiled with CFR 0.152.
 */
package com.smarteist.autoimageslider.IndicatorView.animation.type;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.animation.AccelerateDecelerateInterpolator;
import androidx.annotation.NonNull;
import com.smarteist.autoimageslider.IndicatorView.animation.controller.ValueController;
import com.smarteist.autoimageslider.IndicatorView.animation.data.type.DropAnimationValue;
import com.smarteist.autoimageslider.IndicatorView.animation.type.BaseAnimation;

public class DropAnimation
extends BaseAnimation<AnimatorSet> {
    private int widthStart;
    private int widthEnd;
    private int heightStart;
    private int heightEnd;
    private int radius;
    private DropAnimationValue value = new DropAnimationValue();

    public DropAnimation(@NonNull ValueController.UpdateListener listener) {
        super(listener);
    }

    @Override
    @NonNull
    public AnimatorSet createAnimator() {
        AnimatorSet animator = new AnimatorSet();
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        return animator;
    }

    @Override
    public DropAnimation progress(float progress) {
        if (this.animator != null) {
            long playTimeLeft = (long)(progress * (float)this.animationDuration);
            boolean isReverse = false;
            for (Animator anim : ((AnimatorSet)this.animator).getChildAnimations()) {
                ValueAnimator animator = (ValueAnimator)anim;
                long animDuration = animator.getDuration();
                long currPlayTime = playTimeLeft;
                if (isReverse) {
                    currPlayTime -= animDuration;
                }
                if (currPlayTime < 0L) continue;
                if (currPlayTime >= animDuration) {
                    currPlayTime = animDuration;
                }
                if (animator.getValues() != null && animator.getValues().length > 0) {
                    animator.setCurrentPlayTime(currPlayTime);
                }
                if (isReverse || animDuration < this.animationDuration) continue;
                isReverse = true;
            }
        }
        return this;
    }

    @Override
    public DropAnimation duration(long duration) {
        super.duration(duration);
        return this;
    }

    public DropAnimation with(int widthStart, int widthEnd, int heightStart, int heightEnd, int radius) {
        if (this.hasChanges(widthStart, widthEnd, heightStart, heightEnd, radius)) {
            this.animator = this.createAnimator();
            this.widthStart = widthStart;
            this.widthEnd = widthEnd;
            this.heightStart = heightStart;
            this.heightEnd = heightEnd;
            this.radius = radius;
            int fromRadius = radius;
            int toRadius = (int)((double)radius / 1.5);
            long halfDuration = this.animationDuration / 2L;
            ValueAnimator widthAnimator = this.createValueAnimation(widthStart, widthEnd, this.animationDuration, AnimationType.Width);
            ValueAnimator heightForwardAnimator = this.createValueAnimation(heightStart, heightEnd, halfDuration, AnimationType.Height);
            ValueAnimator radiusForwardAnimator = this.createValueAnimation(fromRadius, toRadius, halfDuration, AnimationType.Radius);
            ValueAnimator heightBackwardAnimator = this.createValueAnimation(heightEnd, heightStart, halfDuration, AnimationType.Height);
            ValueAnimator radiusBackwardAnimator = this.createValueAnimation(toRadius, fromRadius, halfDuration, AnimationType.Radius);
            ((AnimatorSet)this.animator).play((Animator)heightForwardAnimator).with((Animator)radiusForwardAnimator).with((Animator)widthAnimator).before((Animator)heightBackwardAnimator).before((Animator)radiusBackwardAnimator);
        }
        return this;
    }

    private ValueAnimator createValueAnimation(int fromValue, int toValue, long duration, final AnimationType type) {
        ValueAnimator anim = ValueAnimator.ofInt((int[])new int[]{fromValue, toValue});
        anim.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        anim.setDuration(duration);
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                DropAnimation.this.onAnimatorUpdate(animation, type);
            }
        });
        return anim;
    }

    private void onAnimatorUpdate(@NonNull ValueAnimator animation, @NonNull AnimationType type) {
        int frameValue = (Integer)animation.getAnimatedValue();
        switch (type) {
            case Width: {
                this.value.setWidth(frameValue);
                break;
            }
            case Height: {
                this.value.setHeight(frameValue);
                break;
            }
            case Radius: {
                this.value.setRadius(frameValue);
            }
        }
        if (this.listener != null) {
            this.listener.onValueUpdated(this.value);
        }
    }

    private boolean hasChanges(int widthStart, int widthEnd, int heightStart, int heightEnd, int radius) {
        if (this.widthStart != widthStart) {
            return true;
        }
        if (this.widthEnd != widthEnd) {
            return true;
        }
        if (this.heightStart != heightStart) {
            return true;
        }
        if (this.heightEnd != heightEnd) {
            return true;
        }
        return this.radius != radius;
    }

    private static enum AnimationType {
        Width,
        Height,
        Radius;

    }
}

