/*
 * Decompiled with CFR 0.152.
 */
package fr.arnaudguyon.xmltojsonlib;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import fr.arnaudguyon.xmltojsonlib.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XmlToJson {
    private static final String TAG = "XmlToJson";
    private static final String DEFAULT_CONTENT_NAME = "content";
    private static final String DEFAULT_ENCODING = "utf-8";
    private static final String DEFAULT_INDENTATION = "   ";
    private String mIndentationPattern = "   ";
    private static final String DEFAULT_EMPTY_STRING = "";
    private static final int DEFAULT_EMPTY_INTEGER = 0;
    private static final long DEFAULT_EMPTY_LONG = 0L;
    private static final double DEFAULT_EMPTY_DOUBLE = 0.0;
    private static final boolean DEFAULT_EMPTY_BOOLEAN = false;
    private StringReader mStringSource;
    private InputStream mInputStreamSource;
    private String mInputEncoding;
    private HashSet<String> mForceListPaths;
    private HashSet<Pattern> mForceListPatterns = new HashSet();
    private HashMap<String, String> mAttributeNameReplacements;
    private HashMap<String, String> mContentNameReplacements;
    private HashMap<String, Class> mForceClassForPath;
    private HashSet<String> mSkippedAttributes = new HashSet();
    private HashSet<String> mSkippedTags = new HashSet();
    private JSONObject mJsonObject;

    private XmlToJson(Builder builder) {
        this.mStringSource = builder.mStringSource;
        this.mInputStreamSource = builder.mInputStreamSource;
        this.mInputEncoding = builder.mInputEncoding;
        this.mForceListPaths = builder.mForceListPaths;
        this.mForceListPatterns = builder.mForceListPatterns;
        this.mAttributeNameReplacements = builder.mAttributeNameReplacements;
        this.mContentNameReplacements = builder.mContentNameReplacements;
        this.mForceClassForPath = builder.mForceClassForPath;
        this.mSkippedAttributes = builder.mSkippedAttributes;
        this.mSkippedTags = builder.mSkippedTags;
        this.mJsonObject = this.convertToJSONObject();
    }

    @Nullable
    public JSONObject toJson() {
        return this.mJsonObject;
    }

    @Nullable
    private JSONObject convertToJSONObject() {
        try {
            Tag parentTag = new Tag(DEFAULT_EMPTY_STRING, "xml");
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(false);
            XmlPullParser xpp = factory.newPullParser();
            this.setInput(xpp);
            int eventType = xpp.getEventType();
            while (eventType != 0) {
                eventType = xpp.next();
            }
            this.readTags(parentTag, xpp);
            this.unsetInput();
            return this.convertTagToJson(parentTag, false);
        }
        catch (IOException | XmlPullParserException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setInput(XmlPullParser xpp) {
        if (this.mStringSource != null) {
            try {
                xpp.setInput((Reader)this.mStringSource);
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
            }
        } else {
            try {
                xpp.setInput(this.mInputStreamSource, this.mInputEncoding);
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
            }
        }
    }

    private void unsetInput() {
        if (this.mStringSource != null) {
            this.mStringSource.close();
        }
    }

    private void readTags(Tag parent, XmlPullParser xpp) {
        try {
            int eventType;
            do {
                if ((eventType = xpp.next()) == 2) {
                    String tagName = xpp.getName();
                    String path = parent.getPath() + "/" + tagName;
                    boolean skipTag = this.mSkippedTags.contains(path);
                    Tag child = new Tag(path, tagName);
                    if (!skipTag) {
                        parent.addChild(child);
                    }
                    int attrCount = xpp.getAttributeCount();
                    for (int i = 0; i < attrCount; ++i) {
                        String attrName = xpp.getAttributeName(i);
                        String attrValue = xpp.getAttributeValue(i);
                        String attrPath = parent.getPath() + "/" + child.getName() + "/" + attrName;
                        if (this.mSkippedAttributes.contains(attrPath)) continue;
                        attrName = this.getAttributeNameReplacement(attrPath, attrName);
                        Tag attribute = new Tag(attrPath, attrName);
                        attribute.setContent(attrValue);
                        child.addChild(attribute);
                    }
                    this.readTags(child, xpp);
                    continue;
                }
                if (eventType == 4) {
                    String text = xpp.getText();
                    parent.setContent(text);
                    continue;
                }
                if (eventType == 3) {
                    return;
                }
                if (eventType == 1) {
                    return;
                }
                Log.i((String)TAG, (String)("unknown xml eventType " + eventType));
            } while (eventType != 1);
        }
        catch (IOException | NullPointerException | XmlPullParserException e) {
            e.printStackTrace();
        }
    }

    private JSONObject convertTagToJson(Tag tag, boolean isListElement) {
        JSONObject json = new JSONObject();
        if (tag.getContent() != null) {
            String path = tag.getPath();
            String name = this.getContentNameReplacement(path, DEFAULT_CONTENT_NAME);
            this.putContent(path, json, name, tag.getContent());
        }
        try {
            HashMap<String, ArrayList<Tag>> groups = tag.getGroupedElements();
            for (ArrayList<Tag> group : groups.values()) {
                if (group.size() == 1) {
                    Tag child = group.get(0);
                    if (this.isForcedList(child)) {
                        JSONArray list = new JSONArray();
                        list.put((Object)this.convertTagToJson(child, true));
                        String childrenNames = child.getName();
                        json.put(childrenNames, (Object)list);
                        continue;
                    }
                    if (child.hasChildren()) {
                        JSONObject jsonChild = this.convertTagToJson(child, false);
                        json.put(child.getName(), (Object)jsonChild);
                        continue;
                    }
                    String path = child.getPath();
                    this.putContent(path, json, child.getName(), child.getContent());
                    continue;
                }
                JSONArray list = new JSONArray();
                for (Tag child : group) {
                    list.put((Object)this.convertTagToJson(child, true));
                }
                String childrenNames = group.get(0).getName();
                json.put(childrenNames, (Object)list);
            }
            return json;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void putContent(String path, JSONObject json, String tag, String content) {
        try {
            Class forcedClass = this.mForceClassForPath.get(path);
            if (forcedClass == null) {
                if (content == null) {
                    content = DEFAULT_EMPTY_STRING;
                }
                json.put(tag, (Object)content);
            } else if (forcedClass == Integer.class) {
                try {
                    Integer number = Integer.parseInt(content);
                    json.put(tag, (Object)number);
                }
                catch (NumberFormatException exception) {
                    json.put(tag, 0);
                }
            } else if (forcedClass == Long.class) {
                try {
                    Long number = Long.parseLong(content);
                    json.put(tag, (Object)number);
                }
                catch (NumberFormatException exception) {
                    json.put(tag, 0L);
                }
            } else if (forcedClass == Double.class) {
                try {
                    Double number = Double.parseDouble(content);
                    json.put(tag, (Object)number);
                }
                catch (NumberFormatException exception) {
                    json.put(tag, 0.0);
                }
            } else if (forcedClass == Boolean.class) {
                if (content == null) {
                    json.put(tag, false);
                } else if (content.equalsIgnoreCase("true")) {
                    json.put(tag, true);
                } else if (content.equalsIgnoreCase("false")) {
                    json.put(tag, false);
                } else {
                    json.put(tag, false);
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private boolean isForcedList(Tag tag) {
        String path = tag.getPath();
        if (this.mForceListPaths.contains(path)) {
            return true;
        }
        for (Pattern pattern : this.mForceListPatterns) {
            Matcher matcher = pattern.matcher(path);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    private String getAttributeNameReplacement(String path, String defaultValue) {
        String result = this.mAttributeNameReplacements.get(path);
        if (result != null) {
            return result;
        }
        return defaultValue;
    }

    private String getContentNameReplacement(String path, String defaultValue) {
        String result = this.mContentNameReplacements.get(path);
        if (result != null) {
            return result;
        }
        return defaultValue;
    }

    public String toString() {
        if (this.mJsonObject != null) {
            return this.mJsonObject.toString();
        }
        return null;
    }

    public String toFormattedString(@Nullable String indentationPattern) {
        this.mIndentationPattern = indentationPattern == null ? DEFAULT_INDENTATION : indentationPattern;
        return this.toFormattedString();
    }

    public String toFormattedString() {
        if (this.mJsonObject != null) {
            String indent = DEFAULT_EMPTY_STRING;
            StringBuilder builder = new StringBuilder();
            builder.append("{\n");
            this.format(this.mJsonObject, builder, indent);
            builder.append("}\n");
            return builder.toString();
        }
        return null;
    }

    private void format(JSONObject jsonObject, StringBuilder builder, String indent) {
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            builder.append(indent);
            builder.append(this.mIndentationPattern);
            builder.append("\"");
            builder.append(key);
            builder.append("\": ");
            Object value = jsonObject.opt(key);
            if (value instanceof JSONObject) {
                JSONObject child = (JSONObject)value;
                builder.append(indent);
                builder.append("{\n");
                this.format(child, builder, indent + this.mIndentationPattern);
                builder.append(indent);
                builder.append(this.mIndentationPattern);
                builder.append("}");
            } else if (value instanceof JSONArray) {
                JSONArray array = (JSONArray)value;
                this.formatArray(array, builder, indent + this.mIndentationPattern);
            } else {
                this.formatValue(value, builder);
            }
            if (keys.hasNext()) {
                builder.append(",\n");
                continue;
            }
            builder.append("\n");
        }
    }

    private void formatArray(JSONArray array, StringBuilder builder, String indent) {
        builder.append("[\n");
        for (int i = 0; i < array.length(); ++i) {
            JSONObject child;
            Object element = array.opt(i);
            if (element instanceof JSONObject) {
                child = (JSONObject)element;
                builder.append(indent);
                builder.append(this.mIndentationPattern);
                builder.append("{\n");
                this.format(child, builder, indent + this.mIndentationPattern);
                builder.append(indent);
                builder.append(this.mIndentationPattern);
                builder.append("}");
            } else if (element instanceof JSONArray) {
                child = (JSONArray)element;
                this.formatArray((JSONArray)child, builder, indent + this.mIndentationPattern);
            } else {
                this.formatValue(element, builder);
            }
            if (i < array.length() - 1) {
                builder.append(",");
            }
            builder.append("\n");
        }
        builder.append(indent);
        builder.append("]");
    }

    private void formatValue(Object value, StringBuilder builder) {
        if (value instanceof String) {
            String string = (String)value;
            string = string.replaceAll("\\\\", "\\\\\\\\");
            string = string.replaceAll("\"", Matcher.quoteReplacement("\\\""));
            string = string.replaceAll("/", "\\\\/");
            string = string.replaceAll("\n", "\\\\n").replaceAll("\t", "\\\\t");
            string = string.replaceAll("\r", "\\\\r");
            builder.append("\"");
            builder.append(string);
            builder.append("\"");
        } else if (value instanceof Long) {
            Long longValue = (Long)value;
            builder.append(longValue);
        } else if (value instanceof Integer) {
            Integer intValue = (Integer)value;
            builder.append(intValue);
        } else if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            builder.append(bool);
        } else if (value instanceof Double) {
            Double db = (Double)value;
            builder.append(db);
        } else {
            builder.append(value.toString());
        }
    }

    public static class Builder {
        private StringReader mStringSource;
        private InputStream mInputStreamSource;
        private String mInputEncoding = "utf-8";
        private HashSet<String> mForceListPaths = new HashSet();
        private HashSet<Pattern> mForceListPatterns = new HashSet();
        private HashMap<String, String> mAttributeNameReplacements = new HashMap();
        private HashMap<String, String> mContentNameReplacements = new HashMap();
        private HashMap<String, Class> mForceClassForPath = new HashMap();
        private HashSet<String> mSkippedAttributes = new HashSet();
        private HashSet<String> mSkippedTags = new HashSet();

        public Builder(@NonNull String xmlSource) {
            this.mStringSource = new StringReader(xmlSource);
        }

        public Builder(@NonNull InputStream inputStreamSource, @Nullable String inputEncoding) {
            this.mInputStreamSource = inputStreamSource;
            this.mInputEncoding = inputEncoding != null ? inputEncoding : XmlToJson.DEFAULT_ENCODING;
        }

        public Builder forceList(@NonNull String path) {
            this.mForceListPaths.add(path);
            return this;
        }

        public Builder forceListPattern(@NonNull String pattern) {
            Pattern pat = Pattern.compile(pattern, 32);
            this.mForceListPatterns.add(pat);
            return this;
        }

        public Builder setAttributeName(@NonNull String attributePath, @NonNull String replacementName) {
            this.mAttributeNameReplacements.put(attributePath, replacementName);
            return this;
        }

        public Builder setContentName(@NonNull String contentPath, @NonNull String replacementName) {
            this.mContentNameReplacements.put(contentPath, replacementName);
            return this;
        }

        public Builder forceIntegerForPath(@NonNull String path) {
            this.mForceClassForPath.put(path, Integer.class);
            return this;
        }

        public Builder forceLongForPath(@NonNull String path) {
            this.mForceClassForPath.put(path, Long.class);
            return this;
        }

        public Builder forceDoubleForPath(@NonNull String path) {
            this.mForceClassForPath.put(path, Double.class);
            return this;
        }

        public Builder forceBooleanForPath(@NonNull String path) {
            this.mForceClassForPath.put(path, Boolean.class);
            return this;
        }

        public Builder skipTag(@NonNull String path) {
            this.mSkippedTags.add(path);
            return this;
        }

        public Builder skipAttribute(@NonNull String path) {
            this.mSkippedAttributes.add(path);
            return this;
        }

        public XmlToJson build() {
            return new XmlToJson(this);
        }
    }
}

