/*
 * Decompiled with CFR 0.152.
 */
package fr.arnaudguyon.xmltojsonlib;

import android.util.Xml;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import fr.arnaudguyon.xmltojsonlib.FileReader;
import fr.arnaudguyon.xmltojsonlib.Node;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlSerializer;

public class JsonToXml {
    private static final int DEFAULT_INDENTATION = 3;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    private JSONObject mJson;
    private HashSet<String> mForcedAttributes;
    private HashSet<String> mForcedContent;

    private JsonToXml(@NonNull JSONObject jsonObject, @NonNull HashSet<String> forcedAttributes, HashSet<String> forcedContent) {
        this.mJson = jsonObject;
        this.mForcedAttributes = forcedAttributes;
        this.mForcedContent = forcedContent;
    }

    public String toString() {
        Node rootNode = new Node(null, "");
        this.prepareObject(rootNode, this.mJson);
        return this.nodeToXML(rootNode);
    }

    public String toFormattedString() {
        return this.toFormattedString(3);
    }

    public String toFormattedString(@IntRange(from=0L) int indent) {
        String input = this.toString();
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(input));
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "" + indent);
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String nodeToXML(Node node) {
        XmlSerializer serializer = Xml.newSerializer();
        StringWriter writer = new StringWriter();
        try {
            serializer.setOutput((Writer)writer);
            serializer.startDocument("UTF-8", Boolean.valueOf(true));
            this.nodeToXml(serializer, node);
            serializer.endDocument();
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void nodeToXml(XmlSerializer serializer, Node node) throws IOException {
        String nodeName = node.getName();
        if (nodeName != null) {
            serializer.startTag("", nodeName);
            for (Node.Attribute attribute : node.getAttributes()) {
                serializer.attribute("", attribute.mKey, attribute.mValue);
            }
            String nodeContent = node.getContent();
            if (nodeContent != null) {
                serializer.text(nodeContent);
            }
        }
        for (Node subNode : node.getChildren()) {
            this.nodeToXml(serializer, subNode);
        }
        if (nodeName != null) {
            serializer.endTag("", nodeName);
        }
    }

    private void prepareObject(Node node, JSONObject json) {
        Iterator keyterator = json.keys();
        while (keyterator.hasNext()) {
            String value;
            String key = (String)keyterator.next();
            Object object = json.opt(key);
            if (object == null) continue;
            if (object instanceof JSONObject) {
                JSONObject subObject = (JSONObject)object;
                String path = node.getPath() + "/" + key;
                Node subNode = new Node(key, path);
                node.addChild(subNode);
                this.prepareObject(subNode, subObject);
                continue;
            }
            if (object instanceof JSONArray) {
                JSONArray array = (JSONArray)object;
                this.prepareArray(node, key, array);
                continue;
            }
            String path = node.getPath() + "/" + key;
            if (object instanceof Double) {
                double d = (Double)object;
                if (d % 1.0 == 0.0) {
                    value = Long.toString((long)d);
                } else {
                    if (DECIMAL_FORMAT.getMaximumFractionDigits() == 0) {
                        DECIMAL_FORMAT.setMaximumFractionDigits(20);
                    }
                    value = DECIMAL_FORMAT.format(d);
                }
            } else {
                value = object.toString();
            }
            if (this.isAttribute(path)) {
                node.addAttribute(key, value);
                continue;
            }
            if (this.isContent(path)) {
                node.setContent(value);
                continue;
            }
            Node subNode = new Node(key, node.getPath());
            subNode.setContent(value);
            node.addChild(subNode);
        }
    }

    private void prepareArray(Node node, String key, JSONArray array) {
        int count = array.length();
        String path = node.getPath() + "/" + key;
        for (int i = 0; i < count; ++i) {
            Node subNode = new Node(key, path);
            Object object = array.opt(i);
            if (object != null) {
                if (object instanceof JSONObject) {
                    JSONObject jsonObject = (JSONObject)object;
                    this.prepareObject(subNode, jsonObject);
                } else if (object instanceof JSONArray) {
                    JSONArray subArray = (JSONArray)object;
                    this.prepareArray(subNode, key, subArray);
                } else {
                    String value = object.toString();
                    subNode.setName(key);
                    subNode.setContent(value);
                }
            }
            node.addChild(subNode);
        }
    }

    private boolean isAttribute(String path) {
        return this.mForcedAttributes.contains(path);
    }

    private boolean isContent(String path) {
        return this.mForcedContent.contains(path);
    }

    public static class Builder {
        private JSONObject mJson;
        private HashSet<String> mForcedAttributes = new HashSet();
        private HashSet<String> mForcedContent = new HashSet();

        public Builder(@NonNull JSONObject jsonObject) {
            this.mJson = jsonObject;
        }

        public Builder(@NonNull InputStream inputStream) {
            this(FileReader.readFileFromInputStream(inputStream));
        }

        public Builder(String jsonString) {
            try {
                this.mJson = new JSONObject(jsonString);
            }
            catch (JSONException exception) {
                exception.printStackTrace();
            }
        }

        public Builder forceAttribute(String path) {
            this.mForcedAttributes.add(path);
            return this;
        }

        public Builder forceContent(String path) {
            this.mForcedContent.add(path);
            return this;
        }

        public JsonToXml build() {
            return new JsonToXml(this.mJson, this.mForcedAttributes, this.mForcedContent);
        }
    }
}

