/*
 * Decompiled with CFR 0.152.
 */
package fr.arnaudguyon.tabstacker;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.View;
import fr.arnaudguyon.tabstacker.AnimationSet;
import fr.arnaudguyon.tabstacker.TabStacker;
import fr.arnaudguyon.tabstacker.ViewData;

class FragmentInfo {
    private static final String BUNDLE_FRAGMENT_CLASS = "fragment_class";
    private static final String BUNDLE_FRAGMENT_ARGUMENTS = "fragment_arguments";
    private static final String BUNDLE_FRAGMENT_DATA = "fragment_data";
    private static final String BUNDLE_VIEW_HIERARCHY = "ViewHierarchy";
    private static final String BUNDLE_TYPE = "type";
    private static final String BUNDLE_ANIMATION = "animation";
    Fragment mFragment;
    AnimationSet mAnimationSet;
    TabStacker.Type mType;
    private Bundle mSavedView;

    FragmentInfo(Fragment fragment, AnimationSet animationSet, TabStacker.Type type) {
        this.mFragment = fragment;
        this.mAnimationSet = animationSet;
        this.mType = type;
    }

    static FragmentInfo restoreInstance(Bundle bundle) {
        String className = bundle.getString(BUNDLE_FRAGMENT_CLASS);
        try {
            Class<?> fragmentClass = Class.forName(className);
            Fragment fragment = (Fragment)fragmentClass.newInstance();
            Bundle arguments = bundle.getBundle(BUNDLE_FRAGMENT_ARGUMENTS);
            fragment.setArguments(arguments);
            Bundle fragmentData = bundle.getBundle(BUNDLE_FRAGMENT_DATA);
            if (fragmentData != null && fragment instanceof TabStacker.TabStackInterface) {
                ((TabStacker.TabStackInterface)fragment).onRestoreTabFragmentInstance(fragmentData);
            }
            TabStacker.Type type = TabStacker.Type.valueOf(bundle.getString(BUNDLE_TYPE));
            Bundle animation = bundle.getBundle(BUNDLE_ANIMATION);
            AnimationSet animationSet = AnimationSet.restoreInstance(animation);
            FragmentInfo fragmentInfo = new FragmentInfo(fragment, animationSet, type);
            fragmentInfo.mSavedView = bundle.getBundle(BUNDLE_VIEW_HIERARCHY);
            return fragmentInfo;
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (InstantiationException e2) {
            e2.printStackTrace();
        }
        catch (IllegalAccessException e3) {
            e3.printStackTrace();
        }
        return null;
    }

    Bundle saveInstance() {
        Bundle bundle = new Bundle();
        String fragmentClassName = this.mFragment.getClass().getName();
        bundle.putString(BUNDLE_FRAGMENT_CLASS, fragmentClassName);
        Bundle fragmentArguments = this.mFragment.getArguments();
        bundle.putBundle(BUNDLE_FRAGMENT_ARGUMENTS, fragmentArguments);
        if (this.mFragment instanceof TabStacker.TabStackInterface) {
            Bundle fragmentData = new Bundle();
            View fragmentView = ((TabStacker.TabStackInterface)this.mFragment).onSaveTabFragmentInstance(fragmentData);
            bundle.putBundle(BUNDLE_FRAGMENT_DATA, fragmentData);
            if (fragmentView != null) {
                Bundle viewHierarchy = ViewData.saveViewHierarchy(fragmentView);
                bundle.putBundle(BUNDLE_VIEW_HIERARCHY, viewHierarchy);
            } else if (this.mSavedView != null) {
                bundle.putBundle(BUNDLE_VIEW_HIERARCHY, this.mSavedView);
            }
        }
        String type = this.mType.name();
        bundle.putString(BUNDLE_TYPE, type);
        Bundle animation = this.mAnimationSet != null ? this.mAnimationSet.saveInstance() : null;
        bundle.putBundle(BUNDLE_ANIMATION, animation);
        return bundle;
    }

    void restoreView(View fragmentView) {
        ViewData.restoreView(this.mSavedView, fragmentView);
    }
}

