/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import com.iwombat.foundation.IdentifierFactory;
import com.iwombat.util.GUIDUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import ndr.NdrException;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JIComVersion;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIMarshalUnMarshalHelper;
import org.jinterop.dcom.core.JIOrpcExtentArray;
import org.jinterop.dcom.core.JIPointer;
import org.jinterop.dcom.core.JIStruct;
import rpc.core.UUID;

final class JIOrpcThis
implements Serializable {
    private static final long serialVersionUID = 9148006530957254901L;
    private static ThreadLocal cidForCallback = new ThreadLocal();
    private int flags = 0;
    private JIOrpcExtentArray[] arry = null;
    private JIComVersion version = JISystem.getCOMVersion();
    private String cid = null;

    JIOrpcThis() {
        this.cid = GUIDUtil.guidStringFromHexString((String)IdentifierFactory.createUniqueIdentifier().toHexString());
    }

    JIOrpcThis(UUID casualityIdentifier) {
        this.cid = casualityIdentifier.toString();
    }

    public void setORPCFlags(int flags) {
        this.flags = flags;
    }

    public int getORPCFlags() {
        return this.flags;
    }

    public void setExtentArray(JIOrpcExtentArray[] arry) {
        this.arry = arry;
    }

    public JIOrpcExtentArray[] getExtentArray() {
        return this.arry;
    }

    public String getCasualityIdentifier() {
        return this.cid;
    }

    public void encode(NetworkDataRepresentation ndr) {
        ndr.writeUnsignedShort(this.version.getMajorVersion());
        ndr.writeUnsignedShort(this.version.getMinorVersion());
        ndr.writeUnsignedLong(this.flags);
        ndr.writeUnsignedLong(0);
        String cid2 = cidForCallback.get() == null ? this.cid : (String)cidForCallback.get();
        UUID uuid = new UUID(cid2);
        try {
            uuid.encode(ndr, ndr.getBuffer());
        }
        catch (NdrException e) {
            JISystem.getLogger().throwing("JIOrpcThis", "encode", e);
        }
        if (this.arry != null && this.arry.length != 0) {
            ndr.writeUnsignedLong(this.arry.length);
            ndr.writeUnsignedLong(0);
            for (int i = 0; i < this.arry.length; ++i) {
                JIOrpcExtentArray arryy = this.arry[i];
                uuid = new UUID(arryy.getGUID());
                try {
                    uuid.encode(ndr, ndr.getBuffer());
                }
                catch (NdrException e) {
                    JISystem.getLogger().throwing("JIOrpcThis", "encode", e);
                }
                ndr.writeUnsignedLong(arryy.getSizeOfData());
                ndr.writeOctetArray(arryy.getData(), 0, arryy.getSizeOfData());
            }
        } else {
            ndr.writeUnsignedLong(0);
        }
    }

    static JIOrpcThis decode(NetworkDataRepresentation ndr) {
        JIOrpcThis retval = new JIOrpcThis();
        HashMap map = new HashMap();
        int majorVersion = ((Number)JIMarshalUnMarshalHelper.deSerialize(ndr, Short.class, null, 0, map)).intValue();
        int minorVersion = ((Number)JIMarshalUnMarshalHelper.deSerialize(ndr, Short.class, null, 0, map)).intValue();
        retval.version = new JIComVersion(majorVersion, minorVersion);
        retval.flags = ((Number)JIMarshalUnMarshalHelper.deSerialize(ndr, Integer.class, null, 0, map)).intValue();
        JIMarshalUnMarshalHelper.deSerialize(ndr, Integer.class, null, 0, map);
        UUID uuid = new UUID();
        try {
            uuid.decode(ndr, ndr.getBuffer());
            retval.cid = uuid.toString();
        }
        catch (NdrException e) {
            JISystem.getLogger().throwing("JIOrpcThis", "decode", e);
        }
        JIStruct orpcextentarray = new JIStruct();
        try {
            JIStruct orpcextent = new JIStruct();
            orpcextent.addMember(UUID.class);
            orpcextent.addMember(Integer.class);
            orpcextent.addMember(new JIArray(Byte.class, null, 1, true));
            orpcextentarray.addMember(Integer.class);
            orpcextentarray.addMember(Integer.class);
            orpcextentarray.addMember(new JIPointer(new JIArray(new JIPointer(orpcextent), null, 1, true)));
        }
        catch (JIException orpcextent) {
            // empty catch block
        }
        ArrayList<JIPointer> listOfDefferedPointers = new ArrayList<JIPointer>();
        JIPointer orpcextentarrayptr = (JIPointer)JIMarshalUnMarshalHelper.deSerialize(ndr, new JIPointer(orpcextentarray), listOfDefferedPointers, 0, map);
        int x = 0;
        while (x < listOfDefferedPointers.size()) {
            ArrayList<JIPointer> newList = new ArrayList<JIPointer>();
            JIPointer replacement = (JIPointer)JIMarshalUnMarshalHelper.deSerialize(ndr, listOfDefferedPointers.get(x), newList, 0, map);
            ((JIPointer)listOfDefferedPointers.get(x)).replaceSelfWithNewPointer(replacement);
            listOfDefferedPointers.addAll(++x, newList);
        }
        ArrayList<JIOrpcExtentArray> extentArrays = new ArrayList<JIOrpcExtentArray>();
        if (!orpcextentarrayptr.isNull()) {
            JIPointer[] pointers = (JIPointer[])((JIArray)((JIPointer)((JIStruct)orpcextentarrayptr.getReferent()).getMember(2)).getReferent()).getArrayInstance();
            for (int i = 0; i < pointers.length; ++i) {
                if (pointers[i].isNull()) continue;
                JIStruct orpcextent2 = (JIStruct)pointers[i].getReferent();
                Byte[] byteArray = (Byte[])((JIArray)orpcextent2.getMember(2)).getArrayInstance();
                extentArrays.add(new JIOrpcExtentArray(orpcextent2.getMember(0).toString(), byteArray.length, byteArray));
            }
        }
        retval.arry = extentArrays.toArray(new JIOrpcExtentArray[extentArrays.size()]);
        cidForCallback.set(retval.cid);
        return retval;
    }
}

