/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import ndr.NdrBuffer;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JICallBuilder;
import org.jinterop.dcom.core.JIComObjectImpl;
import org.jinterop.dcom.core.JIComOxidRuntime;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIInterfacePointer;
import org.jinterop.dcom.core.JILocalCoClass;
import org.jinterop.dcom.core.JIOxid;
import org.jinterop.dcom.core.JIPointer;
import org.jinterop.dcom.core.JISession;

public final class JIFrameworkHelper {
    static void link2Sessions(JISession src, JISession target) {
        if (src == null || target == null) {
            throw new NullPointerException();
        }
        JISession.linkTwoSessions(src, target);
    }

    static void unLinkSession(JISession src, JISession unlinkedSession) {
        if (src == null || unlinkedSession == null) {
            throw new NullPointerException();
        }
        JISession.unLinkSession(src, unlinkedSession);
    }

    static JISession resolveSessionForOXID(byte[] oxid) {
        return JISession.resolveSessionForOxid(new JIOxid(oxid));
    }

    static JIInterfacePointer getInterfacePointerOfStub(JISession session) {
        return session.getStub().getServerInterfacePointer();
    }

    static IJIComObject instantiateComObject(JISession session, JIInterfacePointer ptr) throws JIException {
        IJIComObject retval = JIFrameworkHelper.instantiateComObject2(session, ptr);
        JIFrameworkHelper.addComObjectToSession(retval.getAssociatedSession(), retval);
        return retval;
    }

    static IJIComObject instantiateComObject2(JISession session, JIInterfacePointer ptr) throws JIException {
        if (ptr == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4113));
        }
        IJIComObject retval = null;
        JIInterfacePointer stubPtr = JIFrameworkHelper.getInterfacePointerOfStub(session);
        if (!JIInterfacePointer.isOxidEqual(stubPtr, ptr)) {
            JISession newsession;
            if (JISystem.getLogger().isLoggable(Level.WARNING)) {
                JISystem.getLogger().log(Level.WARNING, "NEW SESSION IDENTIFIED ! for ptr {0}", ptr);
            }
            if ((newsession = JIFrameworkHelper.resolveSessionForOXID(ptr.getOXID())) == null) {
                newsession = JISession.createSession(session);
                newsession.setGlobalSocketTimeout(session.getGlobalSocketTimeout());
                newsession.useSessionSecurity(session.isSessionSecurityEnabled());
                newsession.useNTLMv2(session.isNTLMv2Enabled());
                JIComServer comServer = new JIComServer(newsession, ptr, null);
                retval = comServer.getInstance();
                JIFrameworkHelper.link2Sessions(session, newsession);
            }
            session = newsession;
        }
        if (retval == null) {
            retval = new JIComObjectImpl(session, ptr);
        }
        return retval;
    }

    static void addComObjectToSession(JISession session, IJIComObject comObject) {
        session.addToSession(comObject, comObject.internal_getInterfacePointer().getOID());
    }

    public static IJIComObject instantiateLocalComObject(JISession session, JILocalCoClass javaComponent) throws JIException {
        return new JIComObjectImpl(session, JIComOxidRuntime.getInterfacePointer(session, javaComponent), true);
    }

    public static IJIComObject instantiateComObject(JISession session, byte[] rawBytes, String ipAddress) throws JIException {
        NetworkDataRepresentation ndr = new NetworkDataRepresentation();
        NdrBuffer ndrBuffer = new NdrBuffer(rawBytes, 0);
        ndr.setBuffer(ndrBuffer);
        ndrBuffer.length = rawBytes.length;
        if (session.getStub() == null) {
            JIComServer comServer = new JIComServer(session, JIInterfacePointer.decode(ndr, new ArrayList<JIPointer>(), 32768, new HashMap()), ipAddress);
            return comServer.getInstance();
        }
        IJIComObject retval = JIFrameworkHelper.instantiateComObject(session, JIInterfacePointer.decode(ndr, new ArrayList<JIPointer>(), 32768, new HashMap()));
        retval.addRef();
        return retval;
    }

    public static IJIComObject instantiateComObject(JISession session, IJIComObject comObject) throws JIException {
        if (comObject.getAssociatedSession() != null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4168));
        }
        if (comObject.isLocalReference()) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4169));
        }
        return JIFrameworkHelper.instantiateComObject(session, comObject.internal_getInterfacePointer());
    }

    public static void detachEventHandler(IJIComObject comObject, String identifier) throws JIException {
        Object[] connectionInfo = comObject.internal_getConnectionInfo(identifier);
        if (connectionInfo == null) {
            throw new JIException(4146);
        }
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().log(Level.INFO, "Detaching event handler for  comObject: {0} , identifier: {1}", new Object[]{comObject.getInterfaceIdentifier(), identifier});
        }
        IJIComObject connectionPointer = (IJIComObject)connectionInfo[0];
        JICallBuilder object = new JICallBuilder(true);
        object.setOpnum(3);
        object.addInParamAsInt(((Number)connectionInfo[1]).intValue(), 0);
        connectionPointer.call(object);
        connectionPointer.release();
    }

    public static String attachEventHandler(IJIComObject comObject, String sourceUUID, IJIComObject eventListener) throws JIException {
        if (eventListener == null || comObject == null || sourceUUID == null || sourceUUID.isEmpty()) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4152));
        }
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().log(Level.INFO, "Attaching event handler for  comObject: {0} , sourceUUID: {1} , eventListener: {2} and eventListner IPID: {3}", new Object[]{comObject.getInterfaceIdentifier(), sourceUUID, eventListener.getInterfaceIdentifier(), eventListener.getIpid()});
        }
        IJIComObject connectionPointContainer = comObject.queryInterface("B196B284-BAB4-101A-B69C-00AA00341D07");
        JICallBuilder object = new JICallBuilder(true);
        object.setOpnum(1);
        object.addInParamAsUUID(sourceUUID, 0);
        object.addOutParamAsObject(IJIComObject.class, 0);
        Object[] objects = connectionPointContainer.call(object);
        IJIComObject connectionPointer = (IJIComObject)objects[0];
        object.reInit();
        object.setOpnum(2);
        object.addInParamAsComObject(eventListener, 0);
        object.addOutParamAsType(Integer.class, 0);
        Object[] obj = connectionPointer.call(object);
        Integer dwcookie = (Integer)obj[0];
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().log(Level.INFO, "Event handler returned cookie {0}", dwcookie);
        }
        connectionPointContainer.release();
        return comObject.internal_setConnectionInfo(connectionPointer, dwcookie);
    }

    public static int reverseArrayForDispatch(JIArray arrayToReverse) {
        return arrayToReverse.reverseArrayForDispatch();
    }

    private JIFrameworkHelper() {
    }
}

