/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbException;
import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.JIComOxidRuntime;
import org.jinterop.dcom.core.OxidResolverImpl;
import org.jinterop.dcom.core.RemUnknownObject;
import org.jinterop.dcom.transport.JIComRuntimeEndpoint;
import org.jinterop.dcom.transport.JIComRuntimeTransportFactory;
import rpc.Stub;
import rpc.TransportFactory;

final class JIComOxidRuntimeHelper
extends Stub {
    JIComOxidRuntimeHelper(Properties properties) {
        super.setTransportFactory((TransportFactory)JIComRuntimeTransportFactory.getSingleTon());
        super.setProperties(properties);
        super.setAddress("127.0.0.1[135]");
    }

    protected String getSyntax() {
        return "00000000-0000-0000-0000-000000000000:0.0";
    }

    void startOxid(int portNumLocal, int portNumRemote) throws IOException {
        Thread oxidResolverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (JISystem.getLogger().isLoggable(Level.INFO)) {
                        JISystem.getLogger().log(Level.INFO, "started startOxid thread: {0}", Thread.currentThread().getName());
                    }
                    JIComOxidRuntimeHelper.this.attach();
                    ((JIComRuntimeEndpoint)JIComOxidRuntimeHelper.this.getEndpoint()).processRequests(new OxidResolverImpl(JIComOxidRuntimeHelper.this.getProperties()), null, new ArrayList<String>());
                }
                catch (IOException e) {
                    if (JISystem.getLogger().isLoggable(Level.WARNING)) {
                        JISystem.getLogger().throwing("Oxid Resolver Thread", "run", e);
                        JISystem.getLogger().log(Level.WARNING, "Oxid Resolver Thread: {0} , on thread Id: {1}", new Object[]{e.getMessage(), Thread.currentThread().getName()});
                    }
                }
                finally {
                    try {
                        JIComOxidRuntimeHelper.this.getEndpoint().detach();
                    }
                    catch (IOException iOException) {}
                }
                if (JISystem.getLogger().isLoggable(Level.INFO)) {
                    JISystem.getLogger().log(Level.INFO, "terminating startOxid thread: {0}", Thread.currentThread().getName());
                }
            }
        }, "jI_OxidResolver_Client[" + portNumLocal + " , " + portNumRemote + "]");
        oxidResolverThread.setDaemon(true);
        oxidResolverThread.start();
    }

    Object[] startRemUnknown(final String baseIID, final String ipidOfRemUnknown, final String ipidOfComponent, final List<String> listOfSupportedInterfaces) throws IOException {
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        final ServerSocket serverSocket = serverSocketChannel.socket();
        serverSocket.bind(null);
        int remUnknownPort = serverSocket.getLocalPort();
        final ThreadGroup remUnknownForThisListener = new ThreadGroup("ThreadGroup - " + baseIID + "[" + ipidOfRemUnknown + "]");
        remUnknownForThisListener.setDaemon(true);
        Thread remUnknownThread = new Thread(remUnknownForThisListener, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block12: {
                    if (JISystem.getLogger().isLoggable(Level.INFO)) {
                        JISystem.getLogger().log(Level.INFO, "started RemUnknown listener thread for : {0}", Thread.currentThread().getName());
                    }
                    try {
                        while (true) {
                            Socket socket = serverSocket.accept();
                            if (JISystem.getLogger().isLoggable(Level.INFO)) {
                                JISystem.getLogger().log(Level.INFO, "RemUnknown listener: Got Connection from {0}", socket.getPort());
                            }
                            final JIComOxidRuntimeHelper remUnknownHelper = new JIComOxidRuntimeHelper(JIComOxidRuntimeHelper.this.getProperties());
                            Object object = JIComOxidRuntime.mutex;
                            synchronized (object) {
                                JISystem.internal_setSocket(socket);
                                remUnknownHelper.attach();
                            }
                            Thread remUnknown = new Thread(remUnknownForThisListener, new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        ((JIComRuntimeEndpoint)remUnknownHelper.getEndpoint()).processRequests(new RemUnknownObject(ipidOfRemUnknown, ipidOfComponent), baseIID, listOfSupportedInterfaces);
                                    }
                                    catch (SmbAuthException e) {
                                        JISystem.getLogger().log(Level.WARNING, "JIComOxidRuntimeHelper RemUnknownThread (not listener)", e);
                                        throw new JIRuntimeException(4127);
                                    }
                                    catch (SmbException e) {
                                        JISystem.getLogger().log(Level.WARNING, "JIComOxidRuntimeHelper RemUnknownThread (not listener)", e);
                                        throw new JIRuntimeException(4128);
                                    }
                                    catch (ClosedByInterruptException e) {
                                        JISystem.getLogger().log(Level.INFO, "JIComOxidRuntimeHelper RemUnknownThread (not listener){0} is purposefully closed by interruption.", Thread.currentThread().getName());
                                    }
                                    catch (IOException e) {
                                        JISystem.getLogger().log(Level.WARNING, "JIComOxidRuntimeHelper RemUnknownThread (not listener)", e);
                                    }
                                    finally {
                                        try {
                                            remUnknownHelper.detach();
                                        }
                                        catch (IOException e) {}
                                    }
                                }
                            }, "jI_RemUnknown[" + baseIID + " , L(" + socket.getLocalPort() + "):R(" + socket.getPort() + ")]");
                            remUnknown.setDaemon(true);
                            remUnknown.start();
                        }
                    }
                    catch (ClosedByInterruptException e) {
                        JISystem.getLogger().log(Level.INFO, "JIComOxidRuntimeHelper RemUnknownListener{0} is purposefully closed by interruption.", Thread.currentThread().getName());
                    }
                    catch (IOException e) {
                        if (JISystem.getLogger().isLoggable(Level.WARNING)) {
                            JISystem.getLogger().log(Level.WARNING, "JIComOxidRuntimeHelper RemUnknownListener", e);
                            JISystem.getLogger().log(Level.WARNING, "RemUnknownListener Thread: {0} , on thread Id: {1}", new Object[]{e.getMessage(), Thread.currentThread().getName()});
                        }
                    }
                    catch (Throwable e) {
                        if (!JISystem.getLogger().isLoggable(Level.WARNING)) break block12;
                        JISystem.getLogger().log(Level.WARNING, "JIComOxidRuntimeHelper RemUnknownListener", e);
                    }
                }
                if (JISystem.getLogger().isLoggable(Level.INFO)) {
                    JISystem.getLogger().log(Level.INFO, "terminating RemUnknownListener thread: {0}", Thread.currentThread().getName());
                }
            }
        }, "jI_RemUnknownListener[" + baseIID + " , " + remUnknownPort + "]");
        remUnknownThread.setDaemon(true);
        remUnknownThread.start();
        return new Object[]{remUnknownPort, remUnknownForThisListener};
    }
}

