/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.transport;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import jcifs.util.Hexdump;
import ndr.NdrBuffer;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.IJICOMRuntimeWorker;
import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.transport.JIComRuntimeNTLMConnectionContext;
import rpc.ConnectionOrientedEndpoint;
import rpc.ConnectionOrientedPdu;
import rpc.FaultException;
import rpc.RpcException;
import rpc.Transport;
import rpc.core.PresentationContext;
import rpc.core.PresentationResult;
import rpc.core.PresentationSyntax;
import rpc.core.UUID;
import rpc.pdu.AlterContextPdu;
import rpc.pdu.AlterContextResponsePdu;
import rpc.pdu.Auth3Pdu;
import rpc.pdu.BindAcknowledgePdu;
import rpc.pdu.BindPdu;
import rpc.pdu.FaultCoPdu;
import rpc.pdu.RequestCoPdu;
import rpc.pdu.ResponseCoPdu;
import rpc.pdu.ShutdownPdu;

public final class JIComRuntimeEndpoint
extends ConnectionOrientedEndpoint {
    JIComRuntimeEndpoint(Transport transport, PresentationSyntax syntax) {
        super(transport, syntax);
    }

    public void call(int semantics, UUID object, int opnum, NdrObject ndrobj) throws IOException {
        throw new JIRuntimeException(4121);
    }

    public void processRequests(IJICOMRuntimeWorker workerObject, String baseIID, List listOfSupportedInterfaces) throws IOException {
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().info("processRequests: [JIComRuntimeEndPoint] started new thread " + Thread.currentThread().getName());
        }
        if (baseIID != null) {
            this.getTransport().getProperties().setProperty("IID2", baseIID);
        }
        this.getTransport().getProperties().put("LISTOFSUPPORTEDINTERFACES", listOfSupportedInterfaces);
        this.bind();
        while (true) {
            ConnectionOrientedPdu response = null;
            ConnectionOrientedPdu request = this.receive();
            if (!workerObject.isResolver()) {
                boolean bl = false;
            }
            if (JISystem.getLogger().isLoggable(Level.INFO)) {
                JISystem.getLogger().info("processRequests: [JIComRuntimeEndPoint] request : " + Thread.currentThread().getName() + " , " + request + " workerObject is resolver: " + workerObject.isResolver());
            }
            NdrBuffer buffer = null;
            NetworkDataRepresentation ndr = new NetworkDataRepresentation();
            workerObject.setCurrentIID(this.currentIID);
            if (request instanceof RequestCoPdu) {
                buffer = new NdrBuffer(((RequestCoPdu)request).getStub(), 0);
                if (buffer.buf != null && JISystem.getLogger().isLoggable(Level.FINEST)) {
                    JISystem.getLogger().finest("\n" + Hexdump.toHexString((byte[])buffer.buf));
                }
                ndr.setFormat(request.getFormat());
                workerObject.setOpnum(request.getOpnum());
                workerObject.setCurrentObjectID(((RequestCoPdu)request).getObject());
                try {
                    ((NdrObject)workerObject).decode(ndr, buffer);
                    ResponseCoPdu responseCoPdu = new ResponseCoPdu();
                    responseCoPdu.setContextId(((RequestCoPdu)request).getContextId());
                    responseCoPdu.setFormat(request.getFormat());
                    responseCoPdu.setCallId(request.getCallId());
                    ((NdrObject)workerObject).encode(ndr, null);
                    int length = ndr.getBuffer().length > ndr.getBuffer().index ? ndr.getBuffer().length : ndr.getBuffer().index;
                    responseCoPdu.setAllocationHint(length + 4);
                    byte[] responsebytes = new byte[length + 4];
                    System.arraycopy(ndr.getBuffer().getBuffer(), 0, responsebytes, 0, responsebytes.length - 4);
                    responseCoPdu.setStub(responsebytes);
                    response = responseCoPdu;
                }
                catch (JIRuntimeException e) {
                    JISystem.getLogger().throwing("JIComRuntimeEndpoint", "processRequests", e);
                    response = new FaultCoPdu();
                    response.setCallId(request.getCallId());
                    ((FaultCoPdu)response).setStatus(e.getHResult());
                }
            } else if (request instanceof BindPdu || request instanceof AlterContextPdu) {
                if (!workerObject.isResolver()) {
                    if (this.context instanceof JIComRuntimeNTLMConnectionContext) {
                        ((JIComRuntimeNTLMConnectionContext)this.context).updateListOfInterfacesSupported(workerObject.getQIedIIDs());
                    }
                    switch (request.getType()) {
                        case 11: {
                            this.currentIID = ((BindPdu)request).getContextList()[0].abstractSyntax.getUuid().toString();
                            break;
                        }
                        case 14: {
                            this.currentIID = ((AlterContextPdu)request).getContextList()[0].abstractSyntax.getUuid().toString();
                            break;
                        }
                    }
                }
                response = this.context.accept(request);
                if (!workerObject.isResolver()) {
                    PresentationResult[] result = null;
                    PresentationContext context = null;
                    boolean successful = false;
                    if (response instanceof BindAcknowledgePdu) {
                        result = ((BindAcknowledgePdu)response).getResultList();
                        successful = result[0].result == 0;
                        context = ((BindPdu)request).getContextList()[0];
                    } else {
                        result = ((AlterContextResponsePdu)response).getResultList();
                        successful = result[0].result == 0;
                        context = ((AlterContextPdu)request).getContextList()[0];
                    }
                }
            } else {
                if (request instanceof FaultCoPdu) {
                    FaultCoPdu fault = (FaultCoPdu)request;
                    throw new FaultException("Received fault.", fault.getStatus(), fault.getStub());
                }
                if (request instanceof ShutdownPdu) {
                    throw new RpcException("Received shutdown request from server.");
                }
                if (request instanceof Auth3Pdu) continue;
            }
            if (JISystem.getLogger().isLoggable(Level.INFO)) {
                JISystem.getLogger().info("processRequests: [JIComRuntimeEndPoint] response : " + Thread.currentThread().getName() + " , " + response);
            }
            this.send(response);
            if (workerObject.workerOver()) break;
        }
        JISystem.getLogger().info("processRequests: [JIComRuntimeEndPoint] Worker is over, all IPID references have been released. Thread " + Thread.currentThread().getName() + " will now exit.");
    }
}

