/*
 * Decompiled with CFR 0.152.
 */
package rpc.pdu;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import ndr.NdrBuffer;
import ndr.NdrException;
import ndr.NetworkDataRepresentation;
import rpc.ConnectionOrientedPdu;
import rpc.Fragmentable;
import rpc.core.UUID;

public class RequestCoPdu
extends ConnectionOrientedPdu
implements Fragmentable {
    public static final int REQUEST_TYPE = 0;
    private byte[] stub;
    private int allocationHint = 0;
    private int contextId = 0;
    private int opnum = 0;
    private UUID object;
    private static final Logger logger = Logger.getLogger("org.jinterop");

    @Override
    public int getType() {
        return 0;
    }

    public byte[] getStub() {
        return this.stub;
    }

    public void setStub(byte[] stub) {
        this.stub = stub;
    }

    public int getAllocationHint() {
        return this.allocationHint;
    }

    public void setAllocationHint(int allocationHint) {
        this.allocationHint = allocationHint;
    }

    public int getContextId() {
        return this.contextId;
    }

    public void setContextId(int contextId) {
        this.contextId = contextId;
    }

    @Override
    public int getOpnum() {
        return this.opnum;
    }

    public void setOpnum(int opnum) {
        this.opnum = opnum;
    }

    public UUID getObject() {
        return this.object;
    }

    public void setObject(UUID object) {
        this.object = object;
        this.setFlag(128, object != null);
    }

    @Override
    protected void readPdu(NetworkDataRepresentation ndr) {
        this.readHeader(ndr);
        this.readBody(ndr);
        this.readStub(ndr);
    }

    @Override
    protected void writePdu(NetworkDataRepresentation ndr) {
        this.writeHeader(ndr);
        this.writeBody(ndr);
        this.writeStub(ndr);
    }

    @Override
    protected void readBody(NetworkDataRepresentation ndr) {
        UUID object = null;
        NdrBuffer src = ndr.getBuffer();
        this.setAllocationHint(src.dec_ndr_long());
        this.setContextId(src.dec_ndr_short());
        this.setOpnum(src.dec_ndr_short());
        if (this.getFlag(128)) {
            object = new UUID();
            try {
                object.decode(ndr, src);
            }
            catch (NdrException ndrException) {
                // empty catch block
            }
        }
        this.setObject(object);
    }

    @Override
    protected void writeBody(NetworkDataRepresentation ndr) {
        NdrBuffer dst = ndr.getBuffer();
        dst.enc_ndr_long(this.getAllocationHint());
        dst.enc_ndr_short(this.getContextId());
        dst.enc_ndr_short(this.getOpnum());
        if (this.getFlag(128)) {
            try {
                this.getObject().encode(ndr, ndr.getBuffer());
            }
            catch (NdrException ndrException) {
                // empty catch block
            }
        }
    }

    protected void readStub(NetworkDataRepresentation ndr) {
        NdrBuffer src = ndr.getBuffer();
        src.align(8);
        byte[] stub = null;
        int length = this.getFragmentLength() - src.getIndex();
        if (length > 0) {
            stub = new byte[length];
            ndr.readOctetArray(stub, 0, length);
        }
        this.setStub(stub);
    }

    protected void writeStub(NetworkDataRepresentation ndr) {
        NdrBuffer dst = ndr.getBuffer();
        dst.align(8, (byte)0);
        byte[] stub = this.getStub();
        if (stub != null) {
            ndr.writeOctetArray(stub, 0, stub.length);
        }
    }

    @Override
    public Iterator fragment(int size) {
        byte[] stub = this.getStub();
        if (stub == null) {
            return Arrays.asList(this).iterator();
        }
        int stubSize = size - (this.getFlag(128) ? 40 : 24) - 8 - 16;
        if (stub.length <= stubSize) {
            return Arrays.asList(this).iterator();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("In fragment of RequestCoPdu, this packet will be fragmented while sending...\n");
        }
        return new FragmentIterator(stubSize);
    }

    @Override
    public Fragmentable assemble(Iterator fragments) throws IOException {
        if (!fragments.hasNext()) {
            throw new IOException("No fragments available.");
        }
        try {
            RequestCoPdu pdu = (RequestCoPdu)fragments.next();
            byte[] stub = pdu.getStub();
            if (stub == null) {
                stub = new byte[]{};
            }
            while (fragments.hasNext()) {
                RequestCoPdu fragment = (RequestCoPdu)fragments.next();
                byte[] fragmentStub = fragment.getStub();
                if (fragmentStub == null || fragmentStub.length <= 0) continue;
                byte[] tmp = new byte[stub.length + fragmentStub.length];
                System.arraycopy(stub, 0, tmp, 0, stub.length);
                System.arraycopy(fragmentStub, 0, tmp, stub.length, fragmentStub.length);
                stub = tmp;
            }
            int length = stub.length;
            if (length > 0) {
                pdu.setStub(stub);
                pdu.setAllocationHint(length);
            } else {
                pdu.setStub(null);
                pdu.setAllocationHint(0);
            }
            pdu.setFlag(1, true);
            pdu.setFlag(2, true);
            return pdu;
        }
        catch (Exception ex) {
            throw new IOException("Unable to assemble PDU fragments.");
        }
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            throw new IllegalStateException();
        }
    }

    static /* synthetic */ int access$008() {
        return callIdCounter++;
    }

    private class FragmentIterator
    implements Iterator {
        private int stubSize;
        private int index = 0;
        private int callId = RequestCoPdu.access$008();

        public FragmentIterator(int stubSize) {
            this.stubSize = stubSize;
        }

        @Override
        public boolean hasNext() {
            return this.index < RequestCoPdu.this.stub.length;
        }

        public Object next() {
            if (this.index >= RequestCoPdu.this.stub.length) {
                throw new NoSuchElementException();
            }
            RequestCoPdu fragment = (RequestCoPdu)RequestCoPdu.this.clone();
            int allocation = RequestCoPdu.this.stub.length - this.index;
            fragment.setAllocationHint(allocation);
            if (this.stubSize < allocation) {
                allocation = this.stubSize;
            }
            byte[] fragmentStub = new byte[allocation];
            System.arraycopy(RequestCoPdu.this.stub, this.index, fragmentStub, 0, allocation);
            fragment.setStub(fragmentStub);
            int flags = RequestCoPdu.this.getFlags() & 0xFFFFFFFC;
            if (this.index == 0) {
                flags |= 1;
            }
            this.index += allocation;
            if (this.index >= RequestCoPdu.this.stub.length) {
                flags |= 2;
            }
            fragment.setFlags(flags);
            fragment.setCallId(this.callId);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "In FragementIterator:next(): callIdCounter is {0} ,  for thread: {1}", new Object[]{this.callId, Thread.currentThread()});
            }
            return fragment;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

