/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.powermenu;

import android.content.Context;
import android.content.SharedPreferences;

class MenuPreferenceManager {
    private static final String position = "_POSITION";
    private static MenuPreferenceManager menuPreferenceManager;
    private final SharedPreferences sharedPreferences;

    private MenuPreferenceManager(Context context) {
        this.sharedPreferences = context.getSharedPreferences("com.skydoves.powermenu", 0);
    }

    protected static void initialize(Context context) {
        menuPreferenceManager = new MenuPreferenceManager(context);
    }

    protected static MenuPreferenceManager getInstance() {
        return menuPreferenceManager;
    }

    protected int getPosition(String name, int defaultPosition) {
        return this.sharedPreferences.getInt(name, defaultPosition);
    }

    protected void setPosition(String name, int position) {
        this.sharedPreferences.edit().putInt(name, position).apply();
    }

    protected void clearPosition(String name) {
        this.sharedPreferences.edit().remove(name).apply();
    }
}

