/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.powermenu;

import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListView;
import com.skydoves.powermenu.IMenuItem;
import com.skydoves.powermenu.MenuPreferenceManager;
import java.util.ArrayList;
import java.util.List;

public class MenuBaseAdapter<T>
extends BaseAdapter
implements IMenuItem<T> {
    private final List<T> itemList = new ArrayList<T>();
    private ListView listView;
    private int selectedPosition = -1;
    private String preferenceName;

    public MenuBaseAdapter() {
    }

    public MenuBaseAdapter(ListView listView) {
        this.listView = listView;
    }

    public int getCount() {
        return this.itemList.size();
    }

    public Object getItem(int index) {
        return this.itemList.get(index);
    }

    public long getItemId(int index) {
        return index;
    }

    public View getView(int index, View view, ViewGroup viewGroup) {
        if (view != null && this.listView != null && this.listView.getOnItemClickListener() != null) {
            view.setOnClickListener(view1 -> this.listView.getOnItemClickListener().onItemClick((AdapterView)this.listView, view1, index + this.listView.getHeaderViewsCount(), this.getItemId(index)));
        }
        return view;
    }

    @Override
    public void addItem(T item) {
        this.itemList.add(item);
        this.notifyDataSetChanged();
    }

    @Override
    public void addItem(int position, T item) {
        this.itemList.add(position, item);
        this.notifyDataSetChanged();
    }

    @Override
    public void addItemList(List<T> itemList) {
        this.itemList.addAll(itemList);
        this.notifyDataSetChanged();
    }

    @Override
    public int getSelectedPosition() {
        return this.selectedPosition;
    }

    @Override
    public void setSelectedPosition(int position) {
        this.selectedPosition = position;
        MenuPreferenceManager instance = MenuPreferenceManager.getInstance();
        if (instance != null && this.preferenceName != null) {
            instance.setPosition(this.preferenceName, position);
        }
    }

    @Override
    public ListView getListView() {
        return this.listView;
    }

    @Override
    public void setListView(ListView listView) {
        this.listView = listView;
    }

    @Override
    public void removeItem(T item) {
        this.itemList.remove(item);
    }

    @Override
    public void removeItem(int position) {
        this.itemList.remove(position);
    }

    @Override
    public void clearItems() {
        this.itemList.clear();
        this.notifyDataSetChanged();
    }

    @Override
    public List<T> getItemList() {
        return this.itemList;
    }

    @Override
    public int getContentViewHeight() {
        int totalHeight = 0;
        for (int i = 0; i < this.getCount(); ++i) {
            View view = this.getView(i, null, (ViewGroup)this.getListView());
            view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            totalHeight += view.getMeasuredHeight();
        }
        ViewGroup.LayoutParams params = this.getListView().getLayoutParams();
        params.height = totalHeight += this.getListView().getDividerHeight() * (this.getCount() - 1);
        this.getListView().setLayoutParams(params);
        return totalHeight;
    }

    public void setPreference(String preferenceName) {
        this.preferenceName = preferenceName;
    }

    public String getPreferenceName() {
        return this.preferenceName;
    }
}

