/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.powermenu;

import android.animation.Animator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ListView;
import android.widget.PopupWindow;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Px;
import androidx.annotation.StyleRes;
import androidx.cardview.widget.CardView;
import androidx.core.view.ViewCompat;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.skydoves.powermenu.AbstractMenuBuilder;
import com.skydoves.powermenu.CircularEffect;
import com.skydoves.powermenu.ConvertUtil;
import com.skydoves.powermenu.IMenuItem;
import com.skydoves.powermenu.MenuAnimation;
import com.skydoves.powermenu.MenuBaseAdapter;
import com.skydoves.powermenu.MenuPreferenceManager;
import com.skydoves.powermenu.OnDismissedListener;
import com.skydoves.powermenu.OnMenuItemClickListener;
import com.skydoves.powermenu.R;
import com.skydoves.powermenu.databinding.LayoutPowerBackgroundLibrarySkydovesBinding;
import com.skydoves.powermenu.kotlin.ContextExt;
import java.util.List;

public abstract class AbstractPowerMenu<E, T extends MenuBaseAdapter<E>>
implements IMenuItem<E>,
DefaultLifecycleObserver {
    protected View backgroundView;
    protected View menuView;
    protected CardView menuCard;
    protected PopupWindow backgroundWindow;
    protected PopupWindow menuWindow;
    protected Lifecycle.Event initializeRule;
    protected LifecycleOwner lifecycleOwner;
    protected ListView menuListView;
    protected OnMenuItemClickListener<E> menuItemClickListener;
    protected OnDismissedListener onDismissedListener;
    protected LayoutInflater layoutInflater;
    protected View headerView;
    protected View footerView;
    protected T adapter;
    protected boolean showBackground = true;
    protected boolean allowTouchBackground = false;
    protected boolean fixedHeight = false;
    protected boolean isShowing = false;
    @Px
    protected int contentViewPadding;
    private int defaultPosition;
    private CircularEffect circularEffect;
    private boolean autoDismiss;
    private boolean dismissIfShowAgain;
    private final AdapterView.OnItemClickListener itemClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> adapterView, View view, int index, long l) {
            if (AbstractPowerMenu.this.autoDismiss) {
                AbstractPowerMenu.this.dismiss();
            }
            AbstractPowerMenu.this.menuItemClickListener.onItemClick(index - AbstractPowerMenu.this.menuListView.getHeaderViewsCount(), AbstractPowerMenu.this.menuListView.getItemAtPosition(index));
        }
    };
    private final OnMenuItemClickListener<E> onMenuItemClickListener = (position, item) -> {};
    private final View.OnClickListener background_clickListener = view -> {
        if (!this.allowTouchBackground) {
            this.dismiss();
        }
    };
    @SuppressLint(value={"ClickableViewAccessibility"})
    private final View.OnTouchListener onTouchListener = (v, event) -> {
        if (event.getAction() == 4 && !this.showBackground) {
            this.dismiss();
            return true;
        }
        return false;
    };
    private final View.OnClickListener headerFooterClickListener = view -> {};

    protected AbstractPowerMenu(Context context, AbstractMenuBuilder builder) {
        this.initialize(context, builder.isMaterial);
        this.setShowBackground(builder.showBackground);
        this.setAnimation(builder.menuAnimation);
        this.setMenuRadius(builder.menuRadius);
        this.setMenuShadow(builder.menuShadow);
        this.setBackgroundColor(builder.backgroundColor);
        this.setBackgroundAlpha(builder.backgroundAlpha);
        this.setBackgroundSystemUiVisibility(builder.backgroundSystemUiVisibility);
        this.setFocusable(builder.focusable);
        this.setIsClipping(builder.isClipping);
        this.setAutoDismiss(builder.autoDismiss);
        this.setDefaultPosition(builder.defaultPosition);
        this.setDismissIfShowAgain(builder.dismissIfShowAgain);
        if (builder.lifecycleOwner != null) {
            this.setLifecycleOwner(builder.lifecycleOwner);
        } else {
            this.setLifecycleOwnerFromContext(context);
        }
        if (builder.backgroundClickListener != null) {
            this.setOnBackgroundClickListener(builder.backgroundClickListener);
        }
        if (builder.onDismissedListener != null) {
            this.setOnDismissedListener(builder.onDismissedListener);
        }
        if (builder.headerView != null) {
            this.setHeaderView(builder.headerView);
        }
        if (builder.footerView != null) {
            this.setFooterView(builder.footerView);
        }
        if (builder.animationStyle != -1) {
            this.setAnimationStyle(builder.animationStyle);
        }
        if (builder.width != 0) {
            this.setWidth(builder.width);
        }
        if (builder.height != 0) {
            this.setHeight(builder.height);
        }
        if (builder.padding != 0) {
            this.setPadding(builder.padding);
        }
        if (builder.divider != null) {
            this.setDivider(builder.divider);
        }
        if (builder.dividerHeight != 0) {
            this.setDividerHeight(builder.dividerHeight);
        }
        if (builder.preferenceName != null) {
            this.setPreferenceName(builder.preferenceName);
        }
        if (builder.initializeRule != null) {
            this.setInitializeRule(builder.initializeRule);
        }
        if (builder.circularEffect != null) {
            this.setCircularEffect(builder.circularEffect);
        }
    }

    protected void initialize(Context context, Boolean isMaterial) {
        this.layoutInflater = LayoutInflater.from((Context)context);
        assert (this.layoutInflater != null);
        this.backgroundView = LayoutPowerBackgroundLibrarySkydovesBinding.inflate(this.layoutInflater, null, false).getRoot();
        this.backgroundView.setOnClickListener(this.background_clickListener);
        this.backgroundView.setAlpha(0.5f);
        this.backgroundWindow = new PopupWindow(this.backgroundView, -1, -1);
        this.backgroundWindow.setClippingEnabled(false);
        this.menuView = this.getMenuRoot(isMaterial);
        this.menuListView = this.getMenuList(isMaterial);
        this.menuCard = this.getMenuCard(isMaterial);
        this.menuWindow = new PopupWindow(this.menuView, -2, -2);
        this.menuWindow.setInputMethodMode(1);
        this.setFocusable(false);
        this.setTouchInterceptor(this.onTouchListener);
        this.setOnMenuItemClickListener(this.onMenuItemClickListener);
        this.contentViewPadding = ConvertUtil.convertDpToPixel(10.0f, context);
        MenuPreferenceManager.initialize(context);
    }

    abstract View getMenuRoot(Boolean var1);

    abstract ListView getMenuList(Boolean var1);

    abstract CardView getMenuCard(Boolean var1);

    public void setLifecycleOwnerFromContext(@NonNull Context context) {
        if (context instanceof LifecycleOwner) {
            this.setLifecycleOwner((LifecycleOwner)context);
        }
    }

    public void setLifecycleOwner(@NonNull LifecycleOwner lifecycleOwner) {
        lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)this);
        this.lifecycleOwner = lifecycleOwner;
    }

    public void setFocusable(boolean focusable) {
        this.menuWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.menuWindow.setOutsideTouchable(!focusable);
        this.menuWindow.setFocusable(focusable);
    }

    public void setTouchInterceptor(View.OnTouchListener onTouchListener) {
        this.menuWindow.setTouchInterceptor(onTouchListener);
    }

    public OnMenuItemClickListener<E> getOnMenuItemClickListener() {
        return this.menuItemClickListener;
    }

    public void setOnMenuItemClickListener(OnMenuItemClickListener<E> menuItemClickListener) {
        this.menuItemClickListener = menuItemClickListener;
        this.menuListView.setOnItemClickListener(this.itemClickListener);
    }

    @MainThread
    private void showPopup(View anchor, Runnable function) {
        if (!this.isShowing() && ViewCompat.isAttachedToWindow((View)anchor) && !ContextExt.isFinishing(anchor.getContext())) {
            this.isShowing = true;
            anchor.post(() -> {
                if (this.showBackground) {
                    this.backgroundWindow.showAtLocation(anchor, 17, 0, 0);
                }
                this.doMenuEffect();
                function.run();
            });
        } else if (this.dismissIfShowAgain) {
            this.dismiss();
        }
    }

    public void showAsDropDown(View anchor) {
        Runnable function = () -> this.menuWindow.showAsDropDown(anchor);
        this.showPopup(anchor, function);
    }

    public void showAsDropDown(View anchor, int xOff, int yOff) {
        Runnable function = () -> this.menuWindow.showAsDropDown(anchor, xOff, yOff);
        this.showPopup(anchor, function);
    }

    public void showAsAnchorLeftTop(View anchor) {
        Runnable function = () -> this.menuWindow.showAsDropDown(anchor, 0, -anchor.getMeasuredHeight());
        this.showPopup(anchor, function);
    }

    public void showAsAnchorLeftTop(View anchor, int xOff, int yOff) {
        Runnable function = () -> this.menuWindow.showAsDropDown(anchor, xOff, yOff - anchor.getMeasuredHeight());
        this.showPopup(anchor, function);
    }

    public void showAsAnchorLeftBottom(View anchor) {
        Runnable function = () -> this.menuWindow.showAsDropDown(anchor, 0, -this.getContentViewPadding());
        this.showPopup(anchor, function);
    }

    public void showAsAnchorLeftBottom(View anchor, int xOff, int yOff) {
        Runnable function = () -> this.menuWindow.showAsDropDown(anchor, xOff, yOff - this.getContentViewPadding());
        this.showPopup(anchor, function);
    }

    public void showAsAnchorRightTop(View anchor) {
        Runnable function = () -> this.menuWindow.showAsDropDown(anchor, anchor.getMeasuredWidth() / 2 + this.getContentViewWidth() / 2, -anchor.getMeasuredHeight());
        this.showPopup(anchor, function);
    }

    public void showAsAnchorRightTop(View anchor, int xOff, int yOff) {
        Runnable function = () -> this.menuWindow.showAsDropDown(anchor, xOff + anchor.getMeasuredWidth() / 2 + this.getContentViewWidth() / 2, yOff - anchor.getMeasuredHeight());
        this.showPopup(anchor, function);
    }

    public void showAsAnchorRightBottom(View anchor) {
        Runnable function = () -> this.menuWindow.showAsDropDown(anchor, anchor.getMeasuredWidth() / 2 + this.getContentViewWidth() / 2, -this.getContentViewPadding());
        this.showPopup(anchor, function);
    }

    public void showAsAnchorRightBottom(View anchor, int xOff, int yOff) {
        Runnable function = () -> this.menuWindow.showAsDropDown(anchor, xOff + anchor.getMeasuredWidth() / 2 + this.getContentViewWidth() / 2, yOff - this.getContentViewPadding());
        this.showPopup(anchor, function);
    }

    public void showAsAnchorCenter(View anchor) {
        Runnable function = () -> this.menuWindow.showAsDropDown(anchor, anchor.getMeasuredWidth() / 2 - this.getContentViewWidth() / 2, -anchor.getMeasuredHeight() / 2 - this.getContentViewHeight() / 2);
        this.showPopup(anchor, function);
    }

    public void showAsAnchorCenter(View anchor, int xOff, int yOff) {
        Runnable function = () -> this.menuWindow.showAsDropDown(anchor, xOff + anchor.getMeasuredWidth() / 2 - this.getContentViewWidth() / 2, yOff - anchor.getMeasuredHeight() / 2 - this.getContentViewHeight() / 2);
        this.showPopup(anchor, function);
    }

    public void showAtCenter(View anchor) {
        Runnable function = () -> this.menuWindow.showAtLocation(anchor, 17, 0, 0);
        this.showPopup(anchor, function);
    }

    public void showAtCenter(View anchor, int xOff, int yOff) {
        Runnable function = () -> this.menuWindow.showAtLocation(anchor, 17, xOff, yOff);
        this.showPopup(anchor, function);
    }

    public void showAtLocation(View anchor, int xOff, int yOff) {
        Runnable function = () -> this.menuWindow.showAtLocation(anchor, 0, xOff, yOff);
        this.showPopup(anchor, function);
    }

    public void showAtLocation(View anchor, int gravity, int xOff, int yOff) {
        Runnable function = () -> this.menuWindow.showAtLocation(anchor, gravity, xOff, yOff);
        this.showPopup(anchor, function);
    }

    private void doMenuEffect() {
        if (this.getCircularEffect() != null) {
            if (this.getCircularEffect().equals((Object)CircularEffect.BODY)) {
                this.circularRevealed(this.menuWindow.getContentView());
            } else if (this.getCircularEffect().equals((Object)CircularEffect.INNER)) {
                this.circularRevealed((View)this.getListView());
            }
        }
    }

    private void circularRevealed(View targetView) {
        targetView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                if (Build.VERSION.SDK_INT >= 21) {
                    Animator animator = ViewAnimationUtils.createCircularReveal((View)view, (int)((view.getLeft() + view.getRight()) / 2), (int)((view.getTop() + view.getBottom()) / 2), (float)0.0f, (float)Math.max(view.getWidth(), view.getHeight()));
                    animator.setDuration(900L);
                    animator.start();
                }
            }
        });
    }

    public void dismiss() {
        if (this.isShowing()) {
            this.menuWindow.dismiss();
            this.backgroundWindow.dismiss();
            this.isShowing = false;
            if (this.onDismissedListener != null) {
                this.onDismissedListener.onDismissed();
            }
        }
    }

    public boolean isShowing() {
        return this.isShowing;
    }

    public int getContentViewWidth() {
        int width = this.menuWindow.getContentView().getWidth();
        if (width == 0) {
            return this.getMeasuredContentView().getMeasuredWidth();
        }
        return width;
    }

    @Override
    public int getContentViewHeight() {
        int height = this.menuWindow.getContentView().getHeight();
        if (height == 0) {
            height += ((MenuBaseAdapter)this.getAdapter()).getContentViewHeight() + this.getContentViewPadding();
            if (this.getHeaderView() != null) {
                height += this.getHeaderView().getMeasuredHeight();
            }
            if (this.getFooterView() != null) {
                height += this.getFooterView().getMeasuredHeight();
            }
        }
        return height;
    }

    protected View getMeasuredContentView() {
        View contentView = this.menuWindow.getContentView();
        contentView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        return contentView;
    }

    protected int getContentViewPadding() {
        return this.contentViewPadding;
    }

    public void setWidth(@Px int width) {
        this.menuWindow.setWidth(width);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.menuListView.getLayoutParams();
        layoutParams.width = width - this.contentViewPadding;
        this.getMenuListView().setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setHeight(@Px int height) {
        this.fixedHeight = true;
        this.menuWindow.setHeight(height);
    }

    public void setPadding(@Px int padding) {
        this.menuListView.setPadding(padding, padding, padding, padding);
    }

    protected void setMeasuredHeight(@Px int height) {
        this.menuWindow.setHeight(height);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.menuListView.getLayoutParams();
        layoutParams.height = height - this.contentViewPadding;
        this.getMenuListView().setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setDividerHeight(@Px int height) {
        this.menuListView.setDividerHeight(height);
    }

    public void setDivider(Drawable divider) {
        this.menuListView.setDivider(divider);
    }

    public void setShowBackground(boolean show) {
        this.showBackground = show;
    }

    public void setOnDismissedListener(OnDismissedListener onDismissedListener) {
        this.onDismissedListener = onDismissedListener;
    }

    public void setOnBackgroundClickListener(View.OnClickListener onBackgroundClickListener) {
        this.backgroundView.setOnClickListener(onBackgroundClickListener);
    }

    public void setAnimation(@NonNull MenuAnimation menuAnimation) {
        if (menuAnimation == MenuAnimation.NONE) {
            this.menuWindow.setAnimationStyle(0);
        } else if (menuAnimation == MenuAnimation.DROP_DOWN) {
            this.menuWindow.setAnimationStyle(-1);
        } else if (menuAnimation == MenuAnimation.FADE) {
            this.menuWindow.setAnimationStyle(R.style.FadeMenuAnimation);
            this.backgroundWindow.setAnimationStyle(R.style.FadeMenuAnimation);
        } else if (menuAnimation == MenuAnimation.SHOWUP_BOTTOM_LEFT) {
            this.menuWindow.setAnimationStyle(R.style.ShowUpAnimation_BL);
        } else if (menuAnimation == MenuAnimation.SHOWUP_BOTTOM_RIGHT) {
            this.menuWindow.setAnimationStyle(R.style.ShowUpAnimation_BR);
        } else if (menuAnimation == MenuAnimation.SHOWUP_TOP_LEFT) {
            this.menuWindow.setAnimationStyle(R.style.ShowUpAnimation_TL);
        } else if (menuAnimation == MenuAnimation.SHOWUP_TOP_RIGHT) {
            this.menuWindow.setAnimationStyle(R.style.ShowUpAnimation_TR);
        } else if (menuAnimation == MenuAnimation.SHOW_UP_CENTER) {
            this.menuWindow.setAnimationStyle(R.style.ShowUpAnimation_Center);
        } else if (menuAnimation == MenuAnimation.ELASTIC_BOTTOM_LEFT) {
            this.menuWindow.setAnimationStyle(R.style.ElasticMenuAnimation_BL);
        } else if (menuAnimation == MenuAnimation.ELASTIC_BOTTOM_RIGHT) {
            this.menuWindow.setAnimationStyle(R.style.ElasticMenuAnimation_BR);
        } else if (menuAnimation == MenuAnimation.ELASTIC_TOP_LEFT) {
            this.menuWindow.setAnimationStyle(R.style.ElasticMenuAnimation_TL);
        } else if (menuAnimation == MenuAnimation.ELASTIC_TOP_RIGHT) {
            this.menuWindow.setAnimationStyle(R.style.ElasticMenuAnimation_TR);
        } else if (menuAnimation == MenuAnimation.ELASTIC_CENTER) {
            this.menuWindow.setAnimationStyle(R.style.ElasticMenuAnimation_Center);
        }
    }

    public void setAnimationStyle(@StyleRes int style2) {
        this.menuWindow.setAnimationStyle(style2);
    }

    public void setMenuRadius(@Px float radius) {
        this.menuCard.setRadius(radius);
    }

    public void setMenuShadow(@Px float shadow) {
        this.menuCard.setCardElevation(shadow);
    }

    public void setIsClipping(boolean isClipping) {
        this.menuWindow.setClippingEnabled(isClipping);
    }

    public void setSelection(int position) {
        this.menuListView.setSelection(position);
    }

    public void setBackgroundColor(@ColorInt int color) {
        this.backgroundView.setBackgroundColor(color);
    }

    public void setBackgroundAlpha(@FloatRange(from=0.0, to=1.0) float alpha) {
        this.backgroundView.setAlpha(alpha);
    }

    public void setBackgroundSystemUiVisibility(int visibility) {
        this.backgroundView.setSystemUiVisibility(visibility);
    }

    public void setHeaderView(View view) {
        if (this.headerView == null) {
            this.menuListView.addHeaderView(view);
            this.headerView = view;
            this.headerView.setOnClickListener(this.headerFooterClickListener);
            this.headerView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        }
    }

    public void setHeaderView(View view, Object data, boolean isSelectable) {
        if (this.headerView == null) {
            this.menuListView.addHeaderView(view, data, isSelectable);
            this.headerView = view;
            this.headerView.setOnClickListener(this.headerFooterClickListener);
            this.headerView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        }
    }

    public void setHeaderView(int layout2) {
        if (this.headerView == null) {
            View view = this.layoutInflater.inflate(layout2, null, false);
            this.setHeaderView(view);
        }
    }

    public void setFooterView(View view) {
        if (this.footerView == null) {
            this.menuListView.addFooterView(view);
            this.footerView = view;
            this.footerView.setOnClickListener(this.headerFooterClickListener);
            this.footerView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        }
    }

    public void setFooterView(View view, Object data, boolean isSelectable) {
        if (this.footerView == null) {
            this.menuListView.addFooterView(view, data, isSelectable);
            this.footerView = view;
            this.footerView.setOnClickListener(this.headerFooterClickListener);
            this.footerView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        }
    }

    public void setFooterView(int layout2) {
        if (this.footerView == null) {
            View view = this.layoutInflater.inflate(layout2, null, false);
            this.setFooterView(view);
        }
    }

    private boolean checkRuleValidates(@NonNull Lifecycle.Event event) {
        return this.getInitializeRule() != null && this.getInitializeRule().equals((Object)event);
    }

    public void invokeOnMenuListener(int position) {
        if (position >= 0 && position < this.getItemList().size() && this.getOnMenuItemClickListener() != null) {
            this.getOnMenuItemClickListener().onItemClick(this.getPreferencePosition(position), this.getItemList().get(this.getPreferencePosition(position)));
        }
    }

    public void onCreate(@NonNull LifecycleOwner owner) {
        if (this.checkRuleValidates(Lifecycle.Event.ON_CREATE)) {
            this.invokeOnMenuListener(this.defaultPosition);
        }
    }

    public void onStart(@NonNull LifecycleOwner owner) {
        if (this.checkRuleValidates(Lifecycle.Event.ON_START)) {
            this.invokeOnMenuListener(this.defaultPosition);
        }
    }

    public void onResume(@NonNull LifecycleOwner owner) {
        if (this.checkRuleValidates(Lifecycle.Event.ON_RESUME)) {
            this.invokeOnMenuListener(this.defaultPosition);
        }
    }

    public void onDestroy(@NonNull LifecycleOwner owner) {
        this.dismiss();
    }

    public T getAdapter() {
        return this.adapter;
    }

    @Override
    public void addItem(E item) {
        ((MenuBaseAdapter)this.getAdapter()).addItem(item);
    }

    @Override
    public void addItem(int position, E item) {
        ((MenuBaseAdapter)this.getAdapter()).addItem(position, item);
    }

    @Override
    public void addItemList(List<E> itemList) {
        ((MenuBaseAdapter)this.getAdapter()).addItemList(itemList);
    }

    @Override
    public ListView getListView() {
        return ((MenuBaseAdapter)this.getAdapter()).getListView();
    }

    @Override
    public void setListView(ListView listView) {
        ((MenuBaseAdapter)this.getAdapter()).setListView(this.getMenuListView());
    }

    @Override
    public int getSelectedPosition() {
        return ((MenuBaseAdapter)this.getAdapter()).getSelectedPosition();
    }

    @Override
    public void setSelectedPosition(int position) {
        ((MenuBaseAdapter)this.getAdapter()).setSelectedPosition(position);
    }

    @Override
    public void removeItem(E item) {
        ((MenuBaseAdapter)this.getAdapter()).removeItem(item);
    }

    @Override
    public void removeItem(int position) {
        ((MenuBaseAdapter)this.getAdapter()).removeItem(position);
    }

    @Override
    public void clearItems() {
        ((MenuBaseAdapter)this.getAdapter()).clearItems();
    }

    @Override
    public List<E> getItemList() {
        return ((MenuBaseAdapter)this.getAdapter()).getItemList();
    }

    public ListView getMenuListView() {
        return this.menuListView;
    }

    public View getHeaderView() {
        return this.headerView;
    }

    public View getFooterView() {
        return this.footerView;
    }

    public void setAutoDismiss(boolean autoDismiss) {
        this.autoDismiss = autoDismiss;
    }

    public void setDismissIfShowAgain(boolean dismissIfShowAgain) {
        this.dismissIfShowAgain = dismissIfShowAgain;
    }

    public String getPreferenceName() {
        return ((MenuBaseAdapter)this.getAdapter()).getPreferenceName();
    }

    public int getPreferencePosition(int defaultPosition) {
        return MenuPreferenceManager.getInstance().getPosition(((MenuBaseAdapter)this.getAdapter()).getPreferenceName(), defaultPosition);
    }

    public void setPreferencePosition(int defaultPosition) {
        MenuPreferenceManager instance = MenuPreferenceManager.getInstance();
        if (instance != null && this.getPreferenceName() != null) {
            instance.setPosition(this.getPreferenceName(), defaultPosition);
        }
    }

    private void setPreferenceName(@NonNull String preferenceName) {
        ((MenuBaseAdapter)this.getAdapter()).setPreference(preferenceName);
    }

    public void clearPreference() {
        if (((MenuBaseAdapter)this.getAdapter()).getPreferenceName() != null) {
            MenuPreferenceManager.getInstance().clearPosition(((MenuBaseAdapter)this.getAdapter()).getPreferenceName());
        }
    }

    private void setInitializeRule(@NonNull Lifecycle.Event event) {
        this.initializeRule = event;
    }

    private Lifecycle.Event getInitializeRule() {
        return this.initializeRule;
    }

    private void setDefaultPosition(int defaultPosition) {
        this.defaultPosition = defaultPosition;
    }

    public CircularEffect getCircularEffect() {
        return this.circularEffect;
    }

    public void setCircularEffect(@NonNull CircularEffect circularEffect) {
        this.circularEffect = circularEffect;
    }
}

