/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.balloon.radius;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.skydoves.balloon.ArrowOrientation;
import com.skydoves.balloon.internals.ViewPropertyDelegate;
import com.skydoves.balloon.internals.ViewPropertyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007J\u0016\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0007J(\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007H\u0016J\u0006\u0010D\u001a\u00020\u0014J(\u0010E\u001a\u00020\u00142\u0006\u0010F\u001a\u00020\u00072\u0006\u0010G\u001a\u00020\u00072\u0006\u0010H\u001a\u00020\u00072\u0006\u0010I\u001a\u00020\u0007H\u0014J\u0006\u0010J\u001a\u00020\u0014J\u0010\u0010K\u001a\u00020\u00142\u0006\u0010L\u001a\u00020MH\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R(\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010 \u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u001f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010/\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u00108F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b3\u00104\u001a\u0004\b0\u0010\u0012\"\u0004\b1\u00102R$\u00105\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0012\"\u0004\b7\u00102R$\u00108\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u0012\"\u0004\b:\u00102R$\u0010;\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u0012\"\u0004\b=\u00102R$\u0010?\u001a\u00020>2\u0006\u0010\u0018\u001a\u00020>@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010C\u00a8\u0006N"}, d2={"Lcom/skydoves/balloon/radius/RadiusLayout;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "path", "Landroid/graphics/Path;", "fillPaint", "Landroid/graphics/Paint;", "strokePaint", "halfStroke", "", "getHalfStroke", "()F", "setFillColor", "", "color", "setStroke", "thickness", "value", "Landroid/graphics/drawable/Drawable;", "customShapeBackgroundDrawable", "getCustomShapeBackgroundDrawable", "()Landroid/graphics/drawable/Drawable;", "setCustomShapeBackgroundDrawable", "(Landroid/graphics/drawable/Drawable;)V", "", "drawCustomShape", "getDrawCustomShape", "()Z", "setDrawCustomShape", "(Z)V", "basePaddingLeft", "basePaddingTop", "basePaddingRight", "basePaddingBottom", "setPadding", "left", "top", "right", "bottom", "<set-?>", "radius", "getRadius", "setRadius", "(F)V", "radius$delegate", "Lcom/skydoves/balloon/internals/ViewPropertyDelegate;", "arrowHeight", "getArrowHeight", "setArrowHeight", "arrowWidth", "getArrowWidth", "setArrowWidth", "arrowPositionRatio", "getArrowPositionRatio", "setArrowPositionRatio", "Lcom/skydoves/balloon/ArrowOrientation;", "arrowOrientation", "getArrowOrientation", "()Lcom/skydoves/balloon/ArrowOrientation;", "setArrowOrientation", "(Lcom/skydoves/balloon/ArrowOrientation;)V", "updateEffectivePadding", "onSizeChanged", "w", "h", "oldw", "oldh", "rebuildPath", "dispatchDraw", "canvas", "Landroid/graphics/Canvas;", "balloon_release"})
@SourceDebugExtension(value={"SMAP\nRadiusLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadiusLayout.kt\ncom/skydoves/balloon/radius/RadiusLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,301:1\n1#2:302\n*E\n"})
public final class RadiusLayout
extends FrameLayout {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Path path;
    @NotNull
    private final Paint fillPaint;
    @NotNull
    private final Paint strokePaint;
    @Nullable
    private Drawable customShapeBackgroundDrawable;
    private boolean drawCustomShape;
    private int basePaddingLeft;
    private int basePaddingTop;
    private int basePaddingRight;
    private int basePaddingBottom;
    @NotNull
    private final ViewPropertyDelegate radius$delegate;
    private float arrowHeight;
    private float arrowWidth;
    private float arrowPositionRatio;
    @NotNull
    private ArrowOrientation arrowOrientation;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public RadiusLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        void $this$strokePaint_u24lambda_u240;
        Paint $this$fillPaint_u24lambda_u240;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.setWillNotDraw(false);
        this.path = new Path();
        Paint paint2 = paint = new Paint(1);
        RadiusLayout radiusLayout = this;
        boolean bl = false;
        $this$fillPaint_u24lambda_u240.setStyle(Paint.Style.FILL);
        radiusLayout.fillPaint = paint;
        $this$fillPaint_u24lambda_u240 = paint = new Paint(1);
        radiusLayout = this;
        boolean bl2 = false;
        $this$strokePaint_u24lambda_u240.setStyle(Paint.Style.STROKE);
        $this$strokePaint_u24lambda_u240.setStrokeJoin(Paint.Join.MITER);
        radiusLayout.strokePaint = paint;
        this.radius$delegate = ViewPropertyKt.viewProperty((View)this, Float.valueOf(0.0f));
        this.arrowPositionRatio = 0.5f;
        this.arrowOrientation = ArrowOrientation.BOTTOM;
    }

    public /* synthetic */ RadiusLayout(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final float getHalfStroke() {
        return this.strokePaint.getStrokeWidth() > 0.0f ? this.strokePaint.getStrokeWidth() / 2.0f : 0.0f;
    }

    public final void setFillColor(int color) {
        this.fillPaint.setColor(color);
        this.invalidate();
    }

    public final void setStroke(float thickness, int color) {
        this.strokePaint.setStrokeWidth(thickness * 1.5f);
        this.strokePaint.setColor(color);
        this.invalidate();
    }

    @Nullable
    public final Drawable getCustomShapeBackgroundDrawable() {
        return this.customShapeBackgroundDrawable;
    }

    public final void setCustomShapeBackgroundDrawable(@Nullable Drawable value2) {
        if (!Intrinsics.areEqual((Object)this.customShapeBackgroundDrawable, (Object)value2)) {
            this.customShapeBackgroundDrawable = value2;
            Drawable drawable = value2;
            if (drawable != null) {
                drawable.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
            this.invalidate();
        }
    }

    public final boolean getDrawCustomShape() {
        return this.drawCustomShape;
    }

    public final void setDrawCustomShape(boolean value2) {
        if (this.drawCustomShape != value2) {
            this.drawCustomShape = value2;
            this.setWillNotDraw(!value2);
            this.invalidate();
        }
    }

    public void setPadding(int left, int top, int right, int bottom) {
        this.basePaddingLeft = left;
        this.basePaddingTop = top;
        this.basePaddingRight = right;
        this.basePaddingBottom = bottom;
        if (this.drawCustomShape) {
            this.updateEffectivePadding();
        } else {
            super.setPadding(left, top, right, bottom);
        }
    }

    public final float getRadius() {
        return ((Number)this.radius$delegate.getValue((Object)this, $$delegatedProperties[0])).floatValue();
    }

    public final void setRadius(float f) {
        this.radius$delegate.setValue((Object)this, $$delegatedProperties[0], Float.valueOf(f));
    }

    public final float getArrowHeight() {
        return this.arrowHeight;
    }

    public final void setArrowHeight(float value2) {
        if (!(this.arrowHeight == value2)) {
            this.arrowHeight = value2;
            if (this.drawCustomShape) {
                this.rebuildPath();
            }
            if (this.drawCustomShape) {
                this.updateEffectivePadding();
            }
        }
    }

    public final float getArrowWidth() {
        return this.arrowWidth;
    }

    public final void setArrowWidth(float value2) {
        if (!(this.arrowWidth == value2)) {
            this.arrowWidth = value2;
            if (this.drawCustomShape) {
                this.rebuildPath();
            }
        }
    }

    public final float getArrowPositionRatio() {
        return this.arrowPositionRatio;
    }

    public final void setArrowPositionRatio(float value2) {
        if (!(this.arrowPositionRatio == value2)) {
            this.arrowPositionRatio = value2;
            if (this.drawCustomShape) {
                this.rebuildPath();
            }
        }
    }

    @NotNull
    public final ArrowOrientation getArrowOrientation() {
        return this.arrowOrientation;
    }

    public final void setArrowOrientation(@NotNull ArrowOrientation value2) {
        Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
        if (this.arrowOrientation != value2) {
            this.arrowOrientation = value2;
            if (this.drawCustomShape) {
                this.rebuildPath();
            }
            if (this.drawCustomShape) {
                this.updateEffectivePadding();
            }
        }
    }

    public final void updateEffectivePadding() {
        if (!this.drawCustomShape) {
            return;
        }
        float protrusion = this.arrowHeight * 0.5f;
        float extra = protrusion + this.getHalfStroke();
        int effectiveLeft = this.basePaddingLeft + (this.arrowOrientation == ArrowOrientation.START ? (int)extra : 0);
        int effectiveTop = this.basePaddingTop + (this.arrowOrientation == ArrowOrientation.TOP ? (int)extra : 0);
        int effectiveRight = this.basePaddingRight + (this.arrowOrientation == ArrowOrientation.END ? (int)extra : 0);
        int effectiveBottom = this.basePaddingBottom + (this.arrowOrientation == ArrowOrientation.BOTTOM ? (int)extra : 0);
        super.setPadding(effectiveLeft, effectiveTop, effectiveRight, effectiveBottom);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        Path path;
        super.onSizeChanged(w, h, oldw, oldh);
        Path $this$onSizeChanged_u24lambda_u240 = path = this.path;
        boolean bl = false;
        $this$onSizeChanged_u24lambda_u240.rewind();
        $this$onSizeChanged_u24lambda_u240.addRoundRect(new RectF(0.0f, 0.0f, (float)w, (float)h), this.getRadius(), this.getRadius(), Path.Direction.CW);
        if (this.drawCustomShape) {
            this.rebuildPath();
            this.updateEffectivePadding();
            Drawable drawable = this.customShapeBackgroundDrawable;
            if (drawable != null) {
                drawable.setBounds(0, 0, w, h);
            }
            this.requestLayout();
        }
    }

    public final void rebuildPath() {
        this.path.reset();
        if (!this.drawCustomShape || this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        float protrusion = this.arrowHeight * 0.5f;
        float extra = protrusion + this.getHalfStroke();
        float rectLeft = this.arrowOrientation == ArrowOrientation.START ? extra : this.getHalfStroke();
        float rectTop = this.arrowOrientation == ArrowOrientation.TOP ? extra : this.getHalfStroke();
        float rectRight = this.arrowOrientation == ArrowOrientation.END ? (float)this.getWidth() - extra : (float)this.getWidth() - this.getHalfStroke();
        float rectBottom = this.arrowOrientation == ArrowOrientation.BOTTOM ? (float)this.getHeight() - extra : (float)this.getHeight() - this.getHalfStroke();
        float centerX = RangesKt.coerceIn((float)((float)this.getWidth() * this.arrowPositionRatio), (float)(this.arrowWidth / 2.0f + this.getHalfStroke()), (float)((float)this.getWidth() - this.arrowWidth / 2.0f - this.getHalfStroke()));
        float centerY = RangesKt.coerceIn((float)((float)this.getHeight() * this.arrowPositionRatio), (float)(this.arrowWidth / 2.0f + this.getHalfStroke()), (float)((float)this.getHeight() - this.arrowWidth / 2.0f - this.getHalfStroke()));
        switch (WhenMappings.$EnumSwitchMapping$0[this.arrowOrientation.ordinal()]) {
            case 1: {
                float tipY = rectTop - protrusion;
                this.path.moveTo(rectLeft + this.getRadius(), rectBottom);
                this.path.lineTo(rectRight - this.getRadius(), rectBottom);
                this.path.quadTo(rectRight, rectBottom, rectRight, rectBottom - this.getRadius());
                this.path.lineTo(rectRight, rectTop + this.getRadius());
                this.path.quadTo(rectRight, rectTop, rectRight - this.getRadius(), rectTop);
                this.path.lineTo(centerX + this.arrowWidth / 2.0f, rectTop);
                this.path.lineTo(centerX, tipY);
                this.path.lineTo(centerX - this.arrowWidth / 2.0f, rectTop);
                this.path.lineTo(rectLeft + this.getRadius(), rectTop);
                this.path.quadTo(rectLeft, rectTop, rectLeft, rectTop + this.getRadius());
                this.path.lineTo(rectLeft, rectBottom - this.getRadius());
                this.path.quadTo(rectLeft, rectBottom, rectLeft + this.getRadius(), rectBottom);
                break;
            }
            case 2: {
                float tipY = rectBottom + protrusion;
                this.path.moveTo(this.getRadius() + rectLeft, rectTop);
                this.path.lineTo(rectRight - this.getRadius(), rectTop);
                this.path.quadTo(rectRight, rectTop, rectRight, rectTop + this.getRadius());
                this.path.lineTo(rectRight, rectBottom - this.getRadius());
                this.path.quadTo(rectRight, rectBottom, rectRight - this.getRadius(), rectBottom);
                this.path.lineTo(centerX + this.arrowWidth / 2.0f, rectBottom);
                this.path.lineTo(centerX, tipY);
                this.path.lineTo(centerX - this.arrowWidth / 2.0f, rectBottom);
                this.path.lineTo(rectLeft + this.getRadius(), rectBottom);
                this.path.quadTo(rectLeft, rectBottom, rectLeft, rectBottom - this.getRadius());
                this.path.lineTo(rectLeft, rectTop + this.getRadius());
                this.path.quadTo(rectLeft, rectTop, rectLeft + this.getRadius(), rectTop);
                break;
            }
            case 3: {
                float tipX = rectLeft - protrusion;
                this.path.moveTo(rectLeft + this.getRadius(), rectTop);
                this.path.lineTo(rectRight - this.getRadius(), rectTop);
                this.path.quadTo(rectRight, rectTop, rectRight, rectTop + this.getRadius());
                this.path.lineTo(rectRight, rectBottom - this.getRadius());
                this.path.quadTo(rectRight, rectBottom, rectRight - this.getRadius(), rectBottom);
                this.path.lineTo(rectLeft + this.getRadius(), rectBottom);
                this.path.quadTo(rectLeft, rectBottom, rectLeft, rectBottom - this.getRadius());
                this.path.lineTo(rectLeft, centerY + this.arrowWidth / 2.0f);
                this.path.lineTo(tipX, centerY);
                this.path.lineTo(rectLeft, centerY - this.arrowWidth / 2.0f);
                this.path.lineTo(rectLeft, rectTop + this.getRadius());
                this.path.quadTo(rectLeft, rectTop, rectLeft + this.getRadius(), rectTop);
                break;
            }
            case 4: {
                float tipX = rectRight + protrusion;
                this.path.moveTo(rectLeft + this.getRadius(), rectTop);
                this.path.lineTo(rectRight - this.getRadius(), rectTop);
                this.path.quadTo(rectRight, rectTop, rectRight, rectTop + this.getRadius());
                this.path.lineTo(rectRight, centerY - this.arrowWidth / 2.0f);
                this.path.lineTo(tipX, centerY);
                this.path.lineTo(rectRight, centerY + this.arrowWidth / 2.0f);
                this.path.lineTo(rectRight, rectBottom - this.getRadius());
                this.path.quadTo(rectRight, rectBottom, rectRight - this.getRadius(), rectBottom);
                this.path.lineTo(rectLeft + this.getRadius(), rectBottom);
                this.path.quadTo(rectLeft, rectBottom, rectLeft, rectBottom - this.getRadius());
                this.path.lineTo(rectLeft, rectTop + this.getRadius());
                this.path.quadTo(rectLeft, rectTop, rectLeft + this.getRadius(), rectTop);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.path.close();
        this.invalidate();
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.drawCustomShape && !this.path.isEmpty()) {
            int save = canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), null);
            if (this.strokePaint.getStrokeWidth() > 0.0f) {
                canvas.drawPath(this.path, this.strokePaint);
            }
            canvas.clipPath(this.path);
            if (this.customShapeBackgroundDrawable != null) {
                Drawable drawable = this.customShapeBackgroundDrawable;
                if (drawable != null) {
                    drawable.draw(canvas);
                }
            } else {
                canvas.drawPath(this.path, this.fillPaint);
            }
            super.dispatchDraw(canvas);
            canvas.restoreToCount(save);
        } else {
            super.dispatchDraw(canvas);
        }
    }

    @JvmOverloads
    public RadiusLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public RadiusLayout(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(RadiusLayout.class, "radius", "getRadius()F", 0)))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ArrowOrientation.values().length];
            try {
                nArray[ArrowOrientation.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArrowOrientation.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArrowOrientation.START.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArrowOrientation.END.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

