/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.balloon.extensions;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import androidx.activity.ComponentActivity;
import androidx.annotation.DimenRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\u0016\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\b\b\u0001\u0010\u0007\u001a\u00020\u0001H\u0000\u001a\f\u0010\b\u001a\u00020\t*\u00020\u0002H\u0000\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0000\u001a\u0014\u0010\n\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u0002H\u0000\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0002H\u0000\u00a8\u0006\u0011"}, d2={"contextColor", "", "Landroid/content/Context;", "resource", "contextDrawable", "Landroid/graphics/drawable/Drawable;", "dimen", "dimenRes", "displaySize", "Landroid/graphics/Point;", "dp2Px", "", "dp", "getActivity", "Landroidx/activity/ComponentActivity;", "isFinishing", "", "balloon_release"})
public final class ContextExtensionKt {
    @NotNull
    public static final Point displaySize(@NotNull Context $this$displaySize) {
        Intrinsics.checkNotNullParameter((Object)$this$displaySize, (String)"$this$displaySize");
        Resources resources = $this$displaySize.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        int n = resources.getDisplayMetrics().widthPixels;
        Resources resources2 = $this$displaySize.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources2, (String)"resources");
        return new Point(n, resources2.getDisplayMetrics().heightPixels);
    }

    public static final int dp2Px(@NotNull Context $this$dp2Px, int dp) {
        Intrinsics.checkNotNullParameter((Object)$this$dp2Px, (String)"$this$dp2Px");
        Resources resources = $this$dp2Px.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        float scale = resources.getDisplayMetrics().density;
        return (int)((float)dp * scale);
    }

    public static final float dp2Px(@NotNull Context $this$dp2Px, float dp) {
        Intrinsics.checkNotNullParameter((Object)$this$dp2Px, (String)"$this$dp2Px");
        Resources resources = $this$dp2Px.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        float scale = resources.getDisplayMetrics().density;
        return dp * scale;
    }

    public static final int dimen(@NotNull Context $this$dimen, @DimenRes int dimenRes) {
        Intrinsics.checkNotNullParameter((Object)$this$dimen, (String)"$this$dimen");
        return $this$dimen.getResources().getDimensionPixelSize(dimenRes);
    }

    public static final int contextColor(@NotNull Context $this$contextColor, int resource) {
        Intrinsics.checkNotNullParameter((Object)$this$contextColor, (String)"$this$contextColor");
        return ContextCompat.getColor((Context)$this$contextColor, (int)resource);
    }

    @Nullable
    public static final Drawable contextDrawable(@NotNull Context $this$contextDrawable, int resource) {
        Intrinsics.checkNotNullParameter((Object)$this$contextDrawable, (String)"$this$contextDrawable");
        return AppCompatResources.getDrawable((Context)$this$contextDrawable, (int)resource);
    }

    public static final boolean isFinishing(@NotNull Context $this$isFinishing) {
        Intrinsics.checkNotNullParameter((Object)$this$isFinishing, (String)"$this$isFinishing");
        return $this$isFinishing instanceof Activity && ((Activity)$this$isFinishing).isFinishing();
    }

    @Nullable
    public static final ComponentActivity getActivity(@NotNull Context $this$getActivity) {
        Intrinsics.checkNotNullParameter((Object)$this$getActivity, (String)"$this$getActivity");
        Context context = $this$getActivity;
        while (context instanceof ContextWrapper) {
            if (context instanceof ComponentActivity) {
                return (ComponentActivity)context;
            }
            Intrinsics.checkNotNullExpressionValue((Object)((ContextWrapper)context).getBaseContext(), (String)"context.baseContext");
        }
        return null;
    }
}

